/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionEngine;
import org.eclipse.cdt.internal.ui.text.contentassist.ResultCollector;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.FunctionPrototypeSummary;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class CCompletionProcessor
implements IContentAssistProcessor {
    private CEditor fEditor;
    private char[] fProposalAutoActivationSet;
    private CCompletionProposalComparator fComparator;
    private IContextInformationValidator fValidator;
    private TemplateEngine[] fGlobalContextTemplateEngine;
    private TemplateEngine[] fFunctionContextTemplateEngine;
    private TemplateEngine[] fStructureContextTemplateEngine;
    private boolean fRestrictToMatchingCase;
    private boolean fAllowAddIncludes;
    private BasicSearchResultCollector searchResultCollector = null;
    private ResultCollector resultCollector = null;
    private CompletionEngine completionEngine = null;
    private SearchEngine searchEngine = null;
    private CSearchResultLabelProvider labelProvider = null;
    private int fCurrentOffset = 0;
    private IWorkingCopy fCurrentSourceUnit = null;
    private IASTCompletionNode fCurrentCompletionNode = null;
    private int fNumberOfComputedResults = 0;
    private ITextViewer fTextViewer;

    public CCompletionProcessor(IEditorPart editor) {
        this.fEditor = (CEditor)editor;
        this.labelProvider = new CSearchResultLabelProvider();
        this.searchResultCollector = new BasicSearchResultCollector();
        this.resultCollector = new ResultCollector();
        this.completionEngine = new CompletionEngine(this.resultCollector);
        this.searchEngine = new SearchEngine();
        this.searchEngine.setWaitingPolicy(1);
        this.setupTemplateEngine();
        this.fRestrictToMatchingCase = false;
        this.fAllowAddIncludes = true;
        this.fComparator = new CCompletionProposalComparator();
    }

    private boolean isCppContext() {
        String filename = null;
        if (this.fEditor != null && this.fEditor.getEditorInput() != null) {
            filename = this.fEditor.getEditorInput().getName();
        }
        if (filename == null) {
            return true;
        }
        if (filename.endsWith(".c")) {
            return false;
        }
        if (filename.endsWith(".cpp") || filename.endsWith(".cc") || filename.endsWith(".cxx") || filename.endsWith(".C") || filename.endsWith(".hxx")) {
            return true;
        }
        IFile file = this.fEditor.getInputFile();
        return file != null && CoreModel.hasCCNature((IProject)file.getProject());
    }

    private void setupTemplateEngine() {
        ContextType contextType;
        String[] globalContextNames = new String[2];
        String[] functionContextNames = new String[2];
        String[] structureContextNames = new String[2];
        ArrayList<TemplateEngine> globalTemplateList = new ArrayList<TemplateEngine>(2);
        ArrayList<TemplateEngine> functionTemplateList = new ArrayList<TemplateEngine>(2);
        ArrayList<TemplateEngine> structureTemplateList = new ArrayList<TemplateEngine>(2);
        if (this.isCppContext()) {
            globalContextNames[0] = "C++ Global";
            globalContextNames[1] = "C Global";
            functionContextNames[0] = "C++ Function";
            functionContextNames[1] = "C Function";
            structureContextNames[0] = "C++ Structure";
            structureContextNames[1] = "C Structure";
        } else {
            globalContextNames[0] = "C Global";
            structureContextNames[0] = "C Structure";
            functionContextNames[0] = "C Function";
        }
        int i = 0;
        while (i < globalContextNames.length) {
            contextType = ContextTypeRegistry.getInstance().getContextType(globalContextNames[i]);
            if (contextType != null) {
                globalTemplateList.add(new TemplateEngine(contextType));
            }
            ++i;
        }
        i = 0;
        while (i < functionContextNames.length) {
            contextType = ContextTypeRegistry.getInstance().getContextType(functionContextNames[i]);
            if (contextType != null) {
                functionTemplateList.add(new TemplateEngine(contextType));
            }
            ++i;
        }
        i = 0;
        while (i < structureContextNames.length) {
            contextType = ContextTypeRegistry.getInstance().getContextType(structureContextNames[i]);
            if (contextType != null) {
                structureTemplateList.add(new TemplateEngine(contextType));
            }
            ++i;
        }
        this.fGlobalContextTemplateEngine = globalTemplateList.toArray(new TemplateEngine[globalTemplateList.size()]);
        this.fFunctionContextTemplateEngine = functionTemplateList.toArray(new TemplateEngine[functionTemplateList.size()]);
        this.fStructureContextTemplateEngine = structureTemplateList.toArray(new TemplateEngine[structureTemplateList.size()]);
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults == 0) {
            String errorMsg = this.resultCollector.getErrorMessage();
            if (errorMsg == null || errorMsg.length() == 0) {
                errorMsg = CUIMessages.getString("CEditor.contentassist.noCompletions");
            }
            return errorMsg;
        }
        return this.resultCollector.getErrorMessage();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new CParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        List result = this.addContextInformations(viewer, offset);
        return result.toArray(new IContextInformation[result.size()]);
    }

    private List addContextInformations(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(viewer, offset);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>();
        int i = 0;
        while (i < proposals.length) {
            IContextInformation contextInformation = proposals[i].getContextInformation();
            if (contextInformation != null) {
                ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
                wrapper.setContextInformationPosition(offset);
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void allowAddingIncludes(boolean allowAddingIncludes) {
        this.fAllowAddIncludes = allowAddingIncludes;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.internalComputeCompletionProposals(viewer, offset);
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int offset) {
        IWorkingCopyManager fManager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy unit = fManager.getWorkingCopy(this.fEditor.getEditorInput());
        IDocument document = viewer.getDocument();
        int pos = offset - 1;
        if (pos >= 0) {
            try {
                if (document.getChar(pos) == ':' && document.getChar(pos - 1) != ':') {
                    return null;
                }
                if (document.getChar(pos) == '>' && document.getChar(pos - 1) != '-') {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        ICompletionProposal[] results = null;
        try {
            results = this.evalProposals(document, offset, unit, viewer);
        }
        catch (Exception e) {
            CUIPlugin.getDefault().log(e);
        }
        int n = this.fNumberOfComputedResults = results == null ? 0 : results.length;
        if (results == null) {
            results = new ICCompletionProposal[]{};
        }
        this.order((ICCompletionProposal[])results);
        return results;
    }

    private ICCompletionProposal[] order(ICCompletionProposal[] proposals) {
        if (proposals != null) {
            Arrays.sort(proposals, this.fComparator);
        }
        return proposals;
    }

    public ICCompletionProposal[] evalProposals(IDocument document, int documentOffset, IWorkingCopy unit, ITextViewer viewer) {
        this.fCurrentOffset = documentOffset;
        this.fCurrentSourceUnit = unit;
        this.fTextViewer = viewer;
        ArrayList completions = new ArrayList();
        if (this.fCurrentSourceUnit == null) {
            return null;
        }
        this.resultCollector.reset(viewer);
        this.fCurrentCompletionNode = this.addProposalsFromModel(completions);
        if (this.fCurrentCompletionNode != null) {
            this.addProposalsFromSearch(this.fCurrentCompletionNode, completions);
            this.addProposalsFromCompletionContributors(this.fCurrentCompletionNode, completions);
            this.addProposalsFromTemplates(viewer, this.fCurrentCompletionNode, completions);
            return this.order(completions.toArray(new ICCompletionProposal[0]));
        }
        return null;
    }

    private void addProposalsFromTemplates(ITextViewer viewer, IASTCompletionNode completionNode, List completions) {
        if (completionNode == null) {
            return;
        }
        if (viewer == null) {
            return;
        }
        IASTCompletionNode.CompletionKind kind = completionNode.getCompletionKind();
        if (kind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE || kind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            this.addProposalsFromTemplateEngine(viewer, this.fGlobalContextTemplateEngine, completions);
        }
        if (kind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || kind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            this.addProposalsFromTemplateEngine(viewer, this.fFunctionContextTemplateEngine, completions);
        }
        if (kind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            this.addProposalsFromTemplateEngine(viewer, this.fStructureContextTemplateEngine, completions);
        }
    }

    private void addProposalsFromTemplateEngine(ITextViewer viewer, TemplateEngine[] fTemplateEngine, List completions) {
        int i = 0;
        while (i < fTemplateEngine.length) {
            if (fTemplateEngine[i] != null) {
                try {
                    fTemplateEngine[i].reset();
                    fTemplateEngine[i].complete(viewer, this.fCurrentOffset, null);
                }
                catch (Exception x) {
                    CUIPlugin.getDefault().log(x);
                }
                completions.addAll(fTemplateEngine[i].getResults());
            }
            ++i;
        }
    }

    private void addProposalsFromCompletionContributors(IASTCompletionNode completionNode, List completions) {
        if (completionNode == null) {
            return;
        }
        String prefix = completionNode.getCompletionPrefix();
        int offset = this.fCurrentOffset - prefix.length();
        int length = prefix.length();
        if (completionNode.getCompletionContext() != IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE && completionNode.getCompletionContext() != IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            return;
        }
        IFunctionSummary[] summary = CCompletionContributorManager.getDefault().getMatchingFunctions(prefix);
        if (summary == null) {
            return;
        }
        int i = 0;
        while (i < summary.length) {
            String fname = String.valueOf(summary[i].getName()) + "()";
            String fdesc = summary[i].getDescription();
            IFunctionSummary.IFunctionPrototypeSummary fproto = summary[i].getPrototype();
            String fargs = fproto.getArguments();
            CCompletionProposal proposal = new CCompletionProposal(fname, offset, length, CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif"), fproto.getPrototypeString(true), 2, this.fTextViewer);
            if (fdesc != null) {
                proposal.setAdditionalProposalInfo(fdesc);
            }
            if (fargs != null && fargs.length() > 0) {
                proposal.setContextInformation((IContextInformation)new ContextInformation(fname, fargs));
            }
            completions.add(proposal);
            ++i;
        }
    }

    private FunctionPrototypeSummary getPrototype(BasicSearchMatch match) {
        switch (match.getElementType()) {
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                return new FunctionPrototypeSummary(String.valueOf(match.getReturnType()) + " " + match.getName());
            }
        }
        return null;
    }

    private IASTCompletionNode addProposalsFromModel(List completions) {
        IASTCompletionNode completionNode = this.completionEngine.complete(this.fCurrentSourceUnit, this.fCurrentOffset);
        return completionNode;
    }

    private void addProposalsFromSearch(IASTCompletionNode completionNode, List completions) {
        if (completionNode == null) {
            return;
        }
        String prefix = completionNode.getCompletionPrefix();
        int offset = this.fCurrentOffset - prefix.length();
        int length = prefix.length();
        String searchPrefix = String.valueOf(prefix) + "*";
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        store.getBoolean("content_assist_current_file_search_scope");
        boolean projectScope = store.getBoolean("content_assist_project_search_scope");
        ICSearchScope scope = null;
        if (projectScope && (completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.VARIABLE_TYPE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.FIELD_TYPE) && prefix.length() > 0) {
            LinkedList elementsFound = new LinkedList();
            ICElement[] projectScopeElement = new ICElement[]{this.fCurrentSourceUnit.getCProject()};
            scope = SearchEngine.createCSearchScope((ICElement[])projectScopeElement, (boolean)true);
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            if (completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
            try {
                this.searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, scope, (ICSearchResultCollector)this.searchResultCollector, true);
            }
            catch (InterruptedException interruptedException) {}
            elementsFound.addAll(this.searchResultCollector.getSearchResults());
            this.sendResultsToCollector(elementsFound.iterator(), offset, length, prefix);
        }
        completions.addAll(this.resultCollector.getCompletions());
    }

    private void sendResultsToCollector(Iterator results, int completionStart, int completionLength, String prefix) {
        while (results.hasNext()) {
            BasicSearchMatch match = (BasicSearchMatch)results.next();
            int type = match.getElementType();
            int relevance = this.completionEngine.computeRelevance(type, prefix, match.getName());
            switch (type) {
                case 69: {
                    ASTAccessVisibility visibility;
                    switch (match.getVisibility()) {
                        case 8192: {
                            visibility = ASTAccessVisibility.PUBLIC;
                            break;
                        }
                        case 16384: {
                            visibility = ASTAccessVisibility.PROTECTED;
                            break;
                        }
                        default: {
                            visibility = ASTAccessVisibility.PRIVATE;
                        }
                    }
                    this.resultCollector.acceptField(match.getName(), match.getReturnType(), visibility, completionStart, completionLength, relevance);
                    break;
                }
                case 74: 
                case 75: {
                    this.resultCollector.acceptVariable(match.getName(), match.getReturnType(), completionStart, completionLength, relevance);
                    break;
                }
                case 67: 
                case 68: {
                    ASTAccessVisibility visibility;
                    switch (match.getVisibility()) {
                        case 8192: {
                            visibility = ASTAccessVisibility.PUBLIC;
                            break;
                        }
                        case 16384: {
                            visibility = ASTAccessVisibility.PROTECTED;
                            break;
                        }
                        default: {
                            visibility = ASTAccessVisibility.PRIVATE;
                        }
                    }
                    this.resultCollector.acceptMethod(match.getName(), null, match.getReturnType(), visibility, completionStart, completionLength, relevance, true, completionStart);
                    break;
                }
                case 70: 
                case 71: {
                    this.resultCollector.acceptFunction(match.getName(), null, match.getReturnType(), completionStart, completionLength, relevance, true, completionStart);
                    break;
                }
                case 64: {
                    this.resultCollector.acceptClass(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 65: {
                    this.resultCollector.acceptStruct(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 66: {
                    this.resultCollector.acceptUnion(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 61: {
                    this.resultCollector.acceptNamespace(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 77: {
                    this.resultCollector.acceptMacro(match.getName(), completionStart, completionLength, relevance, completionStart);
                    break;
                }
                case 63: {
                    this.resultCollector.acceptEnumeration(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 79: {
                    this.resultCollector.acceptEnumerator(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
            }
        }
    }

    public IASTCompletionNode getCurrentCompletionNode() {
        return this.fCurrentCompletionNode;
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }
    }
}

