/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;

public class OptionCategory
extends BuildObject
implements IOptionCategory {
    private IOptionCategory owner;
    private List children;
    private Tool tool;
    private boolean resolved = true;
    private static final IOptionCategory[] emtpyCategories = new IOptionCategory[0];

    public OptionCategory(IOptionCategory owner) {
        this.owner = owner;
    }

    public OptionCategory(Tool tool, IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.tool = tool;
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        tool.addOptionCategory(this);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            String parentId = element.getAttribute("owner");
            this.owner = parentId != null ? this.tool.getOptionCategory(parentId) : this.tool;
            if (this.owner instanceof Tool) {
                ((Tool)this.owner).addChildCategory(this);
            } else {
                ((OptionCategory)this.owner).addChildCategory(this);
            }
        }
    }

    public IOptionCategory[] getChildCategories() {
        if (this.children != null) {
            return this.children.toArray(new IOptionCategory[this.children.size()]);
        }
        return emtpyCategories;
    }

    public void addChildCategory(OptionCategory category) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(category);
    }

    public IOptionCategory getOwner() {
        return this.owner;
    }

    public ITool getTool() {
        return this.owner.getTool();
    }

    public IOption[] getOptions(IConfiguration configuration) {
        ITool tool = this.getTool();
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            int i = 0;
            while (i < tools.length) {
                if (tools[i] instanceof IToolReference) {
                    if (((IToolReference)tools[i]).references(tool)) {
                        tool = tools[i];
                        break;
                    }
                } else if (tools[i].equals(tool)) break;
                ++i;
            }
        }
        IOption[] allOptions = tool.getOptions();
        ArrayList<IOption> myOptions = new ArrayList<IOption>();
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this)) {
                myOptions.add(option);
            }
            ++i;
        }
        return myOptions.toArray(new IOption[myOptions.size()]);
    }
}

