/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ManageIncludePathsDialog
extends Dialog {
    private static final String PREF_INCLUDES = "ScannerIncludes";
    private static final String PREFIX = "ManageIncludePathsDialog";
    private static final String DIALOG_TITLE = "ManageIncludePathsDialog.title";
    private static final String USER_GROUP = "ManageIncludePathsDialog.userGroup.title";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String EDIT = "BuildPropertyCommon.label.edit";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private static final String BROWSE = "BuildPathInfoBlock.browse";
    private static final String PATH_TITLE = "BuildPathInfoBlock.browse.path";
    private static final String EDIT_PATH_TITLE = "BuildPathInfoBlock.browse.path.edit";
    private static final String PATH_LABEL = "BuildPathInfoBlock.browse.path.label";
    private static final String DISCOVERED_GROUP = "ManageIncludePathsDialog.discoveredGroup.title";
    private static final String DISC_COMMON_PREFIX = "ManageScannerConfigDialogCommon";
    private static final String SELECTED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.selected.label";
    private static final String REMOVED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.removed.label";
    private static final String UP_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.up.label";
    private static final String DOWN_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.down.label";
    private static final String REMOVE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.remove.label";
    private static final String RESTORE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.restore.label";
    private static final String DELETE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.delete.label";
    private static final String DELETE_ALL_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.deleteAll.label";
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    private static final int INITIAL_LIST_WIDTH = 50;
    private static final int ACTIVE = 0;
    private static final int REMOVED = 1;
    private static final int DO_REMOVE = 0;
    private static final int DO_RESTORE = 1;
    private static final int DISC_UP = 0;
    private static final int DISC_DOWN = 1;
    private ArrayList returnPaths;
    private ArrayList deletedDiscoveredPaths;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap workingDiscoveredPaths;
    private boolean fDirty;
    private boolean fWorkingDirty;
    private ICOptionContainer fContainer;
    private IProject fProject;
    private Shell fShell;
    private MessageLine fStatusLine;
    private Group discoveredGroup;
    private Label selectedLabel;
    private Label removedLabel;
    private List discActiveList;
    private List discRemovedList;
    private Button upDiscPath;
    private Button downDiscPath;
    private Button removeDiscPath;
    private Button restoreDiscPath;
    private Button deleteDiscPath;
    private Button deleteAllDiscPaths;

    protected ManageIncludePathsDialog(Shell parentShell, ICOptionContainer container) {
        super(parentShell);
        DiscoveredPathInfo scanInfo;
        this.fShell = parentShell;
        this.fContainer = container;
        this.fProject = this.fContainer.getProject();
        if (this.fProject != null) {
            try {
                scanInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
            }
            catch (CoreException coreException) {
                scanInfo = new DiscoveredPathInfo(this.fProject);
            }
        } else {
            scanInfo = new DiscoveredPathInfo(this.fProject);
        }
        this.discoveredPaths = scanInfo.getIncludeMap();
        this.setDirty(false);
        this.fDirty = false;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.getTitle(DIALOG_TITLE));
        super.configureShell(newShell);
    }

    private String getTitle(String title) {
        return MakeUIPlugin.getResourceString(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        this.initializeDialogUnits((Control)composite);
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fStatusLine.setLayoutData(gd);
        this.fStatusLine.setMessage(this.getTitle(DIALOG_TITLE));
        this.createOptionsControls(composite);
        this.createDiscoveredControls(composite);
        this.setListContents();
        this.discActiveList.select(0);
        this.discActiveList.setFocus();
        this.enableDiscoveredButtons();
        return composite;
    }

    private void setListContents() {
        this.workingDiscoveredPaths = new LinkedHashMap(this.discoveredPaths);
        this.discActiveList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 0));
        this.discRemovedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 1));
    }

    private String[] getDiscIncludePaths(LinkedHashMap dPaths, int type) {
        ArrayList<String> aPaths = new ArrayList<String>();
        boolean compareValue = type != 0;
        Iterator i = dPaths.keySet().iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            if ((Boolean)dPaths.get(path) != compareValue) continue;
            aPaths.add(path);
        }
        return aPaths.toArray(new String[aPaths.size()]);
    }

    private String[] getIncludes(Preferences prefs) {
        String syms = prefs.getString(PREF_INCLUDES);
        return this.parseStringToList(syms);
    }

    private String[] parseStringToList(String syms) {
        if (syms != null && syms.length() > 0) {
            StringTokenizer tok = new StringTokenizer(syms, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    private void createOptionsControls(Composite composite) {
    }

    private void createDiscoveredControls(Composite composite) {
        this.discoveredGroup = ControlFactory.createGroup((Composite)composite, (String)this.getTitle(DISCOVERED_GROUP), (int)3);
        ((GridData)this.discoveredGroup.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.discoveredGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        this.selectedLabel = ControlFactory.createLabel((Composite)this.discoveredGroup, (String)this.getTitle(SELECTED_LABEL));
        ((GridData)this.selectedLabel.getLayoutData()).horizontalSpan = 1;
        ControlFactory.createLabel((Composite)this.discoveredGroup, (String)"");
        this.removedLabel = ControlFactory.createLabel((Composite)this.discoveredGroup, (String)this.getTitle(REMOVED_LABEL));
        ((GridData)this.removedLabel.getLayoutData()).horizontalSpan = 1;
        this.discActiveList = new List((Composite)this.discoveredGroup, 2820);
        this.discActiveList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.discRemovedList.deselectAll();
                ManageIncludePathsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        gd.heightHint = ManageIncludePathsDialog.getDefaultFontHeight((Control)this.discActiveList, 15);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.discActiveList.setLayoutData((Object)gd);
        Composite pathButtonComp = ControlFactory.createComposite((Composite)this.discoveredGroup, (int)1);
        this.upDiscPath = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(UP_DISCOVERED));
        this.upDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.handleUpDownDiscPath(0);
            }
        });
        this.upDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.upDiscPath);
        this.downDiscPath = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(DOWN_DISCOVERED));
        this.downDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.handleUpDownDiscPath(1);
            }
        });
        this.downDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.downDiscPath);
        this.removeDiscPath = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(REMOVE_DISCOVERED));
        this.removeDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.handleRemoveRestoreDiscPath(0);
            }
        });
        this.removeDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.removeDiscPath);
        this.restoreDiscPath = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(RESTORE_DISCOVERED));
        this.restoreDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.handleRemoveRestoreDiscPath(1);
            }
        });
        this.restoreDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.restoreDiscPath);
        ControlFactory.createSeparator((Composite)pathButtonComp, (int)1);
        this.deleteDiscPath = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(DELETE_DISCOVERED));
        this.deleteDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.handleDeleteDiscPath();
            }
        });
        this.deleteDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteDiscPath);
        this.deleteAllDiscPaths = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(DELETE_ALL_DISCOVERED));
        this.deleteAllDiscPaths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.handleDeleteAllDiscPath();
            }
        });
        this.deleteAllDiscPaths.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteAllDiscPaths);
        this.discRemovedList = new List((Composite)this.discoveredGroup, 2820);
        this.discRemovedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageIncludePathsDialog.this.discActiveList.deselectAll();
                ManageIncludePathsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gd2 = new GridData(1808);
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 1;
        gd2.heightHint = ManageIncludePathsDialog.getDefaultFontHeight((Control)this.discRemovedList, 15);
        gd2.widthHint = this.convertWidthInCharsToPixels(50);
        this.discRemovedList.setLayoutData((Object)gd2);
    }

    protected void handleUpDownDiscPath(int direction) {
        int selectedSet;
        boolean removed;
        List selectedList;
        int delta;
        int n = delta = direction == 0 ? -1 : 1;
        if (this.discActiveList.getSelectionIndex() == -1) {
            selectedList = this.discRemovedList;
            removed = true;
            selectedSet = 1;
        } else {
            selectedList = this.discActiveList;
            removed = false;
            selectedSet = 0;
        }
        int selectedItem = selectedList.getFocusIndex();
        String selected = selectedList.getItem(selectedItem);
        ArrayList pathKeyList = new ArrayList(this.workingDiscoveredPaths.keySet());
        int curIndex = pathKeyList.indexOf(selected);
        int otherIndex = curIndex + delta;
        boolean found = false;
        while (otherIndex >= 0 && otherIndex < pathKeyList.size()) {
            Boolean val = (Boolean)this.workingDiscoveredPaths.get(pathKeyList.get(otherIndex));
            if (val != null && val == removed) {
                found = true;
                break;
            }
            otherIndex += delta;
        }
        if (found) {
            String temp = (String)pathKeyList.get(curIndex);
            pathKeyList.add(curIndex, pathKeyList.get(otherIndex));
            pathKeyList.add(otherIndex, temp);
            LinkedHashMap newWorkingDiscoveredPaths = new LinkedHashMap(this.workingDiscoveredPaths.size());
            Iterator i = pathKeyList.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                newWorkingDiscoveredPaths.put(key, this.workingDiscoveredPaths.get(key));
            }
            this.workingDiscoveredPaths = newWorkingDiscoveredPaths;
            selectedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, selectedSet));
            selectedList.setSelection(selectedItem + delta);
            selectedList.setFocus();
            this.enableDiscoveredButtons();
            this.setDirty(true);
        }
    }

    protected void handleRemoveRestoreDiscPath(int type) {
        if (this.workingDiscoveredPaths != null) {
            String path;
            Boolean value;
            int id;
            List discList = this.discRemovedList;
            List discOtherList = this.discActiveList;
            boolean compareValue = true;
            if (type == 0) {
                discList = this.discActiveList;
                discOtherList = this.discRemovedList;
                compareValue = false;
            }
            if ((id = discList.getSelectionIndex()) != -1 && (value = (Boolean)this.workingDiscoveredPaths.get(path = discList.getItem(id))) != null && value == compareValue) {
                this.workingDiscoveredPaths.put(path, !compareValue);
                this.discActiveList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 0));
                this.discRemovedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 1));
                discOtherList.setSelection(discOtherList.indexOf(path));
                this.enableDiscoveredButtons();
                this.setDirty(true);
            }
        }
    }

    protected void handleDeleteDiscPath() {
        this.deleteDiscPath(1);
        this.deleteDiscPath(0);
    }

    private void deleteDiscPath(int type) {
        int id;
        List discList = this.discRemovedList;
        if (type == 0) {
            discList = this.discActiveList;
        }
        if ((id = discList.getSelectionIndex()) >= 0) {
            String path = discList.getItem(id);
            if (this.deletedDiscoveredPaths == null) {
                this.deletedDiscoveredPaths = new ArrayList();
            }
            this.deletedDiscoveredPaths.add(path);
            this.workingDiscoveredPaths.remove(path);
            discList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, type));
            int items = discList.getItemCount();
            if (items > 0) {
                if (id >= items) {
                    id = items - 1;
                }
                discList.setSelection(id);
                this.enableDiscoveredButtons();
                this.setDirty(true);
            }
        }
    }

    protected void handleDeleteAllDiscPath() {
        ScannerInfoCollector.getInstance().deleteAllPaths(this.fProject);
        this.workingDiscoveredPaths.clear();
        this.discActiveList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 0));
        this.discRemovedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 1));
        this.enableDiscoveredButtons();
        this.setDirty(true);
    }

    protected void enableDiscoveredButtons() {
        this.discoveredGroup.setEnabled(this.fProject != null);
        this.selectedLabel.setEnabled(this.fProject != null);
        this.discActiveList.setEnabled(this.fProject != null);
        this.removedLabel.setEnabled(this.fProject != null);
        this.discRemovedList.setEnabled(this.fProject != null);
        int activeItems = this.discActiveList.getItemCount();
        int activeSelection = this.discActiveList.getSelectionIndex();
        int removedItems = this.discRemovedList.getItemCount();
        int removedSelection = this.discRemovedList.getSelectionIndex();
        this.upDiscPath.setEnabled(activeItems > 0 && activeSelection > 0 || removedItems > 0 && removedSelection > 0);
        this.downDiscPath.setEnabled(activeItems > 0 && activeSelection >= 0 && activeSelection < activeItems - 1 || removedItems > 0 && removedSelection >= 0 && removedSelection < removedItems - 1);
        this.removeDiscPath.setEnabled(activeItems > 0 && activeSelection >= 0);
        this.restoreDiscPath.setEnabled(removedItems > 0 && removedSelection >= 0);
        this.deleteDiscPath.setEnabled(activeItems > 0 && activeSelection >= 0 || removedItems > 0 && removedSelection >= 0);
        this.deleteAllDiscPaths.setEnabled(activeItems > 0 || removedItems > 0);
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    public String[] getManagedIncludes() {
        if (this.returnPaths == null) {
            return new String[0];
        }
        return this.returnPaths.toArray(new String[this.returnPaths.size()]);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.discoveredPaths = this.workingDiscoveredPaths;
            this.returnPaths = new ArrayList(this.discActiveList.getItemCount());
            this.returnPaths.addAll(new ArrayList<String>(Arrays.asList(this.discActiveList.getItems())));
            this.fDirty = this.fWorkingDirty;
        } else if (1 == buttonId) {
            this.deletedDiscoveredPaths = null;
            this.workingDiscoveredPaths = null;
            this.setDirty(false);
        }
        super.buttonPressed(buttonId);
    }

    private void setDirty(boolean dirty) {
        this.fWorkingDirty = dirty;
    }

    public boolean saveTo(IDiscoveredPathManager.IDiscoveredPathInfo info) {
        if (this.fDirty || this.fProject == null && this.fContainer.getProject() != null) {
            info.setIncludeMap(this.discoveredPaths);
            if (this.deletedDiscoveredPaths != null) {
                Iterator i = this.deletedDiscoveredPaths.iterator();
                while (i.hasNext()) {
                    ScannerInfoCollector.getInstance().deletePath(this.fProject, (String)i.next());
                }
                this.deletedDiscoveredPaths = null;
            }
        }
        this.setDirty(false);
        boolean rc = this.fDirty;
        this.fDirty = false;
        return rc;
    }

    public void restore() {
        if (this.fProject != null) {
            ScannerInfoCollector.getInstance().deleteAllPaths(this.fProject);
        }
        this.discoveredPaths = new LinkedHashMap();
        this.deletedDiscoveredPaths = null;
        this.fDirty = true;
    }
}

