/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.internal.filetype.Argument;
import org.eclipse.cdt.internal.core.index.StringMatcher;

public class CFileTypeAssociation
implements ICFileTypeAssociation {
    private String fPattern;
    private ICFileType fType;
    private StringMatcher fMatcher;

    public CFileTypeAssociation(String pattern, ICFileType type) {
        Argument.check(pattern);
        Argument.check(type);
        this.fPattern = pattern;
        this.fType = type;
        this.fMatcher = new StringMatcher(pattern, false, false);
    }

    public String getPattern() {
        return this.fPattern;
    }

    public ICFileType getType() {
        return this.fType;
    }

    public boolean matches(String fileName) {
        if (fileName == null) {
            return this.fPattern == null;
        }
        return this.fMatcher.match(fileName);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ICFileTypeAssociation)) {
            return false;
        }
        ICFileTypeAssociation rhs = (ICFileTypeAssociation)object;
        boolean eq = this.fPattern.equals(rhs.getPattern());
        if (eq) {
            eq = this.fType.equals(rhs.getType());
        }
        return eq;
    }
}

