/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeReference;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob;
import org.eclipse.cdt.internal.core.browser.util.PathUtil;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerTypesJob
extends IndexerJob {
    private ITypeCache fTypeCache;

    public IndexerTypesJob(IndexManager indexManager, ITypeCache typeCache, ITypeSearchScope scope) {
        super(indexManager, typeCache.getProject());
        this.fTypeCache = typeCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IIndex index, IProject project, IProgressMonitor progressMonitor) throws InterruptedException {
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            try {
                ((IndexInput)input).open();
                this.updateNamespaces(input, project, progressMonitor);
                this.updateTypes(input, project, progressMonitor);
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                Object var5_6 = null;
                try {
                    ((IndexInput)input).close();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            ((IndexInput)input).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        ((IndexInput)input).close();
        return true;
    }

    private void updateNamespaces(IndexInput input, IProject project, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] namespaceEntries = input.queryEntriesPrefixedBy(IIndexConstants.NAMESPACE_DECL);
        if (namespaceEntries != null) {
            int i = 0;
            while (i < namespaceEntries.length) {
                int slash;
                int firstSlash;
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = namespaceEntries[i];
                char[] word = entry.getWord();
                String name = String.valueOf(CharOperation.subarray(word, (firstSlash = CharOperation.indexOf('/', word, 0)) + 1, slash = CharOperation.indexOf('/', word, firstSlash + 1)));
                if (name.length() != 0) {
                    String[] enclosingNames = this.getEnclosingNames(word, slash);
                    this.addType(input, project, entry, 61, name, enclosingNames, monitor);
                }
                ++i;
            }
        }
    }

    private void updateTypes(IndexInput input, IProject project, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] typeEntries = input.queryEntriesPrefixedBy(IIndexConstants.TYPE_DECL);
        if (typeEntries != null) {
            int i = 0;
            while (i < typeEntries.length) {
                int slash;
                String name;
                int firstSlash;
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = typeEntries[i];
                char[] word = entry.getWord();
                char decodedType = word[(firstSlash = CharOperation.indexOf('/', word, 0)) + 1];
                int type = this.getElementType(decodedType);
                if (type != 0 && (name = String.valueOf(CharOperation.subarray(word, (firstSlash += 2) + 1, slash = CharOperation.indexOf('/', word, firstSlash + 1)))).length() != 0) {
                    String[] enclosingNames = this.getEnclosingNames(word, slash);
                    this.addType(input, project, entry, type, name, enclosingNames, monitor);
                }
                ++i;
            }
        }
    }

    private int getElementType(char decodedType) {
        switch (decodedType) {
            case 'C': {
                return 64;
            }
            case 'S': {
                return 65;
            }
            case 'T': {
                return 78;
            }
            case 'E': {
                return 63;
            }
            case 'U': {
                return 66;
            }
        }
        return 0;
    }

    private String[] getEnclosingNames(char[] word, int slash) {
        String[] enclosingNames = null;
        if (slash != -1 && slash + 1 < word.length) {
            char[][] temp = CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, -1));
            enclosingNames = new String[temp.length];
            int i = 0;
            while (i < temp.length) {
                enclosingNames[i] = String.valueOf(temp[temp.length - i - 1]);
                ++i;
            }
        }
        return enclosingNames;
    }

    private void addType(IndexInput input, IProject project, IEntryResult entry, int type, String name, String[] enclosingNames, IProgressMonitor monitor) throws InterruptedException, IOException {
        int[] references;
        QualifiedTypeName qualifiedName = new QualifiedTypeName(name, enclosingNames);
        ITypeInfo info = this.fTypeCache.getType(type, qualifiedName);
        if ((info == null || info.isUndefinedType()) && (references = entry.getFileReferences()) != null && references.length > 0) {
            if (info != null) {
                info.setCElementType(type);
            } else {
                info = new TypeInfo(type, qualifiedName);
                this.fTypeCache.insert(info);
            }
            IndexedFile file = input.getIndexedFile(references[0]);
            if (file != null && file.getPath() != null) {
                IPath path = PathUtil.getWorkspaceRelativePath(file.getPath());
                info.addReference(new TypeReference(path, project));
            }
        }
    }
}

