/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.CygwinToolsProvider;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.PEArchive;
import org.eclipse.cdt.utils.coff.parser.BinaryArchive;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject;
import org.eclipse.core.runtime.IPath;

public class PEParser
extends CygwinToolsProvider
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        if (path == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile binary = null;
        try {
            PE.Attribute attribute = null;
            if (hints != null && hints.length > 0) {
                try {
                    attribute = PE.getAttribute(hints);
                }
                catch (EOFException eOFException) {}
            }
            if (attribute == null) {
                attribute = PE.getAttribute(path.toOSString());
            }
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        binary = this.createBinaryExecutable(path);
                        break;
                    }
                    case 2: {
                        binary = this.createBinaryShared(path);
                        break;
                    }
                    case 3: {
                        binary = this.createBinaryObject(path);
                        break;
                    }
                    case 4: {
                        binary = this.createBinaryCore(path);
                    }
                }
            }
        }
        catch (IOException iOException) {
            binary = this.createBinaryArchive(path);
        }
        return binary;
    }

    public String getFormat() {
        return "PE";
    }

    public boolean isBinary(byte[] array, IPath path) {
        boolean isBin;
        boolean bl = isBin = PE.isExeHeader(array) || PEArchive.isARHeader(array);
        if (!isBin && array.length > 1) {
            int f_magic = (array[1] & 0xFF) << 8 | array[0] & 0xFF;
            switch (f_magic) {
                case 332: 
                case 354: 
                case 358: 
                case 360: 
                case 388: 
                case 418: 
                case 422: 
                case 448: 
                case 450: 
                case 496: 
                case 512: 
                case 614: 
                case 616: 
                case 644: 
                case 870: 
                case 1126: {
                    isBin = true;
                }
            }
        }
        return isBin;
    }

    public int getHintBufferSize() {
        return 512;
    }

    protected IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath path) {
        return new PEBinaryObject(this, path){

            public int getType() {
                return 2;
            }
        };
    }

    protected IBinaryParser.IBinaryObject createBinaryCore(IPath path) {
        return new PEBinaryObject(this, path){

            public int getType() {
                return 16;
            }
        };
    }

    protected IBinaryParser.IBinaryObject createBinaryObject(IPath path) {
        return new PEBinaryObject(this, path){

            public int getType() {
                return 1;
            }
        };
    }

    protected IBinaryParser.IBinaryShared createBinaryShared(IPath path) {
        return new PEBinaryObject(this, path){

            public int getType() {
                return 4;
            }
        };
    }

    protected IBinaryParser.IBinaryArchive createBinaryArchive(IPath path) throws IOException {
        return new BinaryArchive(this, path);
    }
}

