/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;

public class ASTTemplateParameter
extends ASTSymbol
implements IASTTemplateParameter,
IASTOffsetableNamedElement {
    private IASTTypeId defaultValue;
    private ASTParameterDeclaration parameter;
    private List parms;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTTemplateParameter(ISymbol sym, IASTTypeId defVal, IASTParameterDeclaration param, List parms, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endingOffset, int endingLine, char[] filename) {
        super(sym);
        this.symbol = sym;
        this.defaultValue = defVal;
        this.parameter = (ASTParameterDeclaration)param;
        this.parms = parms;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.fn = filename;
    }

    public IASTTemplateParameter.ParamKind getTemplateParameterKind() {
        ITypeInfo.eType type = this.symbol.getTypeInfo().getTemplateParameterType();
        if (type == ITypeInfo.t_typeName) {
            return IASTTemplateParameter.ParamKind.TYPENAME;
        }
        if (type == ITypeInfo.t_template) {
            return IASTTemplateParameter.ParamKind.TEMPLATE_LIST;
        }
        return IASTTemplateParameter.ParamKind.PARAMETER;
    }

    public String getIdentifier() {
        return String.valueOf(this.symbol.getName());
    }

    public String getDefaultValueIdExpression() {
        return this.defaultValue != null ? this.defaultValue.toString() : "";
    }

    public IASTParameterDeclaration getParameterDeclaration() {
        return this.parameter;
    }

    public Iterator getTemplateParameters() {
        return this.parms.iterator();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        if (this.defaultValue != null) {
            this.defaultValue.acceptElement(requestor, manager);
        }
        if (this.parameter != null) {
            this.parameter.acceptElement(requestor, manager);
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }
}

