/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQScope;

public class ASTLinkageSpecification
extends ASTDeclaration
implements IASTDeclaration,
IASTLinkageSpecification,
IASTQScope {
    private final char[] linkage;
    private final char[] fn;
    private List declarations = new ArrayList();
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTLinkageSpecification(IASTScope scope, char[] linkage, int startingOffset, int startingLine, char[] filename) {
        super(scope);
        this.linkage = linkage;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.fn = filename;
    }

    public String getLinkageString() {
        return String.valueOf(this.linkage);
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterLinkageSpecification(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitLinkageSpecification(this);
        }
        catch (Exception exception) {}
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

