/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectSet;

public class TypeFilter {
    private ObjectSet acceptedTypes = new ObjectSet(2);
    private ObjectSet acceptedKinds = new ObjectSet(2);
    private boolean lookingInThis = false;

    public TypeFilter() {
    }

    public TypeFilter(ITypeInfo.eType type) {
        this.acceptedTypes.put(type);
    }

    public TypeFilter(IASTNode.LookupKind kind) {
        this.acceptedKinds.put(kind);
        this.populatedAcceptedTypes(kind);
    }

    public void addAcceptedType(ITypeInfo.eType type) {
        this.acceptedTypes.put(type);
    }

    public void addAcceptedType(IASTNode.LookupKind kind) {
        this.populatedAcceptedTypes(kind);
        this.acceptedKinds.put(kind);
    }

    public boolean willAccept(ITypeInfo.eType type) {
        return this.acceptedTypes.containsKey(ITypeInfo.t_any) || this.acceptedTypes.containsKey(type);
    }

    public boolean shouldAccept(ISymbol symbol) {
        return this.shouldAccept(symbol, symbol.getTypeInfo());
    }

    public boolean shouldAccept(ISymbol symbol, ITypeInfo typeInfo) {
        boolean symbolIsLocal;
        if (this.acceptedTypes.containsKey(ITypeInfo.t_any)) {
            return true;
        }
        if (this.acceptedKinds.isEmpty()) {
            return this.acceptedTypes.containsKey(typeInfo.getType());
        }
        IContainerSymbol container = symbol.getContainingSymbol();
        boolean symbolIsMember = container.isType(ITypeInfo.t_class, ITypeInfo.t_union);
        boolean bl = symbolIsLocal = container.isType(ITypeInfo.t_constructor, ITypeInfo.t_function) || container.isType(ITypeInfo.t_block);
        if (typeInfo.isType(ITypeInfo.t_function)) {
            return this.acceptedKinds.containsKey(IASTNode.LookupKind.FUNCTIONS) && !symbolIsMember || this.acceptedKinds.containsKey(IASTNode.LookupKind.METHODS) && symbolIsMember;
        }
        if (typeInfo.isType(ITypeInfo.t_type) && typeInfo.checkBit(256)) {
            return this.acceptedKinds.containsKey(IASTNode.LookupKind.TYPEDEFS) || this.acceptedKinds.containsKey(IASTNode.LookupKind.TYPES);
        }
        if (typeInfo.isType(ITypeInfo.t_type) || typeInfo.isType(ITypeInfo.t__Bool, ITypeInfo.t_void)) {
            return this.acceptedKinds.containsKey(IASTNode.LookupKind.VARIABLES) && !symbolIsMember && !symbolIsLocal || this.acceptedKinds.containsKey(IASTNode.LookupKind.LOCAL_VARIABLES) && !symbolIsMember && symbolIsLocal || this.acceptedKinds.containsKey(IASTNode.LookupKind.FIELDS) && symbolIsMember;
        }
        return this.acceptedTypes.containsKey(typeInfo.getType());
    }

    private void populatedAcceptedTypes(IASTNode.LookupKind kind) {
        if (kind == IASTNode.LookupKind.ALL) {
            this.acceptedTypes.put(ITypeInfo.t_any);
        } else if (kind == IASTNode.LookupKind.STRUCTURES) {
            this.acceptedTypes.put(ITypeInfo.t_class);
            this.acceptedTypes.put(ITypeInfo.t_struct);
            this.acceptedTypes.put(ITypeInfo.t_union);
        } else if (kind == IASTNode.LookupKind.STRUCTS) {
            this.acceptedTypes.put(ITypeInfo.t_struct);
        } else if (kind == IASTNode.LookupKind.UNIONS) {
            this.acceptedTypes.put(ITypeInfo.t_union);
        } else if (kind == IASTNode.LookupKind.CLASSES) {
            this.acceptedTypes.put(ITypeInfo.t_class);
        } else if (kind == IASTNode.LookupKind.CONSTRUCTORS) {
            this.acceptedTypes.put(ITypeInfo.t_constructor);
        } else if (kind == IASTNode.LookupKind.NAMESPACES) {
            this.acceptedTypes.put(ITypeInfo.t_namespace);
        } else if (kind == IASTNode.LookupKind.ENUMERATIONS) {
            this.acceptedTypes.put(ITypeInfo.t_enumeration);
        } else if (kind == IASTNode.LookupKind.ENUMERATORS) {
            this.acceptedTypes.put(ITypeInfo.t_enumerator);
        } else if (kind == IASTNode.LookupKind.TYPES) {
            this.acceptedTypes.put(ITypeInfo.t_class);
            this.acceptedTypes.put(ITypeInfo.t_struct);
            this.acceptedTypes.put(ITypeInfo.t_union);
            this.acceptedTypes.put(ITypeInfo.t_enumeration);
        }
    }

    public void setLookingInThis(boolean inThis) {
        this.lookingInThis = inThis;
    }

    public boolean isLookingInThis() {
        return this.lookingInThis;
    }
}

