/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CExpressionTarget {
    private CDebugTarget fDebugTarget;
    private Map fExpressions = null;

    public CExpressionTarget(CDebugTarget target) {
        this.fDebugTarget = target;
        this.fExpressions = new HashMap(10);
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public IValue evaluateExpression(String expressionText) throws DebugException {
        CExpression expression = (CExpression)this.fExpressions.remove(expressionText);
        if (expression != null) {
            expression.dispose();
        }
        expression = (CExpression)CDIDebugModel.createExpression(this.getDebugTarget(), expressionText);
        this.fExpressions.put(expressionText, expression);
        return expression.getValue();
    }

    public void dispose() {
        Iterator it = this.fExpressions.values().iterator();
        while (it.hasNext()) {
            ((CExpression)it.next()).dispose();
        }
        this.fExpressions.clear();
    }
}

