/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;

public class ScannerContextTopString
implements IScannerContext {
    int position = 0;
    int line = 1;
    int length;
    String reader;
    String textName;
    int extra = -1;
    boolean stop = false;

    public ScannerContextTopString(String in, String contextName, boolean stop) {
        this.textName = contextName;
        this.reader = in;
        this.length = in.length();
        this.stop = stop;
    }

    public ScannerContextTopString(String in, String contextName, char e, boolean stop) {
        this.textName = contextName;
        this.reader = in;
        this.length = in.length();
        this.stop = stop;
        this.extra = e;
    }

    public boolean isFinal() {
        return this.stop;
    }

    public final String getContextName() {
        return this.textName;
    }

    public int getChar() {
        int c = this.position < this.length ? this.reader.charAt(this.position++) : (this.position++ == this.length ? this.extra : -1);
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    public void close() {
    }

    public int getFilenameIndex() {
        return 0;
    }

    public final void ungetChar(int c) {
        --this.position;
        if (c == 10) {
            --this.line;
        }
    }

    public int getOffset() {
        return this.position;
    }

    public int getLine() {
        return this.line;
    }

    public int getKind() {
        return IScannerContext.ContextKind.TOP;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getContextName());
        if (this.position <= this.length) {
            buffer.append(this.reader.substring(0, this.position));
            buffer.append('*');
            buffer.append(this.reader.substring(this.position, this.length - this.position));
            if (this.extra != -1) {
                buffer.append((char)this.extra);
            }
        } else {
            buffer.append(this.reader.substring(0, this.length));
            if (this.extra != -1) {
                buffer.append((char)this.extra);
            }
            buffer.append('*');
        }
        return buffer.toString();
    }
}

