/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.NewClassWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewClassWizard
extends BasicNewResourceWizard
implements INewWizard {
    private NewClassWizardPage fPage;
    private String wz_title;
    private boolean openInEditor = true;
    private static final String WZ_TITLE = "NewClassWizard.title";
    private static final String WZ_DESC = "NewClassWizard.description";
    private static final String PAGE_TITLE = "NewClassWizard.page.title";

    public NewClassWizard() {
        this(CUIPlugin.getResourceString(WZ_TITLE));
    }

    public NewClassWizard(String title) {
        this.wz_title = title;
        this.setDefaultPageImageDescriptor(CPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setWindowTitle(this.wz_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fPage.createClass(monitor)) {
            IResource resource;
            ITranslationUnit headerTU = this.fPage.getCreatedClassHeaderFile();
            ITranslationUnit bodyTU = this.fPage.getCreatedClassBodyFile();
            if (headerTU != null) {
                resource = headerTU.getResource();
                this.selectAndReveal(resource);
                if (this.doOpenInEditor()) {
                    this.openResource((IFile)resource);
                }
            }
            if (bodyTU != null) {
                resource = bodyTU.getResource();
                this.selectAndReveal(resource);
                if (this.doOpenInEditor()) {
                    this.openResource((IFile)resource);
                }
            }
        }
    }

    public boolean performFinish() {
        if (!this.fPage.selectionIsCpp()) {
            return true;
        }
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    NewClassWizard.this.finishPage(monitor);
                }
                catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
        }
        catch (InvocationTargetException e) {
            this.handleFinishException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.fPage = new NewClassWizardPage(this.getSelection());
        this.addPage((IWizardPage)this.fPage);
        this.fPage.setTitle(CUIPlugin.getResourceString(PAGE_TITLE));
        this.fPage.setDescription(CUIPlugin.getResourceString(WZ_DESC));
        this.fPage.init();
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.getString("NewElementWizard.op_error.title");
        String message = NewWizardMessages.getString("NewElementWizard.op_error.message");
        ExceptionHandler.handle(e, shell, title, message);
    }

    protected void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = CUIPlugin.getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        CUIPlugin.getDefault().log(e);
                    }
                }
            });
        }
    }

    public ICElement getCreatedClassElement() {
        return this.fPage.getCreatedClassElement();
    }

    public boolean doOpenInEditor() {
        return this.openInEditor;
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.openInEditor = openInEditor;
    }
}

