/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.core.runtime.IPath;

public class Symbol
implements IBinaryParser.ISymbol,
Comparable {
    BinaryObjectAdapter binary;
    long timestamp;
    Addr2line addr2line;
    public IPath filename;
    public int startLine;
    public int endLine;
    public long addr;
    public String name;
    public int type;
    public long size;

    public Symbol(BinaryObjectAdapter bin) {
        this.binary = bin;
    }

    public IPath getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getAddress() {
        return this.addr;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getLineNumber(long offset) {
        int line = -1;
        try {
            Addr2line addressToLine = this.startAddr2Line();
            if (addressToLine != null) {
                line = addressToLine.getLineNumber(this.addr + offset);
            }
        }
        catch (IOException iOException) {}
        return line;
    }

    public long getSize() {
        return this.size;
    }

    public int compareTo(Object obj) {
        long thisVal = 0L;
        long anotherVal = 0L;
        if (obj instanceof Symbol) {
            Symbol sym = (Symbol)obj;
            thisVal = this.addr;
            anotherVal = sym.addr;
        } else if (obj instanceof Long) {
            Long val = (Long)obj;
            anotherVal = val;
            thisVal = this.addr;
        }
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    synchronized Addr2line startAddr2Line() {
        if (this.addr2line == null) {
            this.addr2line = this.binary.getAddr2line();
            if (this.addr2line != null) {
                this.timestamp = System.currentTimeMillis();
                Runnable worker = new Runnable(){

                    public void run() {
                        long diff = System.currentTimeMillis() - Symbol.this.timestamp;
                        while (diff < 10000L) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            diff = System.currentTimeMillis() - Symbol.this.timestamp;
                        }
                        Symbol.this.stopAddr2Line();
                    }
                };
                new Thread(worker, "Addr2line Reaper").start();
            }
        } else {
            this.timestamp = System.currentTimeMillis();
        }
        return this.addr2line;
    }

    synchronized void stopAddr2Line() {
        if (this.addr2line != null) {
            this.addr2line.dispose();
        }
        this.addr2line = null;
    }
}

