/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.som.AR;
import org.eclipse.cdt.utils.som.SOM;
import org.eclipse.cdt.utils.som.parser.SOMBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends SOMBinaryObject {
    private AR.ARHeader header;

    public ARMember(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path);
        this.header = header;
    }

    protected void addSymbols(SOM.Symbol[] peSyms, byte[] table, Addr2line addr2line, CPPFilt cppfilt, CygPath cygpath, List list) {
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isVariable()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                Symbol sym = new Symbol(this);
                sym.type = peSyms[i].isFunction() ? 1 : 2;
                sym.addr = peSyms[i].symbol_value;
                sym.name = name;
                if (cppfilt != null) {
                    try {
                        sym.name = cppfilt.getFunction(sym.name);
                    }
                    catch (IOException iOException) {
                        cppfilt = null;
                    }
                }
                list.add(sym);
            }
            ++i;
        }
    }

    protected SOM getSOM() throws IOException {
        if (this.header != null) {
            return this.header.getSOM();
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.noFileAssociation"));
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null && this.header != null) {
            try {
                stream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }
}

