/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;

public class Option
extends BuildObject
implements IOption {
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private int browseType;
    private List builtIns;
    private IOptionCategory category;
    private String command;
    private String commandFalse;
    private String defaultEnumId;
    private Map enumCommands;
    private Map enumNames;
    private ITool tool;
    private Object value;
    private int valueType;
    private boolean resolved = true;

    public Option(ITool tool) {
        this.tool = tool;
    }

    public Option(Tool tool, IManagedConfigElement element) {
        this(tool);
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.setId(element.getAttribute("id"));
        tool.addOption(this);
        this.setName(element.getAttribute("name"));
        this.command = element.getAttribute("command");
        this.commandFalse = element.getAttribute("commandFalse");
        String valueTypeStr = element.getAttribute("valueType");
        this.valueType = valueTypeStr == null ? -1 : (valueTypeStr.equals("string") ? 2 : (valueTypeStr.equals("stringList") ? 3 : (valueTypeStr.equals("boolean") ? 0 : (valueTypeStr.equals("enumerated") ? 1 : (valueTypeStr.equals("includePath") ? 4 : (valueTypeStr.equals("libs") ? 6 : (valueTypeStr.equals("userObjs") ? 7 : 5)))))));
        switch (this.valueType) {
            case 0: {
                this.value = new Boolean(element.getAttribute("defaultValue"));
                break;
            }
            case 2: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case 1: {
                ArrayList<String> enumList = new ArrayList<String>();
                IManagedConfigElement[] enumElements = element.getChildren("enumeratedOptionValue");
                int i = 0;
                while (i < enumElements.length) {
                    String optId = enumElements[i].getAttribute("id");
                    enumList.add(optId);
                    this.getEnumCommandMap().put(optId, enumElements[i].getAttribute("command"));
                    this.getEnumNameMap().put(optId, enumElements[i].getAttribute("name"));
                    Boolean isDefault = new Boolean(enumElements[i].getAttribute("isDefault"));
                    if (isDefault.booleanValue()) {
                        this.defaultEnumId = optId;
                    }
                    ++i;
                }
                this.value = enumList;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> valueList = new ArrayList<String>();
                this.builtIns = new ArrayList();
                IManagedConfigElement[] valueElements = element.getChildren("listOptionValue");
                int i = 0;
                while (i < valueElements.length) {
                    IManagedConfigElement valueElement = valueElements[i];
                    Boolean isBuiltIn = new Boolean(valueElement.getAttribute("builtIn"));
                    if (isBuiltIn.booleanValue()) {
                        this.builtIns.add(valueElement.getAttribute("value"));
                    } else {
                        valueList.add(valueElement.getAttribute("value"));
                    }
                    ++i;
                }
                this.value = valueList;
                break;
            }
        }
        String browseTypeStr = element.getAttribute("browseType");
        if (browseTypeStr == null || browseTypeStr.equals("none")) {
            this.browseType = 0;
        } else if (browseTypeStr.equals("file")) {
            this.browseType = 1;
        } else if (browseTypeStr.equals("directory")) {
            this.browseType = 2;
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            String categoryId = element.getAttribute("category");
            if (categoryId != null) {
                this.setCategory(((Tool)this.tool).getOptionCategory(categoryId));
            }
        }
    }

    public String[] getApplicableValues() {
        List ids = (List)this.value;
        if (ids == null || ids.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] enumNames = new String[ids.size()];
        int index = 0;
        while (index < ids.size()) {
            enumNames[index] = (String)this.getEnumNameMap().get(ids.get(index));
            ++index;
        }
        return enumNames;
    }

    public boolean getBooleanValue() {
        Boolean bool = (Boolean)this.value;
        return bool;
    }

    public int getBrowseType() {
        return this.browseType;
    }

    public String[] getBuiltIns() {
        return this.builtIns == null ? EMPTY_STRING_ARRAY : this.builtIns.toArray(new String[this.builtIns.size()]);
    }

    public IOptionCategory getCategory() {
        return this.category != null ? this.category : this.getTool().getTopOptionCategory();
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandFalse() {
        return this.commandFalse;
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.valueType != 5) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getEnumCommand(String id) {
        if (id == null) {
            return EMPTY_STRING;
        }
        String cmd = (String)this.getEnumCommandMap().get(id);
        if (cmd == null) {
            List ids = (List)this.value;
            ListIterator iter = ids.listIterator();
            while (iter.hasNext()) {
                String realID = (String)iter.next();
                String name = (String)this.getEnumNameMap().get(realID);
                if (!id.equals(name)) continue;
                cmd = (String)this.getEnumCommandMap().get(realID);
                break;
            }
        }
        return cmd == null ? EMPTY_STRING : cmd;
    }

    public String getEnumName(String id) {
        if (id == null) {
            return EMPTY_STRING;
        }
        String name = (String)this.getEnumNameMap().get(id);
        if (name == null) {
            name = id;
        }
        return name;
    }

    private Map getEnumCommandMap() {
        if (this.enumCommands == null) {
            this.enumCommands = new HashMap();
        }
        return this.enumCommands;
    }

    public String getEnumeratedId(String name) {
        if (name == null) {
            return null;
        }
        Set idSet = this.getEnumNameMap().keySet();
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            String enumName = (String)this.getEnumNameMap().get(id);
            if (!name.equals(enumName)) continue;
            return id;
        }
        return null;
    }

    private Map getEnumNameMap() {
        if (this.enumNames == null) {
            this.enumNames = new HashMap();
        }
        return this.enumNames;
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.valueType != 4) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String[] getLibraries() throws BuildException {
        if (this.valueType != 6) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getSelectedEnum() throws BuildException {
        if (this.valueType != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.defaultEnumId == null ? EMPTY_STRING : this.defaultEnumId;
    }

    public String[] getStringListValue() throws BuildException {
        if (this.valueType != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getStringValue() throws BuildException {
        if (this.valueType != 2) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.value == null ? EMPTY_STRING : (String)this.value;
    }

    public ITool getTool() {
        return this.tool;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.valueType != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setCategory(IOptionCategory category) {
        this.category = category;
    }

    public IOption setValue(IConfiguration config, String value) throws BuildException {
        if (this.valueType != 2 || this.valueType != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (config == null) {
            this.value = value;
            return this;
        }
        return null;
    }

    public IOption setValue(IConfiguration config, String[] value) throws BuildException {
        if (this.valueType != 3 || this.valueType != 4 || this.valueType != 5 || this.valueType != 6 || this.valueType != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (config == null) {
            this.value = value;
            return this;
        }
        return null;
    }
}

