/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;

public class ASTFunction
extends ASTScope
implements IASTFunction {
    private final boolean previouslyDeclared;
    private boolean hasFunctionBody = false;
    private final boolean isFriendDeclaration;
    private final IASTTemplate ownerTemplate;
    private final IASTAbstractDeclaration returnType;
    private final IASTExceptionSpecification exception;
    private final ASTQualifiedNamedElement qualifiedName;
    private final List parameters;
    protected List references;
    private List declarations = null;
    private final char[] fn;
    private boolean hasFunctionTryBlock = false;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTFunction(IParameterizedSymbol symbol, int nameEndOffset, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, int startOffset, int startingLine, int nameOffset, int nameLine, IASTTemplate ownerTemplate, List references, boolean previouslyDeclared, boolean hasFunctionTryBlock, boolean isFriend, char[] filename) {
        super(symbol);
        this.parameters = parameters;
        this.returnType = returnType;
        this.exception = exception;
        this.setStartingOffsetAndLineNumber(startOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.ownerTemplate = ownerTemplate;
        this.references = references;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
        this.previouslyDeclared = previouslyDeclared;
        this.hasFunctionTryBlock = hasFunctionTryBlock;
        this.isFriendDeclaration = isFriend;
        this.fn = filename;
    }

    public boolean isInline() {
        return this.symbol.getTypeInfo().checkBit(32);
    }

    public boolean isFriend() {
        return this.isFriendDeclaration;
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(4);
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public IASTAbstractDeclaration getReturnType() {
        return this.returnType;
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public IASTExceptionSpecification getExceptionSpec() {
        return this.exception;
    }

    public void setHasFunctionBody(boolean b) {
        this.hasFunctionBody = true;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplate;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            if (this.isFriend()) {
                requestor.acceptFriendDeclaration(this);
            } else {
                requestor.acceptFunctionDeclaration(this);
            }
        }
        catch (Exception exception) {}
        this.functionCallbacks(requestor, manager);
    }

    protected void functionCallbacks(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.references, requestor);
        this.references = null;
        this.processParameterInitializersAndArrayMods(requestor, manager);
        if (this.getReturnType() != null) {
            this.getReturnType().acceptElement(requestor, manager);
        }
    }

    protected void processParameterInitializersAndArrayMods(ISourceElementRequestor requestor, IReferenceManager manager) {
        int size = this.parameters.size();
        int i = 0;
        while (i < size) {
            IASTParameterDeclaration parm = (IASTParameterDeclaration)this.parameters.get(i);
            if (parm.getDefaultValue() != null) {
                parm.getDefaultValue().acceptElement(requestor, manager);
            }
            Iterator arrays = parm.getArrayModifiers();
            while (arrays.hasNext()) {
                ((IASTArrayModifier)arrays.next()).acceptElement(requestor, manager);
            }
            ++i;
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterFunctionBody(this);
        }
        catch (Exception exception) {}
        this.functionCallbacks(requestor, manager);
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public IASTCodeScope getOwnerCodeScope() {
        return this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration() instanceof IASTCodeScope ? (IASTCodeScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration()) : null;
    }

    public boolean previouslyDeclared() {
        return this.previouslyDeclared;
    }

    public void setHasFunctionTryBlock(boolean b) {
        this.hasFunctionTryBlock = b;
    }

    public boolean hasFunctionTryBlock() {
        return this.hasFunctionTryBlock;
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public boolean takesVarArgs() {
        return ((IParameterizedSymbol)this.getSymbol()).hasVariableArgs();
    }

    public IASTFunction getContainingFunction() {
        return this;
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }
}

