/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildOptionSettingsPage
extends BuildSettingsPage {
    private ArrayList fieldsList = new ArrayList();
    private IOptionCategory category;

    BuildOptionSettingsPage(IConfiguration configuration, IOptionCategory category) {
        super(configuration);
        this.category = category;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        IOption[] options = this.category.getOptions(this.configuration);
        int index = 0;
        while (index < options.length) {
            IOption opt = options[index];
            switch (opt.getValueType()) {
                case 2: {
                    StringFieldEditor stringField = new StringFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                    this.addField((FieldEditor)stringField);
                    this.fieldsList.add(stringField);
                    break;
                }
                case 0: {
                    BooleanFieldEditor booleanField = new BooleanFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                    this.addField((FieldEditor)booleanField);
                    this.fieldsList.add(booleanField);
                    break;
                }
                case 1: {
                    String sel;
                    try {
                        String selId = opt.getSelectedEnum();
                        sel = opt.getEnumName(selId);
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    BuildOptionComboFieldEditor comboField = new BuildOptionComboFieldEditor(opt.getId(), opt.getName(), opt.getApplicableValues(), sel, this.getFieldEditorParent());
                    this.addField(comboField);
                    this.fieldsList.add(comboField);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    FileListControlFieldEditor listField = new FileListControlFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent(), opt.getBrowseType());
                    this.addField(listField);
                    this.fieldsList.add(listField);
                    break;
                }
            }
            ++index;
        }
    }

    public boolean isForCategory(IOptionCategory category) {
        if (category != null) {
            return category.equals(this.category);
        }
        return false;
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IOption[] options = this.category.getOptions(this.configuration);
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            switch (option.getValueType()) {
                case 0: {
                    boolean boolVal = this.getPreferenceStore().getBoolean(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (boolean)boolVal);
                    break;
                }
                case 1: {
                    String enumVal = this.getPreferenceStore().getString(option.getId());
                    String enumId = option.getEnumeratedId(enumVal);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String)(enumId.length() > 0 ? enumId : enumVal));
                    break;
                }
                case 2: {
                    String strVal = this.getPreferenceStore().getString(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String)strVal);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String listStr = this.getPreferenceStore().getString(option.getId());
                    String[] listVal = BuildToolsSettingsStore.parseString(listStr);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String[])listVal);
                    break;
                }
            }
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        int i = 0;
        while (i < this.fieldsList.size()) {
            FieldEditor editor = (FieldEditor)this.fieldsList.get(i);
            editor.loadDefault();
            editor.load();
            ++i;
        }
    }

    public void storeSettings() {
        super.performOk();
    }
}

