/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddProjectSourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.SourceLocationWizardNode;
import org.eclipse.cdt.debug.internal.ui.wizards.WizardMessages;
import org.eclipse.cdt.debug.ui.sourcelookup.INewSourceLocationWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SourceLocationSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String PAGE_NAME = WizardMessages.getString("SourceLocationSelectionPage.0");
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;
    protected TableViewer fWizardSelectionViewer;
    protected Object[] fElements = null;

    public SourceLocationSelectionPage(ICSourceLocation[] locations) {
        super(PAGE_NAME);
        this.setTitle(WizardMessages.getString("SourceLocationSelectionPage.1"));
        this.setImageDescriptor(CDebugImages.DESC_WIZBAN_ADD_SOURCE_LOCATION);
        this.fElements = new Object[]{new AddProjectSourceLocationWizard(this.getProjectList(locations)), new AddDirectorySourceLocationWizard()};
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(272));
        new Label(outerContainer, 0).setText(WizardMessages.getString("SourceLocationSelectionPage.2"));
        Table table = new Table(outerContainer, 2048);
        GridData data = new GridData(768);
        data.widthHint = 150;
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        this.fWizardSelectionViewer = new TableViewer(table);
        this.fWizardSelectionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return SourceLocationSelectionPage.this.fElements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fWizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AddProjectSourceLocationWizard) {
                    return WizardMessages.getString("SourceLocationSelectionPage.3");
                }
                if (element instanceof AddDirectorySourceLocationWizard) {
                    return WizardMessages.getString("SourceLocationSelectionPage.4");
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof AddProjectSourceLocationWizard) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.addprjsource_wiz.gif");
                }
                if (element instanceof AddDirectorySourceLocationWizard) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.adddirsource_wiz.gif");
                }
                return super.getImage(element);
            }
        });
        this.fWizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fWizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fWizardSelectionViewer.setInput((Object)this.fElements);
        this.fWizardSelectionViewer.setSelection((ISelection)new StructuredSelection(this.fElements[0]));
        this.setControl((Control)outerContainer);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        INewSourceLocationWizard currentWizardSelection = (INewSourceLocationWizard)selection.getFirstElement();
        if (currentWizardSelection == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(currentWizardSelection));
        this.setMessage(currentWizardSelection.getDescription());
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.fWizardSelectionViewer, this.fWizardSelectionViewer.getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    private IWizardNode createWizardNode(INewSourceLocationWizard wizard) {
        return new SourceLocationWizardNode(wizard);
    }

    public void dispose() {
        if (this.fElements != null) {
            int i = 0;
            while (i < this.fElements.length) {
                ((INewSourceLocationWizard)this.fElements[i]).dispose();
                ++i;
            }
            this.fElements = null;
        }
        super.dispose();
    }

    public ICSourceLocation getSourceLocation() {
        return ((INewSourceLocationWizard)this.getSelectedNode().getWizard()).getSourceLocation();
    }

    private IProject[] getProjectList(ICSourceLocation[] locations) {
        ArrayList<IProject> projects = new ArrayList<IProject>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation) {
                projects.add(((IProjectSourceLocation)locations[i]).getProject());
            }
            ++i;
        }
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(allProjects.length);
        int i2 = 0;
        while (i2 < allProjects.length) {
            if ((CoreModel.hasCNature((IProject)allProjects[i2]) || CoreModel.hasCCNature((IProject)allProjects[i2])) && allProjects[i2].isOpen() && !projects.contains(allProjects[i2])) {
                result.add(allProjects[i2]);
            }
            ++i2;
        }
        return result.toArray(new IProject[result.size()]);
    }
}

