/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecReturn;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointHitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIErrorEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorSignalExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointScopeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointTriggerEvent;
import org.eclipse.cdt.debug.mi.core.output.MIAsyncRecord;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MINotifyAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIStatusAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;
import org.eclipse.cdt.debug.mi.core.output.MITargetStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class RxThread
extends Thread {
    final MISession session;
    List oobList;

    public RxThread(MISession s) {
        super("MI RX Thread");
        this.session = s;
        this.oobList = new ArrayList();
    }

    public void run() {
        CommandQueue rxQueue;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.session.getChannelInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                MIPlugin.getDefault().debugLog(line);
                this.processMIOutput(String.valueOf(line) + "\n");
            }
        }
        catch (IOException iOException) {}
        if (this.session.getChannelInputStream() != null) {
            Runnable cleanup = new Runnable(){

                public void run() {
                    RxThread.this.session.getMIInferior().setTerminated();
                    RxThread.this.session.terminate();
                }
            };
            Thread clean = new Thread(cleanup, "GDB Died");
            clean.setDaemon(true);
            clean.start();
        }
        if ((rxQueue = this.session.getRxQueue()) != null) {
            Command[] cmds = rxQueue.clearCommands();
            int i = 0;
            while (i < cmds.length) {
                Command command = cmds[i];
                synchronized (command) {
                    cmds[i].notifyAll();
                }
                ++i;
            }
        }
    }

    void processMIOutput(String buffer) {
        MIOutput response = this.session.parse(buffer);
        if (response != null) {
            ArrayList<MIEvent> list = new ArrayList<MIEvent>();
            CommandQueue rxQueue = this.session.getRxQueue();
            MIResultRecord rr = response.getMIResultRecord();
            if (rr != null) {
                int id = rr.getToken();
                Command cmd = rxQueue.removeCommand(id);
                MIOOBRecord[] oobRecords = this.oobList.toArray(new MIOOBRecord[0]);
                String state = rr.getResultClass();
                if ("running".equals(state)) {
                    int type = 0;
                    type = cmd instanceof MIExecNext ? 1 : (cmd instanceof MIExecNextInstruction ? 2 : (cmd instanceof MIExecStep ? 3 : (cmd instanceof MIExecStepInstruction ? 4 : (cmd instanceof MIExecUntil ? 6 : (cmd instanceof MIExecFinish ? 5 : (cmd instanceof MIExecReturn ? 7 : (cmd instanceof MIExecContinue ? 0 : 0)))))));
                    this.session.getMIInferior().setRunning();
                    MIRunningEvent event = new MIRunningEvent(id, type);
                    list.add(event);
                } else if ("exit".equals(state)) {
                    this.session.getMIInferior().setTerminated();
                } else if ("connected".equals(state)) {
                    this.session.getMIInferior().setConnected();
                } else if ("error".equals(state)) {
                    if (this.session.getMIInferior().isRunning()) {
                        this.session.getMIInferior().setSuspended();
                        MIErrorEvent event = new MIErrorEvent(rr, oobRecords);
                        list.add(event);
                    }
                } else if ("done".equals(state)) {
                    this.processMIOOBRecord(rr, list);
                }
                if (cmd != null) {
                    Command command = cmd;
                    synchronized (command) {
                        response.setMIOOBRecords(oobRecords);
                        cmd.setMIOutput(response);
                        cmd.notifyAll();
                    }
                }
                this.oobList.clear();
            } else {
                MIOOBRecord[] oobs = response.getMIOOBRecords();
                int i = 0;
                while (i < oobs.length) {
                    this.processMIOOBRecord(oobs[i], list);
                    ++i;
                }
            }
            MIEvent[] events = list.toArray(new MIEvent[list.size()]);
            this.session.fireEvents(events);
        }
    }

    void processMIOOBRecord(MIOOBRecord oob, List list) {
        if (oob instanceof MIAsyncRecord) {
            this.processMIOOBRecord((MIAsyncRecord)oob, list);
            this.oobList.clear();
        } else if (oob instanceof MIStreamRecord) {
            this.processMIOOBRecord((MIStreamRecord)oob);
        }
    }

    void processMIOOBRecord(MIAsyncRecord async, List list) {
        if (async instanceof MIExecAsyncOutput) {
            MIExecAsyncOutput exec = (MIExecAsyncOutput)async;
            String state = exec.getAsyncClass();
            if ("stopped".equals(state)) {
                MIResult[] results = exec.getMIResults();
                int i = 0;
                while (i < results.length) {
                    String reason;
                    MIEvent e;
                    String var = results[i].getVariable();
                    MIValue val = results[i].getMIValue();
                    if (var.equals("reason") && val instanceof MIConst && (e = this.createEvent(reason = ((MIConst)val).getString(), exec)) != null) {
                        list.add(e);
                    }
                    ++i;
                }
                if (list.isEmpty()) {
                    String[] logs = this.getStreamRecords();
                    int i2 = 0;
                    while (i2 < logs.length) {
                        if (logs[i2].equalsIgnoreCase("Stopped due to shared library event")) {
                            this.session.getMIInferior().setSuspended();
                            MISharedLibEvent e = new MISharedLibEvent(exec);
                            list.add(e);
                        }
                        ++i2;
                    }
                }
                if (list.isEmpty()) {
                    this.session.getMIInferior().setSuspended();
                    MIStoppedEvent e = new MIStoppedEvent(exec);
                    list.add(e);
                }
            }
        } else if (!(async instanceof MIStatusAsyncOutput)) {
            boolean cfr_ignored_0 = async instanceof MINotifyAsyncOutput;
        }
    }

    void processMIOOBRecord(MIStreamRecord stream) {
        if (stream instanceof MIConsoleStreamOutput) {
            MIConsoleStreamOutput out;
            String str;
            OutputStream console = this.session.getConsolePipe();
            if (console != null && (str = (out = (MIConsoleStreamOutput)stream).getString()) != null) {
                try {
                    console.write(str.getBytes());
                    console.flush();
                }
                catch (IOException iOException) {}
            }
            this.oobList.add(stream);
        } else if (stream instanceof MITargetStreamOutput) {
            MITargetStreamOutput out;
            String str;
            OutputStream target = this.session.getMIInferior().getPipedOutputStream();
            if (target != null && (str = (out = (MITargetStreamOutput)stream).getString()) != null) {
                try {
                    target.write(str.getBytes());
                    target.flush();
                }
                catch (IOException iOException) {}
            }
        } else if (stream instanceof MILogStreamOutput) {
            MILogStreamOutput out;
            String str;
            OutputStream log = this.session.getLogPipe();
            if (log != null && (str = (out = (MILogStreamOutput)stream).getString()) != null) {
                try {
                    log.write(str.getBytes());
                    log.flush();
                }
                catch (IOException iOException) {}
            }
            this.oobList.add(stream);
        }
    }

    void processMIOOBRecord(MIResultRecord rr, List list) {
        MIResult[] results = rr.getMIResults();
        int i = 0;
        while (i < results.length) {
            String reason;
            MIEvent event;
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("reason") && (value = results[i].getMIValue()) instanceof MIConst && (event = this.createEvent(reason = ((MIConst)value).getString(), rr)) != null) {
                list.add(event);
            }
            ++i;
        }
        if (list.isEmpty()) {
            String[] logs = this.getStreamRecords();
            int i2 = 0;
            while (i2 < logs.length) {
                if (logs[i2].equalsIgnoreCase("Stopped due to shared library event")) {
                    this.session.getMIInferior().setSuspended();
                    MISharedLibEvent e = new MISharedLibEvent(rr);
                    list.add(e);
                }
                ++i2;
            }
        }
        if (list.isEmpty() && this.session.getMIInferior().isRunning()) {
            this.session.getMIInferior().setSuspended();
            MIStoppedEvent event = new MIStoppedEvent(rr);
            this.session.fireEvent(event);
        }
    }

    MIEvent createEvent(String reason, MIExecAsyncOutput exec) {
        return this.createEvent(reason, null, exec);
    }

    MIEvent createEvent(String reason, MIResultRecord rr) {
        return this.createEvent(reason, rr, null);
    }

    MIEvent createEvent(String reason, MIResultRecord rr, MIExecAsyncOutput exec) {
        MIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            if (exec != null) {
                event = new MIBreakpointHitEvent(exec);
            } else if (rr != null) {
                event = new MIBreakpointHitEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            if (exec != null) {
                event = new MIWatchpointTriggerEvent(exec);
            } else if (rr != null) {
                event = new MIWatchpointTriggerEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("watchpoint-scope".equals(reason)) {
            if (exec != null) {
                event = new MIWatchpointScopeEvent(exec);
            } else if (rr != null) {
                event = new MIWatchpointScopeEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("end-stepping-range".equals(reason)) {
            if (exec != null) {
                event = new MISteppingRangeEvent(exec);
            } else if (rr != null) {
                event = new MISteppingRangeEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("signal-received".equals(reason)) {
            if (exec != null) {
                event = new MISignalEvent(exec);
            } else if (rr != null) {
                event = new MISignalEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("location-reached".equals(reason)) {
            if (exec != null) {
                event = new MILocationReachedEvent(exec);
            } else if (rr != null) {
                event = new MILocationReachedEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("function-finished".equals(reason)) {
            if (exec != null) {
                event = new MIFunctionFinishedEvent(exec);
            } else if (rr != null) {
                event = new MIFunctionFinishedEvent(rr);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            if (exec != null) {
                event = new MIInferiorExitEvent(exec);
            } else if (rr != null) {
                event = new MIInferiorExitEvent(rr);
            }
            this.session.getMIInferior().setTerminated();
        } else if ("exited-signalled".equals(reason)) {
            if (exec != null) {
                event = new MIInferiorSignalExitEvent(exec);
            } else if (rr != null) {
                event = new MIInferiorSignalExitEvent(rr);
            }
            this.session.getMIInferior().setTerminated();
        }
        return event;
    }

    String[] getStreamRecords() {
        ArrayList<String> streamRecords = new ArrayList<String>();
        MIOOBRecord[] oobRecords = this.oobList.toArray(new MIOOBRecord[0]);
        int i = 0;
        while (i < oobRecords.length) {
            String s;
            if (oobRecords[i] instanceof MIStreamRecord && (s = ((MIStreamRecord)oobRecords[i]).getString().trim()) != null && s.length() > 0) {
                streamRecords.add(s);
            }
            ++i;
        }
        return streamRecords.toArray(new String[0]);
    }
}

