/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserTimeOut;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexProblemHandler;
import org.eclipse.cdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    IFile resourceFile;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;
    private IASTInclusion currentInclude = null;
    private LinkedList includeStack = new LinkedList();
    private int problemMarkersEnabled = 0;
    private Map problemsMap = null;
    private IProgressMonitor pm = new NullProgressMonitor();
    private ParserTimeOut timeoutThread = null;
    private static final String INDEXER_MARKER_ORIGINATOR = "org.eclipse.cdt.core.indexermarker.originator";
    private static final String INDEXER_MARKER_PREFIX = String.valueOf(Util.bind("indexerMarker.prefix")) + " ";
    private static final String INDEXER_MARKER_PROCESSING = Util.bind("indexerMarker.processing");
    private ArrayList filesTraversed = null;
    private IParser parser;

    public SourceIndexerRequestor(SourceIndexer indexer, IFile resourceFile, ParserTimeOut timeOut) {
        this.indexer = indexer;
        this.resourceFile = resourceFile;
        this.timeoutThread = timeOut;
        this.filesTraversed = new ArrayList(15);
        this.filesTraversed.add(resourceFile.getLocation().toOSString());
    }

    public boolean acceptProblem(IProblem problem) {
        if (this.areProblemMarkersEnabled() && this.shouldRecordProblem(problem)) {
            IASTInclusion include = this.peekInclude();
            IFile tempFile = this.resourceFile;
            if (include != null) {
                Path newPath = new Path(include.getFullFileName());
                tempFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)newPath);
            }
            if (tempFile != null) {
                AddMarkerProblem tempProblem = new AddMarkerProblem(tempFile, this.resourceFile, problem);
                if (this.problemsMap.containsKey(tempFile)) {
                    List list = (List)this.problemsMap.get(tempFile);
                    list.add(tempProblem);
                } else {
                    ArrayList<Problem> list = new ArrayList<Problem>();
                    list.add(new RemoveMarkerProblem(tempFile, this.resourceFile));
                    list.add(tempProblem);
                    this.problemsMap.put(tempFile, list);
                }
            }
        }
        return IndexProblemHandler.ruleOnProblem(problem, ParserMode.COMPLETE_PARSE);
    }

    public void acceptMacro(IASTMacro macro) {
        this.indexer.addMacro(macro);
    }

    public void acceptVariable(IASTVariable variable) {
        this.indexer.addVariable(variable);
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        this.indexer.addFunctionDeclaration(function);
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition asmDefinition) {
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.indexer.addTypedefDeclaration(typedef);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.indexer.addEnumerationSpecifier(enumeration);
    }

    public void enterFunctionBody(IASTFunction function) {
        this.indexer.addFunctionDeclaration(function);
    }

    public void exitFunctionBody(IASTFunction function) {
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
    }

    public void enterInclusion(IASTInclusion inclusion) {
        if (this.areProblemMarkersEnabled()) {
            Path newPath = new Path(inclusion.getFullFileName());
            IFile tempFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)newPath);
            if (tempFile != null) {
                this.requestRemoveMarkers(tempFile, this.resourceFile);
            }
        }
        IASTInclusion parent = this.peekInclude();
        this.indexer.addInclude(inclusion, parent);
        this.pushInclude(inclusion);
        this.filesTraversed.add(inclusion.getFullFileName());
        IProject resourceProject = this.resourceFile.getProject();
        ICFileType type = CCorePlugin.getDefault().getFileType(resourceProject, inclusion.getFullFileName());
        if (type.isHeader()) {
            CCorePlugin.getDefault().getCoreModel().getIndexManager().haveEncounteredHeader(resourceProject.getFullPath(), (IPath)new Path(inclusion.getFullFileName()));
        }
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.indexer.addNamespaceDefinition(namespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        this.indexer.addMethodDeclaration(method);
    }

    public void enterMethodBody(IASTMethod method) {
        this.indexer.addMethodDeclaration(method);
    }

    public void exitMethodBody(IASTMethod method) {
    }

    public void acceptField(IASTField field) {
        this.indexer.addFieldDeclaration(field);
    }

    public void acceptClassReference(IASTClassReference reference) {
        if (reference.getReferencedElement() instanceof IASTClassSpecifier) {
            this.indexer.addClassReference((IASTTypeSpecifier)((IASTClassSpecifier)reference.getReferencedElement()));
        } else if (reference.getReferencedElement() instanceof IASTElaboratedTypeSpecifier) {
            this.indexer.addForwardClassReference((IASTTypeSpecifier)reference.getReferencedElement());
        }
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.indexer.addClassSpecifier(classSpecification);
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
    }

    public void exitInclusion(IASTInclusion inclusion) {
        this.popInclude();
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
    }

    public void acceptTypedefReference(IASTTypedefReference reference) {
        if (reference.getReferencedElement() instanceof IASTTypedefDeclaration) {
            this.indexer.addTypedefReference((IASTTypedefDeclaration)reference.getReferencedElement());
        }
    }

    public void acceptNamespaceReference(IASTNamespaceReference reference) {
        if (reference.getReferencedElement() instanceof IASTNamespaceDefinition) {
            this.indexer.addNamespaceReference((IASTNamespaceDefinition)reference.getReferencedElement());
        }
    }

    public void acceptEnumerationReference(IASTEnumerationReference reference) {
        if (reference.getReferencedElement() instanceof IASTEnumerationSpecifier) {
            this.indexer.addEnumerationReference((IASTEnumerationSpecifier)reference.getReferencedElement());
        }
    }

    public void acceptVariableReference(IASTVariableReference reference) {
        if (reference.getReferencedElement() instanceof IASTVariable) {
            this.indexer.addVariableReference((IASTVariable)reference.getReferencedElement());
        }
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
        if (reference.getReferencedElement() instanceof IASTFunction) {
            this.indexer.addFunctionReference((IASTFunction)reference.getReferencedElement());
        }
    }

    public void acceptFieldReference(IASTFieldReference reference) {
        if (reference.getReferencedElement() instanceof IASTField) {
            this.indexer.addFieldReference((IASTField)reference.getReferencedElement());
        }
    }

    public void acceptMethodReference(IASTMethodReference reference) {
        if (reference.getReferencedElement() instanceof IASTMethod) {
            this.indexer.addMethodReference((IASTMethod)reference.getReferencedElement());
        }
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        this.indexer.addElaboratedForwardDeclaration(elaboratedType);
    }

    public void enterCodeBlock(IASTCodeScope scope) {
    }

    public void exitCodeBlock(IASTCodeScope scope) {
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference reference) {
        if (reference.getReferencedElement() instanceof IASTEnumerator) {
            this.indexer.addEnumeratorReference((IASTEnumerator)reference.getReferencedElement());
        }
    }

    public void acceptParameterReference(IASTParameterReference reference) {
        if (reference.getReferencedElement() instanceof IASTParameterDeclaration) {
            this.indexer.addParameterReference((IASTParameterDeclaration)reference.getReferencedElement());
        }
    }

    public void acceptTemplateParameterReference(IASTTemplateParameterReference reference) {
        boolean cfr_ignored_0 = reference.getReferencedElement() instanceof IASTTemplateParameterReference;
    }

    public void acceptFriendDeclaration(IASTDeclaration declaration) {
    }

    private void pushInclude(IASTInclusion inclusion) {
        this.includeStack.addFirst(this.currentInclude);
        this.currentInclude = inclusion;
    }

    private IASTInclusion popInclude() {
        IASTInclusion oldInclude = this.currentInclude;
        this.currentInclude = this.includeStack.size() > 0 ? (IASTInclusion)this.includeStack.removeFirst() : null;
        return oldInclude;
    }

    private IASTInclusion peekInclude() {
        return this.currentInclude;
    }

    public CodeReader createReader(String finalPath, Iterator workingCopies) {
        return ParserUtil.createReader(finalPath, workingCopies);
    }

    protected void processMarkers(List problemsList) {
        Iterator i = problemsList.iterator();
        while (i.hasNext()) {
            Problem prob = (Problem)i.next();
            if (prob.isAddProblem()) {
                this.addMarkers(prob.file, prob.originator, prob.getIProblem());
                continue;
            }
            this.removeMarkers(prob.file, prob.originator);
        }
    }

    public void removeMarkers(IFile resource, IFile originator) {
        IMarker[] markers;
        if (originator == null) {
            try {
                resource.deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
            }
            catch (CoreException coreException) {}
            return;
        }
        try {
            markers = resource.findMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
        }
        catch (CoreException coreException) {
            return;
        }
        String origPath = originator.getFullPath().toString();
        IMarker mark = null;
        String orig = null;
        int i = 0;
        while (i < markers.length) {
            mark = markers[i];
            try {
                orig = (String)mark.getAttribute(INDEXER_MARKER_ORIGINATOR);
                if (orig != null && orig.equals(origPath)) {
                    mark.delete();
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private void addMarkers(IFile tempFile, IFile originator, IProblem problem) {
        try {
            IMarker[] markers = tempFile.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
            boolean newProblem = true;
            if (markers.length > 0) {
                IMarker tempMarker = null;
                Integer tempInt = null;
                String tempMsgString = null;
                int i = 0;
                while (i < markers.length) {
                    tempMarker = markers[i];
                    tempInt = (Integer)tempMarker.getAttribute("lineNumber");
                    tempMsgString = (String)tempMarker.getAttribute("message");
                    if (tempInt.intValue() == problem.getSourceLineNumber() && tempMsgString.equalsIgnoreCase(String.valueOf(INDEXER_MARKER_PREFIX) + problem.getMessage())) {
                        newProblem = false;
                        break;
                    }
                    ++i;
                }
            }
            if (newProblem) {
                IMarker marker = tempFile.createMarker("org.eclipse.cdt.core.indexermarker");
                int start = problem.getSourceStart();
                int end = problem.getSourceEnd();
                if (end <= start) {
                    end = start + 1;
                }
                marker.setAttribute("location", problem.getSourceLineNumber());
                marker.setAttribute("message", (Object)(String.valueOf(INDEXER_MARKER_PREFIX) + problem.getMessage()));
                marker.setAttribute("severity", 1);
                marker.setAttribute("lineNumber", problem.getSourceLineNumber());
                marker.setAttribute("charStart", start);
                marker.setAttribute("charEnd", end);
                marker.setAttribute(INDEXER_MARKER_ORIGINATOR, (Object)originator.getFullPath().toString());
            }
        }
        catch (CoreException coreException) {}
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    public void setTimeout(int timeout) {
        this.timeoutThread.setTimeout(timeout);
    }

    public void startTimer() {
        this.createProgressMonitor(this.parser);
        while (!this.timeoutThread.isReadyToRun()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.timeoutThread.startTimer();
    }

    public void stopTimer() {
        this.timeoutThread.stopTimer();
        this.pm.setCanceled(false);
    }

    public boolean parserTimeout() {
        return this.pm != null && this.pm.isCanceled();
    }

    private void createProgressMonitor(IParser parser) {
        this.pm.setCanceled(false);
        this.timeoutThread.setParser(parser);
    }

    public boolean areProblemMarkersEnabled() {
        return this.problemMarkersEnabled != 0;
    }

    public void setProblemMarkersEnabled(int value) {
        if (value != 0) {
            this.problemsMap = new HashMap();
        }
        this.problemMarkersEnabled = value;
    }

    public void reportProblems() {
        if (!this.areProblemMarkersEnabled()) {
            return;
        }
        Iterator i = this.problemsMap.keySet().iterator();
        while (i.hasNext()) {
            IFile resource = (IFile)i.next();
            List problemList = (List)this.problemsMap.get(resource);
            if (problemList.size() <= 1) {
                IMarker[] marker;
                try {
                    marker = resource.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
                }
                catch (CoreException coreException) {
                    continue;
                }
                if (marker.length == 0) continue;
            }
            String jobName = INDEXER_MARKER_PROCESSING;
            jobName = String.valueOf(jobName) + " (";
            jobName = String.valueOf(jobName) + resource.getFullPath();
            jobName = String.valueOf(jobName) + ')';
            ProcessMarkersJob job = new ProcessMarkersJob(resource, problemList, jobName);
            IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
            IProgressMonitor group = indexManager.getIndexJobProgressGroup();
            job.setRule((ISchedulingRule)resource);
            if (group != null) {
                job.setProgressGroup(group, 0);
            }
            job.setPriority(50);
            job.schedule();
        }
    }

    public boolean shouldRecordProblem(IProblem problem) {
        boolean syntax;
        if (problem.getSourceLineNumber() == -1) {
            return false;
        }
        boolean preprocessor = (this.problemMarkersEnabled & 1) != 0;
        boolean semantics = (this.problemMarkersEnabled & 2) != 0;
        boolean bl = syntax = (this.problemMarkersEnabled & 4) != 0;
        if (problem.checkCategory(0x2000000)) {
            return preprocessor && problem.getID() != 0x200000B;
        }
        if (problem.checkCategory(0x8000000)) {
            return semantics;
        }
        if (problem.checkCategory(0x4000000)) {
            return syntax;
        }
        return false;
    }

    public void requestRemoveMarkers(IFile resource, IFile originator) {
        if (!this.areProblemMarkersEnabled()) {
            return;
        }
        RemoveMarkerProblem prob = new RemoveMarkerProblem(resource, originator);
        if (this.problemsMap.containsKey(resource)) {
            List list = (List)this.problemsMap.get(resource);
            list.clear();
            list.add(prob);
        } else {
            ArrayList<RemoveMarkerProblem> list = new ArrayList<RemoveMarkerProblem>();
            list.add(prob);
            this.problemsMap.put(resource, list);
        }
    }

    public ArrayList getFilesTraversed() {
        return this.filesTraversed;
    }

    private class ProcessMarkersJob
    extends Job {
        protected final List problems;
        private final IFile resource;

        public ProcessMarkersJob(IFile resource, List problems, String name) {
            super(name);
            this.problems = problems;
            this.resource = resource;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IWorkspaceRunnable job = new IWorkspaceRunnable(this){
                final /* synthetic */ ProcessMarkersJob this$1;
                {
                    this.this$1 = processMarkersJob;
                }

                public void run(IProgressMonitor monitor) {
                    ProcessMarkersJob.access$0(this.this$1).processMarkers(this.this$1.problems);
                }
            };
            try {
                CCorePlugin.getWorkspace().run(job, (ISchedulingRule)this.resource, 0, null);
            }
            catch (CoreException coreException) {}
            return Status.OK_STATUS;
        }

        static /* synthetic */ SourceIndexerRequestor access$0(ProcessMarkersJob processMarkersJob) {
            return processMarkersJob.SourceIndexerRequestor.this;
        }
    }

    private abstract class Problem {
        public IFile file;
        public IFile originator;

        public Problem(IFile file, IFile orig) {
            this.file = file;
            this.originator = orig;
        }

        public abstract boolean isAddProblem();

        public abstract IProblem getIProblem();
    }

    private class AddMarkerProblem
    extends Problem {
        private IProblem problem;

        public AddMarkerProblem(IFile file, IFile orig, IProblem problem) {
            super(file, orig);
            this.problem = problem;
        }

        public boolean isAddProblem() {
            return true;
        }

        public IProblem getIProblem() {
            return this.problem;
        }
    }

    private class RemoveMarkerProblem
    extends Problem {
        public RemoveMarkerProblem(IFile file, IFile orig) {
            super(file, orig);
        }

        public boolean isAddProblem() {
            return false;
        }

        public IProblem getIProblem() {
            return null;
        }
    }
}

