/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fInfo;
    private IWorkbenchPart fTargetPart;
    private IBreakpoint fBreakpoint;

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            ICLineBreakpoint cBreakpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof ICLineBreakpoint && this.breakpointAtRulerLine(cBreakpoint = (ICLineBreakpoint)breakpoint)) {
                return cBreakpoint;
            }
            ++i;
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected boolean breakpointAtRulerLine(ICLineBreakpoint cBreakpoint) {
        int lineNumber = this.getBreakpointLine(cBreakpoint);
        int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
        return rulerLine == lineNumber;
    }

    private int getBreakpointLine(ICLineBreakpoint breakpoint) {
        if (this.getTargetPart() instanceof ISaveablePart && ((ISaveablePart)this.getTargetPart()).isDirty()) {
            try {
                return breakpoint.getLineNumber();
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
        } else {
            IDocument doc;
            Position position = this.getBreakpointPosition(breakpoint);
            if (position != null && (doc = this.getDocument()) != null) {
                try {
                    return doc.getLineOfOffset(position.getOffset());
                }
                catch (BadLocationException x) {
                    DebugPlugin.log((Throwable)x);
                }
            }
        }
        return -1;
    }

    private Position getBreakpointPosition(ICLineBreakpoint breakpoint) {
        IAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            Iterator it = model.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation ann = (Annotation)it.next();
                if (!(ann instanceof MarkerAnnotation) || !((MarkerAnnotation)ann).getMarker().equals((Object)breakpoint.getMarker())) continue;
                return model.getPosition(ann);
            }
        }
        return null;
    }

    private IDocument getDocument() {
        DisassemblyView dv;
        DisassemblyDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetPart;
            IDocumentProvider provider2 = textEditor.getDocumentProvider();
            if (provider2 != null) {
                return provider2.getDocument((Object)textEditor.getEditorInput());
            }
        } else if (targetPart instanceof DisassemblyView && (provider = (dv = (DisassemblyView)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument(dv.getInput());
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        DisassemblyView dv;
        DisassemblyDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetPart;
            IDocumentProvider provider2 = textEditor.getDocumentProvider();
            if (provider2 != null) {
                return provider2.getAnnotationModel((Object)textEditor.getEditorInput());
            }
        } else if (targetPart instanceof DisassemblyView && (provider = (dv = (DisassemblyView)targetPart).getDocumentProvider()) != null) {
            return provider.getAnnotationModel(dv.getInput());
        }
        return null;
    }
}

