/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;

public class CLIProcessor {
    MISession session;

    public CLIProcessor(MISession s) {
        this.session = s;
    }

    void process(CLICommand cmd) {
        String operation = cmd.getOperation().trim();
        int indx = operation.indexOf(32);
        operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim();
        int type = this.getSteppingOperationKind(operation);
        if (type != -1) {
            this.session.getMIInferior().setRunning();
            MIRunningEvent event = new MIRunningEvent(cmd.getToken(), type);
            this.session.fireEvent(event);
        } else if (this.isSettingBreakpoint(operation) || this.isSettingWatchpoint(operation) || this.isChangeBreakpoint(operation) || this.isDeletingBreakpoint(operation)) {
            this.session.fireEvent(new MIBreakpointChangedEvent(0));
        } else if (this.isSettingSignal(operation)) {
            this.session.fireEvent(new MISignalChangedEvent(""));
        } else if (this.isDetach(operation)) {
            this.session.getMIInferior().setDisconnected();
            MIDetachedEvent event = new MIDetachedEvent(cmd.getToken());
            this.session.fireEvent(event);
        }
    }

    int getSteppingOperationKind(String operation) {
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt") && "until".indexOf(operation) != -1) {
            type = 6;
        } else if (operation.startsWith("fin") && "finish".indexOf(operation) != -1) {
            type = 5;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont") && "continue".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("sig") && "signal".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("j") && "jump".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.equals("r") || operation.equals("run")) {
            type = 0;
        }
        return type;
    }

    boolean isSettingBreakpoint(String operation) {
        boolean isbreak = false;
        if (operation.startsWith("b") && "break".indexOf(operation) != -1 || operation.startsWith("tb") && "tbreak".indexOf(operation) != -1 || operation.startsWith("hb") && "hbreak".indexOf(operation) != -1 || operation.startsWith("thb") && "thbreak".indexOf(operation) != -1 || operation.startsWith("rb") && "rbreak".indexOf(operation) != -1) {
            isbreak = true;
        }
        return isbreak;
    }

    boolean isSettingWatchpoint(String operation) {
        boolean isWatch = false;
        if (operation.startsWith("wa") && "watch".indexOf(operation) != -1 || operation.startsWith("rw") && "rwatch".indexOf(operation) != -1 || operation.startsWith("aw") && "awatch".indexOf(operation) != -1) {
            isWatch = true;
        }
        return isWatch;
    }

    boolean isDeletingBreakpoint(String operation) {
        boolean isDelete = false;
        if (operation.startsWith("cl") && "clear".indexOf(operation) != -1 || operation.equals("d") || operation.startsWith("del") && "delete".indexOf(operation) != -1) {
            isDelete = true;
        }
        return isDelete;
    }

    boolean isChangeBreakpoint(String operation) {
        boolean isChange = false;
        if (operation.equals("dis") || operation.equals("disa") || operation.startsWith("disa") && "disable".indexOf(operation) != -1 || operation.equals("en") || operation.startsWith("en") && "enable".indexOf(operation) != -1 || operation.startsWith("ig") && "ignore".indexOf(operation) != -1 || operation.startsWith("cond") && "condition".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    boolean isSettingSignal(String operation) {
        boolean isChange = false;
        if (operation.startsWith("ha") && "handle".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    boolean isDetach(String operation) {
        return operation.startsWith("det") && "detach".indexOf(operation) != -1;
    }
}

