/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    public static final IContainerEntry containerEntry = CoreModel.newContainerEntry((IPath)new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER"));
    private static final QualifiedName defaultConfigProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultConfig");
    private static final QualifiedName defaultTargetProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultTarget");
    public static final String MAJOR_SEPERATOR = ";";
    public static final String MINOR_SEPERATOR = "::";
    private boolean containerCreated;
    private ICProject cProject;
    private String defaultConfigIds;
    private Map defaultConfigMap;
    private ITarget defaultTarget;
    private String defaultTargetId;
    private boolean isDirty;
    private IResource owner;
    private boolean rebuildNeeded;
    private ITarget selectedTarget;
    private List targetList;
    private Map targetMap;
    private String version;

    public ManagedBuildInfo(IResource owner) {
        this.owner = owner;
        this.cProject = CoreModel.getDefault().create(owner.getProject());
        this.containerCreated = false;
        this.isDirty = false;
        this.rebuildNeeded = true;
        IProject project = owner.getProject();
        this.defaultTargetId = null;
        try {
            this.defaultTargetId = project.getPersistentProperty(defaultTargetProperty);
        }
        catch (CoreException coreException) {
            return;
        }
        this.defaultConfigIds = null;
        try {
            this.defaultConfigIds = project.getPersistentProperty(defaultConfigProperty);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public ManagedBuildInfo(IResource owner, Element element) {
        this(owner);
        this.containerCreated = true;
        NodeList targetNodes = element.getElementsByTagName("target");
        int targIndex = targetNodes.getLength() - 1;
        while (targIndex >= 0) {
            new Target(this, (Element)targetNodes.item(targIndex));
            --targIndex;
        }
        this.rebuildNeeded = false;
    }

    public void addTarget(ITarget target) {
        this.getTargetMap().put(target.getId(), target);
        this.getTargets().add(target);
        this.setDirty(true);
    }

    public boolean buildsFileType(String srcExt) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getFilteredTools(project);
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(srcExt)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String getBuildArtifactExtension() {
        String ext = new String();
        ITarget target = this.getDefaultTarget();
        if (target != null) {
            ext = target.getArtifactExtension();
        }
        return ext;
    }

    public String getBuildArtifactName() {
        String name = new String();
        ITarget target = this.getDefaultTarget();
        if (target != null) {
            name = target.getArtifactName();
        }
        return name;
    }

    public String getCleanCommand() {
        String command = new String();
        ITarget target = this.getDefaultTarget();
        if (target != null) {
            command = target.getCleanCommand();
        }
        return command;
    }

    public String getConfigurationName() {
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        return config == null ? new String() : config.getName();
    }

    public String[] getConfigurationNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        IConfiguration[] configs = this.getDefaultTarget().getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            configNames.add(configuration.getName());
            ++i;
        }
        configNames.trimToSize();
        return configNames.toArray(new String[configNames.size()]);
    }

    public ICProject getCProject() {
        return this.cProject;
    }

    private Map getDefaultConfigMap() {
        if (this.defaultConfigMap == null) {
            this.defaultConfigMap = new HashMap();
            if (this.defaultConfigIds != null) {
                String[] majorTokens = this.defaultConfigIds.split(MAJOR_SEPERATOR);
                int index = majorTokens.length - 1;
                while (index >= 0) {
                    IConfiguration config;
                    String[] minorTokens;
                    ITarget target;
                    String idToken = majorTokens[index];
                    if (idToken != null && (target = this.getTarget((minorTokens = idToken.split(MINOR_SEPERATOR))[0])) != null && (config = target.getConfiguration(minorTokens[1])) != null) {
                        this.defaultConfigMap.put(target.getId(), config);
                    }
                    --index;
                }
            }
        }
        return this.defaultConfigMap;
    }

    public IConfiguration getDefaultConfiguration(ITarget target) {
        IConfiguration[] configs;
        IConfiguration config = (IConfiguration)this.getDefaultConfigMap().get(target.getId());
        if (config == null && (configs = this.getDefaultTarget().getConfigurations()).length > 0) {
            config = configs[0];
        }
        return config;
    }

    public ITarget getDefaultTarget() {
        if (this.defaultTarget == null) {
            if (this.defaultTargetId != null) {
                this.defaultTarget = (ITarget)this.getTargetMap().get(this.defaultTargetId);
            }
            if (this.defaultTarget == null && this.getTargets().size() > 0) {
                return (ITarget)this.getTargets().get(0);
            }
        }
        return this.defaultTarget;
    }

    public Map getDefinedSymbols() {
        HashMap symbols = this.getMacroPathEntries();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getFilteredTools(this.owner.getProject());
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IOption[] opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                IOption option = opts[j];
                if (option.getValueType() == 5) {
                    try {
                        ArrayList<String> symbolList = new ArrayList<String>();
                        symbolList.addAll(Arrays.asList(option.getDefinedSymbols()));
                        ListIterator iter = symbolList.listIterator();
                        while (iter.hasNext()) {
                            String symbol = (String)iter.next();
                            if (symbol.length() == 0) continue;
                            String[] tokens = symbol.split("=");
                            String key = tokens[0].trim();
                            String value = tokens.length > 1 ? tokens[1].trim() : new String();
                            symbols.put(key, value);
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++j;
            }
            ++i;
        }
        return symbols;
    }

    public IManagedDependencyGenerator getDependencyGenerator(String sourceExtension) {
        try {
            ITarget target = this.getDefaultTarget();
            ITool[] tools = this.getFilteredTools();
            int index = 0;
            while (index < tools.length) {
                if (tools[index].buildsFileType(sourceExtension)) {
                    return target.getDependencyGenerator(tools[index].getId());
                }
                ++index;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return null;
    }

    private ITool[] getFilteredTools() {
        IProject project = this.owner.getProject();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        return config.getFilteredTools(project);
    }

    public String getFlagsForSource(String extension) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(extension)) {
                try {
                    return tool.getToolFlags();
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    public String getFlagsForTarget(String extension) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                try {
                    return tool.getToolFlags();
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    private ArrayList getIncludePathEntries() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    IIncludeEntry include;
                    int kind = entries[index].getEntryKind();
                    if (kind == 4 && (include = (IIncludeEntry)entries[index]).isSystemInclude()) {
                        IPath entryPath = include.getFullIncludePath();
                        paths.add(entryPath.toString());
                    }
                    ++index;
                }
            }
            catch (CModelException cModelException) {
                paths.clear();
                return paths;
            }
        }
        return paths;
    }

    public String[] getIncludePaths() {
        ArrayList paths = this.getIncludePathEntries();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        IPath location = this.owner.getLocation();
        if (location == null) {
            location = new Path(".");
        }
        IPath root = location.addTrailingSeparator().append(config.getName());
        ITool[] tools = config.getFilteredTools(this.owner.getProject());
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IOption[] opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                IOption option = opts[j];
                if (option.getValueType() == 4) {
                    try {
                        String[] userPaths = option.getIncludePaths();
                        int index = 0;
                        while (index < userPaths.length) {
                            Path userPath = new Path(userPaths[index]);
                            if (userPath.isAbsolute()) {
                                paths.add(userPath.toOSString());
                            } else {
                                IPath absPath = root.addTrailingSeparator().append((IPath)userPath);
                                paths.add(absPath.makeAbsolute().toOSString());
                            }
                            ++index;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++j;
            }
            ++i;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public String[] getLibsForTarget(String extension) {
        Vector<String> libs = new Vector<String>();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(extension)) {
                IOption[] opts = tool.getOptions();
                int i = 0;
                while (i < opts.length) {
                    IOption option = opts[i];
                    if (option.getValueType() == 6) {
                        try {
                            String command = option.getCommand();
                            String[] allLibs = option.getLibraries();
                            int j = 0;
                            while (j < allLibs.length) {
                                String string = allLibs[j];
                                libs.add(String.valueOf(command) + string);
                                ++j;
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++i;
                }
            }
            ++index;
        }
        return libs.toArray(new String[libs.size()]);
    }

    private HashMap getMacroPathEntries() {
        HashMap<String, String> macros = new HashMap<String, String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    if (entries[index].getEntryKind() == 6) {
                        IMacroEntry macro = (IMacroEntry)entries[index];
                        macros.put(macro.getMacroName(), macro.getMacroValue());
                    }
                    ++index;
                }
            }
            catch (CModelException cModelException) {
                macros.clear();
                return macros;
            }
        }
        return macros;
    }

    public String getMakeArguments() {
        return this.getDefaultTarget().getMakeArguments();
    }

    public String getMakeCommand() {
        return this.getDefaultTarget().getMakeCommand();
    }

    public String getOutputExtension(String resourceExtension) {
        String outputExtension = null;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            outputExtension = tool.getOutputExtension(resourceExtension);
            if (outputExtension != null) {
                return outputExtension;
            }
            ++index;
        }
        return null;
    }

    public String getOutputFlag(String outputExt) {
        String ext = outputExt == null ? new String() : outputExt;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputFlag();
            }
            ++index;
        }
        return flags;
    }

    public String getOutputPrefix(String outputExtension) {
        String ext = outputExtension == null ? new String() : outputExtension;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputPrefix();
            }
            ++index;
        }
        return flags;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public ITarget getSelectedTarget() {
        return this.selectedTarget;
    }

    public ITarget getTarget(String id) {
        return (ITarget)this.getTargetMap().get(id);
    }

    private Map getTargetMap() {
        if (this.targetMap == null) {
            this.targetMap = new HashMap();
        }
        return this.targetMap;
    }

    public List getTargets() {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        return this.targetList;
    }

    public String getToolForSource(String sourceExtension) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    public String getToolForTarget(String extension) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    public String[] getUserObjectsForTarget(String extension) {
        Vector<String> objs = new Vector<String>();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(extension)) {
                IOption[] opts = tool.getOptions();
                int i = 0;
                while (i < opts.length) {
                    IOption option = opts[i];
                    if (option.getValueType() == 7) {
                        try {
                            objs.addAll(Arrays.asList(option.getUserObjects()));
                        }
                        catch (BuildException buildException) {}
                    }
                    ++i;
                }
            }
            ++index;
        }
        return objs.toArray(new String[objs.size()]);
    }

    public String getVersion() {
        return this.version;
    }

    private void initializePathEntries() {
        try {
            ManagedBuildCPathEntryContainer container = new ManagedBuildCPathEntryContainer(this.getOwner().getProject());
            CoreModel.getDefault().setPathEntryContainer(new ICProject[]{this.cProject}, (IPathEntryContainer)container, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CModelException cModelException) {}
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        ListIterator iter = this.getTargets().listIterator();
        while (iter.hasNext()) {
            if (!((ITarget)iter.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isHeaderFile(String ext) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return tool.isHeaderFile(ext);
                        }
                        break;
                    }
                    case 1: {
                        if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return tool.isHeaderFile(ext);
                    }
                    case 2: {
                        return tool.isHeaderFile(ext);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++index;
        }
        return false;
    }

    public boolean needsRebuild() {
        if (this.rebuildNeeded) {
            return true;
        }
        ListIterator iter = this.getTargets().listIterator();
        while (iter.hasNext()) {
            if (!((ITarget)iter.next()).needsRebuild()) continue;
            return true;
        }
        return false;
    }

    private void persistDefaultConfigurations() {
        StringBuffer defaultConfigs = new StringBuffer();
        ListIterator iter = this.getTargets().listIterator();
        while (iter.hasNext()) {
            ITarget targ = (ITarget)iter.next();
            IConfiguration config = this.getDefaultConfiguration(targ);
            if (config == null) continue;
            defaultConfigs.append(targ.getId());
            defaultConfigs.append(MINOR_SEPERATOR);
            defaultConfigs.append(config.getId());
            defaultConfigs.append(MAJOR_SEPERATOR);
        }
        IProject project = this.owner.getProject();
        try {
            project.setPersistentProperty(defaultConfigProperty, defaultConfigs.toString().trim());
        }
        catch (CoreException coreException) {}
    }

    private void persistDefaultTarget() {
        IProject project = this.owner.getProject();
        ITarget defTarget = this.getDefaultTarget();
        if (defTarget != null) {
            try {
                project.setPersistentProperty(defaultTargetProperty, defTarget.getId());
            }
            catch (CoreException coreException) {}
        }
    }

    public void removeTarget(String id) {
        this.getTargets().remove(this.getTarget(id));
        this.getTargetMap().remove(id);
        this.setDirty(true);
    }

    public void serialize(Document doc, Element element) {
        ListIterator iter = this.getTargets().listIterator();
        while (iter.hasNext()) {
            Target targ = (Target)iter.next();
            Element targetElement = doc.createElement("target");
            element.appendChild(targetElement);
            targ.serialize(doc, targetElement);
        }
        this.persistDefaultTarget();
        this.persistDefaultConfigurations();
        this.setDirty(false);
    }

    public void setContainerCreated(boolean isCreated) {
        this.containerCreated = isCreated;
    }

    public void setDefaultConfiguration(IConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        ITarget target = configuration.getTarget();
        IConfiguration oldDefault = this.getDefaultConfiguration(target);
        if (this.defaultTarget == null || !configuration.equals(oldDefault)) {
            this.setDefaultTarget(target);
            this.getDefaultConfigMap().put(target.getId(), configuration);
            this.persistDefaultConfigurations();
        }
    }

    public boolean setDefaultConfiguration(String configName) {
        if (configName != null) {
            IConfiguration[] configs = this.getDefaultTarget().getConfigurations();
            int index = configs.length - 1;
            while (index >= 0) {
                IConfiguration config = configs[index];
                if (configName.equalsIgnoreCase(config.getName())) {
                    this.setDefaultConfiguration(config);
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    public void setDefaultTarget(ITarget target) {
        if (target == null) {
            return;
        }
        if (!target.equals(this.defaultTarget)) {
            this.defaultTarget = target;
            this.defaultTargetId = target.getId();
            this.persistDefaultTarget();
            if (this.containerCreated) {
                this.initializePathEntries();
            }
        }
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        ListIterator iter = this.getTargets().listIterator();
        while (iter.hasNext()) {
            ITarget target = (ITarget)iter.next();
            target.setDirty(isDirty);
        }
    }

    public void setRebuildState(boolean rebuild) {
        ListIterator iter = this.getTargets().listIterator();
        while (iter.hasNext()) {
            ((ITarget)iter.next()).setRebuildState(rebuild);
        }
        this.rebuildNeeded = rebuild;
    }

    public void setSelectedTarget(ITarget target) {
        this.selectedTarget = target;
    }

    public void setVersion(String version) {
        if (version != null && !version.equals(this.version)) {
            this.version = version;
            this.setDirty(true);
        }
    }

    public String toString() {
        return "Managed build information for " + this.owner.getName();
    }

    public void updateOwner(IResource resource) {
        if (resource != null && !this.owner.equals((Object)resource)) {
            this.owner = resource;
            ListIterator iter = this.getTargets().listIterator();
            while (iter.hasNext()) {
                ITarget target = (ITarget)iter.next();
                target.updateOwner(resource);
            }
            this.cProject = CoreModel.getDefault().create(this.owner.getProject());
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }
}

