/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class MakeBuilder
extends ACBuilder {
    public static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        boolean bPerformBuild = true;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(args, BUILDER_ID);
        if (!this.shouldBuild(kind, info)) {
            return new IProject[0];
        }
        if (kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                IResource res = delta.getResource();
                if (res != null) {
                    bPerformBuild = res.getProject().equals((Object)this.getProject());
                }
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild && (isClean = this.invokeMake(kind, info, monitor))) {
            this.forgetLastBuiltState();
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        final IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), BUILDER_ID);
        if (this.shouldBuild(15, info)) {
            Job backgroundJob = new Job("Standard Make Builder"){

                protected IStatus run(IProgressMonitor monitor) {
                    MakeBuilder.this.invokeMake(15, info, monitor);
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }
            };
            backgroundJob.setRule((ISchedulingRule)this.getProject());
            backgroundJob.schedule();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean invokeMake(int kind, IMakeBuilderInfo info, IProgressMonitor monitor) {
        boolean isClean = false;
        IProject currProject = this.getProject();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(MakeMessages.getString("MakeBuilder.Invoking_Make_Builder")) + currProject.getName(), 100);
        try {
            try {
                IPath buildCommand = info.getBuildCommand();
                if (buildCommand != null) {
                    String[] targets;
                    IResource res;
                    IConsole console = CCorePlugin.getDefault().getConsole();
                    console.start(currProject);
                    ConsoleOutputStream cos = console.getOutputStream();
                    this.removeAllMarkers(currProject);
                    IPath workingDirectory = null;
                    if (!info.getBuildLocation().isEmpty() && (res = currProject.getParent().findMember(info.getBuildLocation())) instanceof IContainer && res.exists()) {
                        workingDirectory = res.getLocation();
                    }
                    if (workingDirectory == null) {
                        workingDirectory = currProject.getLocation();
                    }
                    if ((targets = this.getTargets(kind, info)).length != 0 && targets[targets.length - 1].equals(info.getCleanBuildTarget())) {
                        isClean = true;
                    }
                    String errMsg = null;
                    CommandLauncher launcher = new CommandLauncher();
                    launcher.showCommand(true);
                    Properties props = launcher.getEnvironment();
                    props.putAll((Map<?, ?>)info.getEnvironment());
                    props.put("CWD", workingDirectory.toOSString());
                    props.put("PWD", workingDirectory.toOSString());
                    String[] env = null;
                    ArrayList<String> envList = new ArrayList<String>();
                    Enumeration<?> names = props.propertyNames();
                    if (names != null) {
                        while (true) {
                            if (!names.hasMoreElements()) {
                                env = envList.toArray(new String[envList.size()]);
                                break;
                            }
                            String key = (String)names.nextElement();
                            envList.add(String.valueOf(key) + "=" + props.getProperty(key));
                        }
                    }
                    String[] buildArguments = targets;
                    if (info.isDefaultBuildCmd()) {
                        if (!info.isStopOnError()) {
                            buildArguments = new String[targets.length + 1];
                            buildArguments[0] = "-k";
                            System.arraycopy(targets, 0, buildArguments, 1, targets.length);
                        }
                    } else {
                        String args = info.getBuildArguments();
                        if (args != null && !args.equals("")) {
                            String[] newArgs = this.makeArray(args);
                            buildArguments = new String[targets.length + newArgs.length];
                            System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                            System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                        }
                    }
                    QualifiedName qName = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "progressMonitor");
                    Integer last = (Integer)this.getProject().getSessionProperty(qName);
                    if (last == null) {
                        last = new Integer(100);
                    }
                    StreamMonitor streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)cos, last);
                    ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectory, (IMarkerGenerator)this, info.getErrorParsers());
                    epm.setOutputStream((OutputStream)streamMon);
                    OutputStream stdout = epm.getOutputStream();
                    OutputStream stderr = epm.getOutputStream();
                    OutputStream sniffer = ScannerInfoConsoleParserFactory.getMakeBuilderOutputSniffer(epm.getOutputStream(), this.getProject(), workingDirectory, (IMarkerGenerator)this);
                    Process p = launcher.execute(buildCommand, buildArguments, env, workingDirectory);
                    if (p != null) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        monitor.subTask(String.valueOf(MakeMessages.getString("MakeBuilder.Invoking_Command")) + launcher.getCommandLine());
                        if (launcher.waitAndRead(sniffer, sniffer, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor.subTask(MakeMessages.getString("MakeBuilder.Updating_project"));
                        try {
                            currProject.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    this.getProject().setSessionProperty(qName, !monitor.isCanceled() && !isClean ? new Integer(streamMon.getWorkDone()) : null);
                    if (errMsg != null) {
                        StringBuffer buf = new StringBuffer(String.valueOf(buildCommand.toString()) + " ");
                        int i = 0;
                        while (true) {
                            if (i >= buildArguments.length) {
                                String errorDesc = MakeMessages.getFormattedString("MakeBuilder.buildError", buf.toString());
                                buf = new StringBuffer(errorDesc);
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append("(").append(errMsg).append(")");
                                cos.write(buf.toString().getBytes());
                                cos.flush();
                                break;
                            }
                            buf.append(buildArguments[i]);
                            buf.append(' ');
                            ++i;
                        }
                    }
                    stdout.close();
                    stderr.close();
                    monitor.subTask(MakeMessages.getString("MakeBuilder.Creating_Markers"));
                    sniffer.close();
                    epm.reportProblems();
                    cos.close();
                }
            }
            catch (Exception e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var28_31 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var28_32 = null;
        }
        monitor.done();
        return isClean;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 10: {
                return info.isIncrementalBuildEnabled();
            }
            case 6: {
                return info.isFullBuildEnabled();
            }
            case 15: {
                return info.isCleanBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int kind, IMakeBuilderInfo info) {
        String targets = "";
        switch (kind) {
            case 9: {
                targets = info.getAutoBuildTarget();
                break;
            }
            case 10: {
                targets = info.getIncrementalBuildTarget();
                break;
            }
            case 6: {
                targets = info.getFullBuildTarget();
                break;
            }
            case 15: {
                targets = info.getCleanBuildTarget();
            }
        }
        return this.makeArray(targets);
    }

    String[] makeArray(String string) {
        string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    boolean bl = inComment = !inComment;
                }
            }
            if (c == ' ' && !inComment) {
                aList.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }
}

