/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectMap;

public class DeferredTemplateInstance
extends BasicSymbol
implements IDeferredTemplateInstance {
    private ITemplateSymbol _template;
    private List _arguments;

    public DeferredTemplateInstance(ParserSymbolTable table, ITemplateSymbol template, List args) {
        super(table, ParserSymbolTable.EMPTY_NAME_ARRAY);
        this._template = template;
        this._arguments = new ArrayList(args);
        this.setContainingSymbol(template);
        if (template.getTemplatedSymbol() != null) {
            this.setASTExtension(template.getTemplatedSymbol().getASTExtension());
        }
    }

    public ITemplateSymbol getTemplate() {
        return this._template;
    }

    public List getArguments() {
        return this._arguments;
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        List args = this.getArguments();
        ArrayList<ITypeInfo> newArgs = new ArrayList<ITypeInfo>(args.size());
        int size = args.size();
        int i = 0;
        while (i < size) {
            ITypeInfo arg = (ITypeInfo)args.get(i);
            newArgs.add(TemplateEngine.instantiateTypeInfo(arg, template, argMap));
            ++i;
        }
        ITemplateSymbol deferredTemplate = this.getTemplate();
        if (deferredTemplate.isType(ITypeInfo.t_templateParameter) && argMap.containsKey(deferredTemplate)) {
            ITypeInfo i2 = (ITypeInfo)argMap.get(deferredTemplate);
            deferredTemplate = (ITemplateSymbol)i2.getTypeSymbol();
        }
        ISymbol instance = deferredTemplate.instantiate(newArgs);
        return instance;
    }

    public boolean isType(ITypeInfo.eType type, ITypeInfo.eType upperType) {
        IContainerSymbol symbol = this._template.getTemplatedSymbol();
        if (symbol != null) {
            return symbol.isType(type, upperType);
        }
        return super.isType(type, upperType);
    }

    public ITypeInfo.eType getType() {
        IContainerSymbol symbol = this._template.getTemplatedSymbol();
        if (symbol != null) {
            return symbol.getType();
        }
        return super.getType();
    }

    public ITypeInfo getTypeInfo() {
        IContainerSymbol symbol = this._template.getTemplatedSymbol();
        if (symbol != null) {
            return symbol.getTypeInfo();
        }
        return super.getTypeInfo();
    }

    public boolean isType(ITypeInfo.eType type) {
        return this._template.getTemplatedSymbol().isType(type);
    }

    public ISymbolASTExtension getASTExtension() {
        if (super.getASTExtension() != null) {
            return super.getASTExtension();
        }
        if (this._template.getTemplatedSymbol() != null) {
            return this._template.getTemplatedSymbol().getASTExtension();
        }
        return this._template.getASTExtension();
    }
}

