/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateInstantiation;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateSpecialization;
import org.eclipse.cdt.internal.core.parser.pst.ExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectMap;

public class TemplateFactory
extends ExtensibleSymbol
implements ITemplateFactory {
    private IContainerSymbol lastSymbol;
    private ArrayList templates = new ArrayList(4);
    private ArrayList symbols = new ArrayList(4);
    private ObjectMap argMap = new ObjectMap(2);

    protected TemplateFactory(ParserSymbolTable table) {
        super(table);
    }

    public void pushTemplate(ITemplateSymbol template) {
        this.templates.add(template);
    }

    public void pushSymbol(ISymbol symbol) {
        this.symbols.add(symbol);
    }

    public void pushTemplateId(ISymbol symbol, List args) {
        this.symbols.add(symbol);
        this.argMap.put(symbol, new ArrayList(args));
    }

    public void addTemplateId(ISymbol symbol, List args) throws ParserSymbolTableException {
        List params;
        ITemplateSymbol origTemplate;
        ISymbol previous = this.findPreviousSymbol(symbol, args);
        ITemplateSymbol iTemplateSymbol = origTemplate = previous != null && previous.getContainingSymbol() instanceof ITemplateSymbol ? (ITemplateSymbol)previous.getContainingSymbol() : null;
        if (origTemplate == null) {
            throw new ParserSymbolTableException(4);
        }
        ITemplateSymbol template = (ITemplateSymbol)this.templates.get(this.templates.size() - 1);
        List list = params = template != null ? template.getParameterList() : null;
        if (params == null) {
            this.addExplicitInstantiation(origTemplate, args);
        } else if (params.size() == 0) {
            this.addExplicitSpecialization(origTemplate, symbol, args);
        } else {
            ISpecializedSymbol spec = template.getSymbolTable().newSpecializedSymbol(symbol.getName());
            int size = params.size();
            int i = 0;
            while (i < size) {
                spec.addTemplateParameter((ISymbol)params.get(i));
                ++i;
            }
            size = args.size();
            spec.prepareArguments(size);
            i = 0;
            while (i < size) {
                spec.addArgument((ITypeInfo)args.get(i));
                ++i;
            }
            spec.addSymbol(symbol);
            origTemplate.addSpecialization(spec);
            if (this.getASTExtension() != null) {
                TemplateSymbolExtension extension = (TemplateSymbolExtension)template.getASTExtension();
                extension.replaceSymbol(spec);
                ASTTemplateDeclaration templateDecl = (ASTTemplateDeclaration)this.getASTExtension().getPrimaryDeclaration();
                templateDecl.releaseFactory();
                templateDecl.setSymbol(spec);
                templateDecl.setOwnedDeclaration(symbol);
            }
        }
    }

    public void addSymbol(ISymbol symbol) throws ParserSymbolTableException {
        this.lastSymbol = this.getLastSymbol();
        ISymbol sym = null;
        ISymbol container = null;
        boolean templateParamState = false;
        int size = this.symbols.size();
        int templatesSize = this.templates.size();
        int templatesIdx = 0;
        int i = 0;
        while (i < size) {
            sym = (ISymbol)this.symbols.get(i);
            if (!sym.getContainingSymbol().isType(ITypeInfo.t_template)) {
                this.symbols.remove(i--);
                --size;
            } else if (templatesIdx < templatesSize) {
                ITemplateSymbol template;
                if ((template = (ITemplateSymbol)this.templates.get(templatesIdx++)).getParameterList().size() == 0) {
                    templateParamState = true;
                    container = sym;
                } else if (templateParamState) {
                    throw new ParserSymbolTableException(4);
                }
            } else {
                throw new ParserSymbolTableException(4);
            }
            ++i;
        }
        int numTemplates = this.templates.size();
        int numSymbols = this.symbols.size();
        if (templateParamState) {
            List args = (List)this.argMap.get(container);
            this.addExplicitSpecialization((ITemplateSymbol)container.getContainingSymbol(), symbol, args);
            return;
        }
        if (numTemplates == numSymbols + 1) {
            this.basicTemplateDeclaration(symbol);
            return;
        }
        if (numTemplates == numSymbols) {
            this.memberDeclaration(symbol);
            return;
        }
    }

    private ISymbol findPreviousSymbol(ISymbol symbol, List args) throws ParserSymbolTableException {
        ISymbol previous = null;
        ArrayList<ITypeInfo> argList = null;
        if (symbol instanceof IParameterizedSymbol) {
            List params = ((IParameterizedSymbol)symbol).getParameterList();
            int size = params.size();
            argList = new ArrayList<ITypeInfo>(size);
            int i = 0;
            while (i < size) {
                ISymbol param = (ISymbol)params.get(i);
                argList.add(param.getTypeInfo());
                ++i;
            }
        }
        previous = symbol.isType(ITypeInfo.t_function) ? (args != null ? this.lookupFunctionTemplateId(symbol.getName(), argList, args, false) : this.lookupMethodForDefinition(symbol.getName(), argList)) : (symbol.isType(ITypeInfo.t_constructor) ? this.lookupConstructor(argList) : this.lookupMemberForDefinition(symbol.getName()));
        return previous;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void basicTemplateDeclaration(ISymbol symbol) throws ParserSymbolTableException {
        ITemplateSymbol template = (ITemplateSymbol)this.templates.get(0);
        if (template.getParameterList().size() == 0) {
            ISymbol previous = this.findPreviousSymbol(symbol, new ArrayList());
            if (previous == null || !(previous.getContainingSymbol() instanceof ITemplateSymbol)) {
                throw new ParserSymbolTableException(4);
            }
            List args = null;
            if (symbol instanceof IParameterizedSymbol) {
                args = TemplateEngine.resolveTemplateFunctionArguments(null, (ITemplateSymbol)previous.getContainingSymbol(), (IParameterizedSymbol)symbol);
            }
            if (args == null) throw new ParserSymbolTableException(4);
            this.addTemplateId(symbol, args);
            return;
        } else {
            ISymbol previous = this.findPreviousSymbol(symbol, null);
            if (previous == null) {
                template.setName(symbol.getName());
                template.addSymbol(symbol);
                this.getContainingSymbol().addSymbol(template);
                if (this.getASTExtension() == null) return;
                ASTTemplateDeclaration templateDecl = (ASTTemplateDeclaration)this.getASTExtension().getPrimaryDeclaration();
                templateDecl.releaseFactory();
                templateDecl.setOwnedDeclaration(symbol);
                return;
            } else {
                void var5_11;
                ITemplateSymbol originalTemplate = null;
                Object var5_8 = null;
                if (previous instanceof ITemplateSymbol) {
                    originalTemplate = (ITemplateSymbol)previous;
                    IContainerSymbol iContainerSymbol = originalTemplate.getTemplatedSymbol();
                } else {
                    if (!(previous.getContainingSymbol() instanceof ITemplateSymbol)) throw new ParserSymbolTableException(4);
                    originalTemplate = (ITemplateSymbol)previous.getContainingSymbol();
                    ISymbol iSymbol = previous;
                }
                if (!var5_11.isForwardDeclaration()) throw new ParserSymbolTableException(3);
                if (originalTemplate.getParameterList().size() != template.getParameterList().size()) {
                    throw new ParserSymbolTableException(4);
                }
                this.symbols.add(var5_11);
                this.doDefinitionParameterMaps(symbol);
                originalTemplate.addSymbol(symbol);
                if (this.getASTExtension() == null) return;
                ASTTemplateDeclaration templateDecl = (ASTTemplateDeclaration)this.getASTExtension().getPrimaryDeclaration();
                templateDecl.releaseFactory();
                templateDecl.setOwnedDeclaration(symbol);
            }
        }
    }

    private void memberDeclaration(ISymbol symbol) throws ParserSymbolTableException {
        ISymbol previous = this.findPreviousSymbol(symbol, null);
        if (previous == null) {
            throw new ParserSymbolTableException(4);
        }
        IContainerSymbol originalContainer = previous.getContainingSymbol();
        if (previous.isForwardDeclaration()) {
            this.doDefinitionParameterMaps(symbol);
            originalContainer.addSymbol(symbol);
            if (this.getASTExtension() != null) {
                ASTTemplateDeclaration templateDecl = (ASTTemplateDeclaration)this.getASTExtension().getPrimaryDeclaration();
                templateDecl.releaseFactory();
                templateDecl.setOwnedDeclaration(symbol);
            }
        } else {
            throw new ParserSymbolTableException(3);
        }
    }

    private void doDefinitionParameterMaps(ISymbol newSymbol) throws ParserSymbolTableException {
        if (this.templates.size() != this.symbols.size()) {
            throw new ParserSymbolTableException(4);
        }
        int size = this.templates.size();
        int i = 0;
        while (i < size) {
            ITemplateSymbol template = (ITemplateSymbol)this.templates.get(i);
            ITemplateSymbol origTemplate = (ITemplateSymbol)((ISymbol)this.symbols.get(i)).getContainingSymbol();
            List tList = template.getParameterList();
            List oList = origTemplate.getParameterList();
            int tListSize = tList.size();
            if (oList.size() < tListSize) {
                throw new ParserSymbolTableException(4);
            }
            ObjectMap defnMap = new ObjectMap(tListSize);
            int j = 0;
            while (j < tListSize) {
                ISymbol param = (ISymbol)tList.get(j);
                ISymbol origParam = (ISymbol)oList.get(j);
                defnMap.put(param, origParam);
                ++j;
            }
            ((TemplateSymbol)origTemplate).addToDefinitionParameterMap(newSymbol, defnMap);
            ++i;
        }
    }

    private void addExplicitInstantiation(ITemplateSymbol origTemplate, List args) throws ParserSymbolTableException {
        ISymbol instance = origTemplate.instantiate(args);
        if (this.getASTExtension() != null) {
            ASTTemplateInstantiation templateInstance = (ASTTemplateInstantiation)this.getASTExtension().getPrimaryDeclaration();
            templateInstance.releaseFactory();
            templateInstance.setInstanceSymbol(instance);
        }
    }

    private void addExplicitSpecialization(ITemplateSymbol template, ISymbol symbol, List arguments) throws ParserSymbolTableException {
        template.addExplicitSpecialization(symbol, arguments);
        int size = this.symbols.size();
        int i = 0;
        while (i < size) {
            IContainerSymbol container;
            IContainerSymbol sym = (IContainerSymbol)this.symbols.get(0);
            ISymbol instantiated = sym.getInstantiatedSymbol();
            if (instantiated != null && (container = instantiated.getContainingSymbol()).isType(ITypeInfo.t_template)) {
                ((ITemplateSymbol)container).removeInstantiation(sym);
            }
            ++i;
        }
        if (this.getASTExtension() != null) {
            ASTTemplateSpecialization spec = (ASTTemplateSpecialization)this.getASTExtension().getPrimaryDeclaration();
            spec.setOwnedDeclaration(symbol);
        }
    }

    private IContainerSymbol getLastSymbol() {
        if (this.lastSymbol != null) {
            return this.lastSymbol;
        }
        if (!this.symbols.isEmpty()) {
            ISymbol symbol = (ISymbol)this.symbols.get(this.symbols.size() - 1);
            if (symbol instanceof IDeferredTemplateInstance) {
                return ((IDeferredTemplateInstance)symbol).getTemplate().getTemplatedSymbol();
            }
            if (symbol instanceof IContainerSymbol) {
                return (IContainerSymbol)symbol;
            }
        }
        return null;
    }

    public ISymbol lookupMemberForDefinition(char[] name) throws ParserSymbolTableException {
        ISymbol look = null;
        IContainerSymbol last = this.getLastSymbol();
        look = last != null ? last.lookupMemberForDefinition(name) : this.getContainingSymbol().lookupMemberForDefinition(name);
        if (look instanceof ITemplateSymbol) {
            return ((ITemplateSymbol)look).getTemplatedSymbol();
        }
        return look;
    }

    public ISymbol elaboratedLookup(ITypeInfo.eType type, char[] name) throws ParserSymbolTableException {
        int size = this.templates.size();
        int i = size - 1;
        while (i >= 0) {
            ITemplateSymbol template = (ITemplateSymbol)this.templates.get(i);
            ISymbol look = template.lookupMemberForDefinition(name);
            if (look != null && look.isType(type)) {
                return look;
            }
            --i;
        }
        return this.getContainingSymbol().elaboratedLookup(type, name);
    }

    public ISymbol lookup(char[] name) throws ParserSymbolTableException {
        int size = this.templates.size();
        int i = size - 1;
        while (i >= 0) {
            ITemplateSymbol template = (ITemplateSymbol)this.templates.get(i);
            ISymbol look = template.lookupMemberForDefinition(name);
            if (look != null) {
                return look;
            }
            --i;
        }
        return this.getContainingSymbol().lookup(name);
    }

    public IParameterizedSymbol lookupMethodForDefinition(char[] name, List parameters) throws ParserSymbolTableException {
        IParameterizedSymbol found;
        IContainerSymbol last = this.getLastSymbol();
        if (last != null && (found = last.lookupMethodForDefinition(name, parameters)) != null) {
            return found;
        }
        return this.getContainingSymbol().lookupMethodForDefinition(name, parameters);
    }

    public IContainerSymbol lookupNestedNameSpecifier(char[] name) throws ParserSymbolTableException {
        return this.getContainingSymbol().lookupNestedNameSpecifier(name);
    }

    public ISymbol qualifiedLookup(char[] name) throws ParserSymbolTableException {
        return this.getContainingSymbol().qualifiedLookup(name);
    }

    public ISymbol qualifiedLookup(char[] name, ITypeInfo.eType t) throws ParserSymbolTableException {
        return this.getContainingSymbol().qualifiedLookup(name, t);
    }

    public IParameterizedSymbol unqualifiedFunctionLookup(char[] name, List parameters) throws ParserSymbolTableException {
        return this.getContainingSymbol().unqualifiedFunctionLookup(name, parameters);
    }

    public IParameterizedSymbol memberFunctionLookup(char[] name, List parameters) throws ParserSymbolTableException {
        return this.getContainingSymbol().memberFunctionLookup(name, parameters);
    }

    public IParameterizedSymbol qualifiedFunctionLookup(char[] name, List parameters) throws ParserSymbolTableException {
        return this.getContainingSymbol().qualifiedFunctionLookup(name, parameters);
    }

    public ISymbol lookupTemplateId(char[] name, List arguments) throws ParserSymbolTableException {
        ISymbol look = null;
        IContainerSymbol last = this.getLastSymbol();
        look = last != null ? last.lookupTemplateId(name, arguments) : this.getContainingSymbol().lookupTemplateId(name, arguments);
        return look;
    }

    public IContainerSymbol lookupTemplateIdForDefinition(char[] name, List arguments) throws ParserSymbolTableException {
        ISymbol look = null;
        IContainerSymbol last = this.getLastSymbol();
        look = last != null ? last.lookupMemberForDefinition(name) : this.getContainingSymbol().lookupMemberForDefinition(name);
        if (look instanceof ITemplateSymbol) {
            ITemplateSymbol t = TemplateEngine.selectTemplateOrSpecialization((ITemplateSymbol)look, this.getNextAvailableTemplate().getParameterList(), arguments);
            look = t.getTemplatedSymbol();
        }
        return (IContainerSymbol)(look instanceof IContainerSymbol ? look : null);
    }

    public ISymbol lookupFunctionTemplateId(char[] name, List parameters, List arguments, boolean forDefinition) throws ParserSymbolTableException {
        IParameterizedSymbol found;
        IContainerSymbol last = this.getLastSymbol();
        if (last != null && (found = (IParameterizedSymbol)last.lookupFunctionTemplateId(name, parameters, arguments, forDefinition)) != null) {
            return found;
        }
        return this.getContainingSymbol().lookupFunctionTemplateId(name, parameters, arguments, forDefinition);
    }

    public IParameterizedSymbol lookupConstructor(List parameters) throws ParserSymbolTableException {
        IDerivableContainerSymbol derivable;
        IParameterizedSymbol found;
        IContainerSymbol last = this.getLastSymbol();
        if (last != null && last instanceof IDerivableContainerSymbol && (found = (derivable = (IDerivableContainerSymbol)last).lookupConstructor(parameters)) != null) {
            return found;
        }
        if (this.getContainingSymbol() instanceof IDerivableContainerSymbol) {
            return ((IDerivableContainerSymbol)this.getContainingSymbol()).lookupConstructor(parameters);
        }
        return null;
    }

    private ITemplateSymbol getNextAvailableTemplate() throws ParserSymbolTableException {
        int numSymbols = this.symbols.size();
        int numTemplates = this.templates.size();
        int templateIdx = 0;
        int i = 0;
        while (i < numSymbols) {
            ISymbol symbol = (ISymbol)this.symbols.get(i);
            if (symbol.getContainingSymbol().isType(ITypeInfo.t_template)) {
                if (templateIdx < numTemplates) {
                    ++templateIdx;
                } else {
                    throw new ParserSymbolTableException(4);
                }
            }
            ++i;
        }
        if (templateIdx >= numTemplates) {
            return null;
        }
        return (ITemplateSymbol)this.templates.get(templateIdx);
    }

    public boolean removeSymbol(ISymbol symbol) {
        return false;
    }

    public boolean hasUsingDirectives() {
        return false;
    }

    public List getUsingDirectives() {
        return null;
    }

    public IUsingDirectiveSymbol addUsingDirective(IContainerSymbol namespace) {
        return null;
    }

    public IUsingDeclarationSymbol addUsingDeclaration(char[] name) {
        return null;
    }

    public IUsingDeclarationSymbol addUsingDeclaration(char[] name, IContainerSymbol declContext) {
        return null;
    }

    public CharArrayObjectMap getContainedSymbols() {
        return null;
    }

    public List prefixLookup(TypeFilter filter, char[] prefix, boolean qualified, List paramList) {
        return null;
    }

    public boolean isVisible(ISymbol symbol, IContainerSymbol qualifyingSymbol) {
        return false;
    }

    public Iterator getContentsIterator() {
        return null;
    }

    public Object clone() {
        return null;
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMapParm) {
        return null;
    }

    public void setName(char[] name) {
    }

    public char[] getName() {
        return null;
    }

    public boolean isType(ITypeInfo.eType type) {
        return false;
    }

    public boolean isType(ITypeInfo.eType type, ITypeInfo.eType upperType) {
        return false;
    }

    public ITypeInfo.eType getType() {
        return null;
    }

    public void setType(ITypeInfo.eType t) {
    }

    public ITypeInfo getTypeInfo() {
        return null;
    }

    public void setTypeInfo(ITypeInfo info) {
    }

    public ISymbol getTypeSymbol() {
        return null;
    }

    public void setTypeSymbol(ISymbol type) {
    }

    public boolean isForwardDeclaration() {
        return false;
    }

    public void setIsForwardDeclaration(boolean forward) {
    }

    public int compareCVQualifiersTo(ISymbol symbol) {
        return 0;
    }

    public List getPtrOperators() {
        return null;
    }

    public void addPtrOperator(ITypeInfo.PtrOp ptrOp) {
    }

    public boolean isTemplateInstance() {
        return false;
    }

    public ISymbol getInstantiatedSymbol() {
        return null;
    }

    public void setInstantiatedSymbol(ISymbol symbol) {
    }

    public boolean isTemplateMember() {
        return false;
    }

    public void setIsTemplateMember(boolean isMember) {
    }

    public int getDepth() {
        return 0;
    }

    public boolean getIsInvisible() {
        return false;
    }

    public void setIsInvisible(boolean invisible) {
    }

    public void addParent(ISymbol parent) {
    }

    public void addParent(ISymbol parent, boolean virtual, ASTAccessVisibility visibility, int offset, List references) {
    }

    public List getParents() {
        return null;
    }

    public boolean hasParents() {
        return false;
    }

    public void addConstructor(IParameterizedSymbol constructor) {
    }

    public void addCopyConstructor() {
    }

    public List getConstructors() {
        return null;
    }

    public void addFriend(ISymbol friend) {
    }

    public ISymbol lookupForFriendship(char[] name) {
        return null;
    }

    public IParameterizedSymbol lookupFunctionForFriendship(char[] name, List parameters) {
        return null;
    }

    public List getFriends() {
        return null;
    }

    public void preparePtrOperatros(int numPtrOps) {
    }

    public void setForwardSymbol(ISymbol forward) {
    }

    public ISymbol getForwardSymbol() {
        return null;
    }
}

