/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

public class CharArrayUtils {
    public static final int hash(char[] str, int start, int length) {
        int h = 0;
        int end = start + length;
        int curr = start;
        while (curr < end) {
            h += (h << 3) + str[curr];
            ++curr;
        }
        return h;
    }

    public static final int hash(char[] str) {
        return CharArrayUtils.hash(str, 0, str.length);
    }

    public static final boolean equals(char[] str1, char[] str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1.length != str2.length) {
            return false;
        }
        int i = 0;
        while (i < str1.length) {
            if (str1[i] != str2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(char[] str1, int start1, int length1, char[] str2) {
        if (length1 != str2.length || str1.length < length1) {
            return false;
        }
        if (str1 == str2 && start1 == 0) {
            return true;
        }
        int i = 0;
        while (i < length1) {
            if (str1[start1++] != str2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(char[] str1, int start1, int length1, char[] str2, boolean ignoreCase) {
        if (!ignoreCase) {
            return CharArrayUtils.equals(str1, start1, length1, str2);
        }
        if (length1 != str2.length || str1.length < length1) {
            return false;
        }
        int i = 0;
        while (i < length1) {
            if (Character.toLowerCase(str1[start1++]) != Character.toLowerCase(str2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final char[] extract(char[] str, int start, int length) {
        if (start == 0 && length == str.length) {
            return str;
        }
        char[] copy = new char[length];
        System.arraycopy(str, start, copy, 0, length);
        return copy;
    }

    public static final char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final char[] replace(char[] array, char[] toBeReplaced, char[] replacementChars) {
        int max = array.length;
        int replacedLength = toBeReplaced.length;
        int replacementLength = replacementChars.length;
        int[] starts = new int[5];
        int occurrenceCount = 0;
        if (!CharArrayUtils.equals(toBeReplaced, replacementChars)) {
            int i = 0;
            while (i < max) {
                block7: {
                    int j = 0;
                    while (j < replacedLength) {
                        if (i + j != max && array[i + j] == toBeReplaced[j++]) {
                            continue;
                        }
                        break block7;
                    }
                    if (occurrenceCount == starts.length) {
                        int[] nArray = starts;
                        starts = new int[occurrenceCount * 2];
                        System.arraycopy(nArray, 0, starts, 0, occurrenceCount);
                    }
                    starts[occurrenceCount++] = i;
                }
                ++i;
            }
        }
        if (occurrenceCount == 0) {
            return array;
        }
        char[] result = new char[max + occurrenceCount * (replacementLength - replacedLength)];
        int inStart = 0;
        int outStart = 0;
        int i = 0;
        while (i < occurrenceCount) {
            int offset = starts[i] - inStart;
            System.arraycopy(array, inStart, result, outStart, offset);
            inStart += offset;
            System.arraycopy(replacementChars, 0, result, outStart += offset, replacementLength);
            inStart += replacedLength;
            outStart += replacementLength;
            ++i;
        }
        System.arraycopy(array, inStart, result, outStart, max - inStart);
        return result;
    }

    public static final char[][] subarray(char[][] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[][] result = new char[end - start][];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char toBeFound, char[] buffer, int start, int len) {
        if (start < 0 || start > buffer.length || start + len > buffer.length) {
            return -1;
        }
        int i = start;
        while (i < len) {
            if (toBeFound == buffer[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char[] toBeFound, char[] array) {
        if (toBeFound.length > array.length) {
            return -1;
        }
        int j = 0;
        int i = 0;
        while (i < array.length) {
            if (toBeFound[j] == array[i]) {
                if (++j == toBeFound.length) {
                    return i - j;
                }
            } else {
                j = 0;
            }
            ++i;
        }
        return -1;
    }

    public static final int lastIndexOf(char[] toBeFound, char[] array) {
        int j = toBeFound.length - 1;
        int i = array.length;
        while (--i >= 0) {
            if (toBeFound[j] == array[i]) {
                if (--j != -1) continue;
                return i;
            }
            j = toBeFound.length - 1;
        }
        return -1;
    }

    public static final char[] trim(char[] chars) {
        if (chars == null) {
            return null;
        }
        int start = 0;
        int length = chars.length;
        int end = length - 1;
        while (start < length && chars[start] == ' ') {
            ++start;
        }
        while (end > start && chars[end] == ' ') {
            --end;
        }
        if (start != 0 || end != length - 1) {
            return CharArrayUtils.subarray(chars, start, end + 1);
        }
        return chars;
    }

    public static final char[] lastSegment(char[] array, char[] separator) {
        int pos = CharArrayUtils.lastIndexOf(separator, array);
        if (pos < 0) {
            return array;
        }
        return CharArrayUtils.subarray(array, pos + separator.length, array.length);
    }

    public static void overWrite(char[] buff, int i, char[] charImage) {
        if (buff.length < i + charImage.length) {
            return;
        }
        int j = 0;
        while (j < charImage.length) {
            buff[i + j] = charImage[j];
            ++j;
        }
    }
}

