/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.c.CFunctionContextType;
import org.eclipse.cdt.internal.corext.template.c.CGlobalContextType;
import org.eclipse.cdt.internal.corext.template.c.CStructureContextType;
import org.eclipse.cdt.internal.corext.template.c.CppFunctionContextType;
import org.eclipse.cdt.internal.corext.template.c.CppGlobalContextType;
import org.eclipse.cdt.internal.corext.template.c.CppStructureContextType;

public class ContextTypeRegistry {
    private static ContextTypeRegistry fInstance;
    private final Map fContextTypes = new HashMap();

    public static ContextTypeRegistry getInstance() {
        if (fInstance == null) {
            fInstance = new ContextTypeRegistry();
        }
        return fInstance;
    }

    public void add(ContextType contextType) {
        this.fContextTypes.put(contextType.getName(), contextType);
    }

    public void remove(ContextType contextType) {
        this.fContextTypes.remove(contextType.getName());
    }

    public ContextType getContextType(String name) {
        return (ContextType)this.fContextTypes.get(name);
    }

    public Iterator iterator() {
        return this.fContextTypes.keySet().iterator();
    }

    private ContextTypeRegistry() {
        this.add(new CGlobalContextType());
        this.add(new CStructureContextType());
        this.add(new CFunctionContextType());
        this.add(new CppGlobalContextType());
        this.add(new CppStructureContextType());
        this.add(new CppFunctionContextType());
    }
}

