/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTDesignator;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceAlias;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.core.parser.extension.IASTFactoryExtension;
import org.eclipse.cdt.internal.core.parser.ast.ASTAbstractDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.ASTDesignator;
import org.eclipse.cdt.internal.core.parser.ast.BaseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTASMDefinition;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTCodeScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTCompilationUnit;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTConstructorMemberInitializer;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEnumerationSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEnumerator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExceptionSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTField;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFunction;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTInitializerClause;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTLinkageSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTMethod;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNamespaceAlias;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNewDescriptor;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTProblemFactory;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSimpleTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateInstantiation;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateParameter;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateSpecialization;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypedef;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUsingDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUsingDirective;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTVariable;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionFactory;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionResult;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionResultList;
import org.eclipse.cdt.internal.core.parser.ast.complete.ReferenceCache;
import org.eclipse.cdt.internal.core.parser.ast.complete.UnresolvedReferenceDuple;
import org.eclipse.cdt.internal.core.parser.problem.IProblemFactory;
import org.eclipse.cdt.internal.core.parser.pst.ExtensibleSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.ForewardDeclaredSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.NamespaceSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class CompleteParseASTFactory
extends BaseASTFactory
implements IASTFactory {
    protected static final char[] THIS = new char[]{'t', 'h', 'i', 's'};
    private static final ITypeInfo.OperatorExpression SUBSCRIPT;
    private static final IProblemFactory problemFactory;
    private final ParserMode mode;
    private final ReferenceCache cache = new ReferenceCache();
    private static final int BUILTIN_TYPE_SIZE = 64;
    private final Hashtable typeIdCache = new Hashtable(64);
    private final Hashtable simpleTypeSpecCache = new Hashtable(64);
    private static final int DEFAULT_QUALIFIEDNAME_REFERENCE_SIZE = 4;
    private char[] filename;
    protected ParserSymbolTable pst;

    static {
        problemFactory = new ASTProblemFactory();
        SUBSCRIPT = ITypeInfo.OperatorExpression.subscript;
    }

    public CompleteParseASTFactory(ParserLanguage language, ParserMode mode, IASTFactoryExtension extension) {
        super(extension);
        this.pst = new ParserSymbolTable(language, mode);
        this.mode = mode;
        this.filename = BaseASTFactory.EMPTY_STRING;
    }

    protected void addReference(List references, IASTReference reference) {
        if (reference == null) {
            return;
        }
        if (references == null) {
            this.cache.returnReference(reference);
            return;
        }
        int size = references.size();
        int i = 0;
        while (i < size) {
            IASTReference ref = (IASTReference)references.get(i);
            if (ref != null && CharArrayUtils.equals(ref.getNameCharArray(), reference.getNameCharArray()) && ref.getOffset() == reference.getOffset()) {
                this.cache.returnReference(ref);
                references.remove(i--);
                --size;
                break;
            }
            ++i;
        }
        references.add(reference);
    }

    protected void addTemplateIdReferences(List references, List templateArgs) {
        if (templateArgs == null) {
            return;
        }
        int numArgs = templateArgs.size();
        int i = 0;
        while (i < numArgs) {
            ASTExpression exp = (ASTExpression)templateArgs.get(i);
            List refs = null;
            refs = exp.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPEID_TYPEID ? ((ASTTypeId)exp.getTypeId()).getReferences() : exp.getReferences();
            int numRefs = refs.size();
            int j = 0;
            while (j < numRefs) {
                IASTReference r = (IASTReference)refs.get(j);
                this.addReference(references, this.cache.getReference(r.getOffset(), r.getReferencedElement()));
                ++j;
            }
            ++i;
        }
    }

    protected boolean validParameterList(List parameters) {
        int size = parameters.size();
        int i = 0;
        while (i < size) {
            ITypeInfo info = (ITypeInfo)parameters.get(i);
            if (info != null) {
                if (info.getType() == ITypeInfo.t_type && info.getTypeSymbol() == null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ISymbol lookupElement(IContainerSymbol startingScope, char[] name, ITypeInfo.eType type, List parameters, LookupType lookupType) throws ASTSemanticException {
        return this.lookupElement(startingScope, name, type, parameters, null, lookupType);
    }

    private ISymbol lookupElement(IContainerSymbol startingScope, char[] name, ITypeInfo.eType type, List parameters, List arguments, LookupType lookupType) throws ASTSemanticException {
        ISymbol result = null;
        if (startingScope == null) {
            return null;
        }
        try {
            if (type == ITypeInfo.t_function || type == ITypeInfo.t_constructor) {
                if (this.validParameterList(parameters)) {
                    if (type == ITypeInfo.t_constructor) {
                        IDerivableContainerSymbol startingDerivableScope = (IDerivableContainerSymbol)startingScope;
                        result = startingDerivableScope.lookupConstructor(parameters);
                    } else if (arguments != null) {
                        result = startingScope.lookupFunctionTemplateId(name, parameters, arguments, lookupType == LookupType.FORDEFINITION);
                    } else if (lookupType == LookupType.QUALIFIED) {
                        result = startingScope.qualifiedFunctionLookup(name, parameters);
                    } else if (lookupType == LookupType.UNQUALIFIED || lookupType == LookupType.FORPARENTSCOPE) {
                        result = startingScope.unqualifiedFunctionLookup(name, parameters);
                    } else if (lookupType == LookupType.FORDEFINITION) {
                        result = startingScope.lookupMethodForDefinition(name, parameters);
                    } else if (lookupType == LookupType.FORFRIENDSHIP) {
                        result = ((IDerivableContainerSymbol)startingScope).lookupFunctionForFriendship(name, parameters);
                    }
                } else {
                    result = null;
                }
            } else if (arguments != null) {
                result = startingScope.lookupTemplateId(name, arguments);
            } else if (lookupType == LookupType.QUALIFIED) {
                result = startingScope.qualifiedLookup(name, type);
            } else if (lookupType == LookupType.UNQUALIFIED || lookupType == LookupType.FORPARENTSCOPE) {
                result = startingScope.elaboratedLookup(type, name);
            } else if (lookupType == LookupType.FORDEFINITION) {
                result = startingScope.lookupMemberForDefinition(name);
            } else if (lookupType == LookupType.FORFRIENDSHIP) {
                result = ((IDerivableContainerSymbol)startingScope).lookupForFriendship(name);
            }
        }
        catch (ParserSymbolTableException e) {
            if (e.reason != 7) {
                this.handleProblem(e.createProblemID(), name);
            }
        }
        catch (ParserSymbolTableError parserSymbolTableError) {
            this.handleProblem(0x10000000, name);
        }
        return result;
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, char[] name, List references, boolean throwOnError, LookupType lookup) throws ASTSemanticException {
        return this.lookupQualifiedName(startingScope, name, ITypeInfo.t_any, null, 0, references, throwOnError, lookup);
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, char[] name, ITypeInfo.eType type, List parameters, int offset, List references, boolean throwOnError, LookupType lookup) throws ASTSemanticException {
        ISymbol result = null;
        if (name == null && throwOnError) {
            this.handleProblem(0x8000003, null);
        } else if (name == null) {
            return null;
        }
        try {
            result = this.lookupElement(startingScope, name, type, parameters, lookup);
            if (result != null) {
                this.addReference(references, this.createReference(result, name, offset));
            } else if (throwOnError) {
                this.handleProblem(0x8000002, name);
            }
        }
        catch (ASTSemanticException e) {
            if (throwOnError) {
                throw new ASTSemanticException(e);
            }
            return null;
        }
        return result;
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, ITokenDuple name, List references, boolean throwOnError) throws ASTSemanticException {
        return this.lookupQualifiedName(startingScope, name, references, throwOnError, LookupType.UNQUALIFIED);
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, ITokenDuple name, List references, boolean throwOnError, LookupType lookup) throws ASTSemanticException {
        return this.lookupQualifiedName(startingScope, name, ITypeInfo.t_any, null, references, throwOnError, lookup);
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, ITokenDuple name, ITypeInfo.eType type, List parameters, List references, boolean throwOnError) throws ASTSemanticException {
        return this.lookupQualifiedName(startingScope, name, type, parameters, references, throwOnError, LookupType.UNQUALIFIED);
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, ITokenDuple name, ITypeInfo.eType type, List parameters, List references, boolean throwOnError, LookupType lookup) throws ASTSemanticException {
        ISymbol result = null;
        if (name == null && throwOnError) {
            this.handleProblem(0x8000003, null);
        } else if (name == null) {
            return null;
        }
        List[] templateArgLists = name.getTemplateIdArgLists();
        List args = null;
        int idx = 0;
        char[] image = null;
        block1 : switch (name.getSegmentCount()) {
            case 0: {
                if (throwOnError) {
                    this.handleProblem(0x8000003, null);
                } else {
                    return null;
                }
            }
            case 1: {
                image = name.extractNameFromTemplateId();
                args = templateArgLists != null ? this.getTemplateArgList(templateArgLists[0]) : null;
                result = this.lookupElement(startingScope, image, type, parameters, args, lookup);
                if (result != null) {
                    if (lookup == LookupType.FORPARENTSCOPE && startingScope instanceof ITemplateFactory) {
                        if (args != null) {
                            ((ITemplateFactory)startingScope).pushTemplateId(result, args);
                        } else {
                            ((ITemplateFactory)startingScope).pushSymbol(result);
                        }
                    }
                    if (references != null) {
                        this.addReference(references, this.createReference(result, image, name.getStartOffset()));
                    }
                    if (args == null || references == null) break;
                    this.addTemplateIdReferences(references, templateArgLists[0]);
                    name.freeReferences(this.cache);
                    break;
                }
                if (startingScope.getASTExtension().getPrimaryDeclaration() instanceof IASTCodeScope && ((IASTCodeScope)((Object)startingScope.getASTExtension().getPrimaryDeclaration())).getContainingFunction() instanceof IASTMethod) {
                    IASTClassSpecifier classSpecifier = ((IASTMethod)((IASTCodeScope)((Object)startingScope.getASTExtension().getPrimaryDeclaration())).getContainingFunction()).getOwnerClassSpecifier();
                    if (classSpecifier == null) break;
                    ((ASTClassSpecifier)classSpecifier).addUnresolvedReference(new UnresolvedReferenceDuple(startingScope, name));
                    break;
                }
                if (throwOnError) {
                    this.handleProblem(0x8000002, image, name.getStartOffset(), name.getEndOffset(), name.getLineNumber(), true);
                }
                return null;
            }
            default: {
                IToken t = null;
                IToken last = name.getLastToken();
                result = startingScope;
                if (name.getFirstToken().getType() == 3) {
                    result = this.pst.getCompilationUnit();
                }
                while (t != last) {
                    IToken iToken = t = t != null ? t.getNext() : name.getFirstToken();
                    if (t.getType() == 3) {
                        ++idx;
                        continue;
                    }
                    if (t.getType() == 111) continue;
                    if (t.isPointer()) break block1;
                    image = t.getCharImage();
                    int offset = t.getOffset();
                    if (templateArgLists != null && templateArgLists[idx] != null && t != last && t.getNext().getType() == 42) {
                        t = TokenFactory.consumeTemplateIdArguments(t.getNext(), last);
                    }
                    try {
                        if (result instanceof IDeferredTemplateInstance) {
                            result = ((IDeferredTemplateInstance)result).getTemplate().getTemplatedSymbol();
                        }
                        List list = args = templateArgLists != null ? this.getTemplateArgList(templateArgLists[idx]) : null;
                        result = t == last ? this.lookupElement((IContainerSymbol)result, image, type, parameters, args, lookup == LookupType.FORDEFINITION ? lookup : LookupType.QUALIFIED) : (templateArgLists != null && templateArgLists[idx] != null ? ((IContainerSymbol)result).lookupTemplateId(image, args) : result.lookupNestedNameSpecifier(image));
                        if (result == null) break block1;
                        if (lookup == LookupType.FORPARENTSCOPE && startingScope instanceof ITemplateFactory) {
                            if (templateArgLists != null && templateArgLists[idx] != null) {
                                ((ITemplateFactory)startingScope).pushTemplateId(result, args);
                            } else {
                                ((ITemplateFactory)startingScope).pushSymbol(result);
                            }
                        }
                        if (references != null) {
                            this.addReference(references, this.createReference(result, image, offset));
                        }
                        if (references == null || templateArgLists == null || templateArgLists[idx] == null) continue;
                        this.addTemplateIdReferences(references, templateArgLists[idx]);
                        name.freeReferences(this.cache);
                    }
                    catch (ParserSymbolTableException pste) {
                        if (throwOnError) {
                            this.handleProblem(pste.createProblemID(), image);
                        }
                        return null;
                    }
                    catch (ParserSymbolTableError parserSymbolTableError) {
                        if (throwOnError) {
                            this.handleProblem(0x10000000, image);
                        }
                        return null;
                    }
                }
                break block1;
            }
        }
        return result;
    }

    public IASTUsingDirective createUsingDirective(IASTScope scope, ITokenDuple duple, int startingOffset, int startingLine, int endingOffset, int endingLine) throws ASTSemanticException {
        this.setFilename(duple);
        ArrayList references = new ArrayList();
        ISymbol symbol = this.lookupQualifiedName(this.scopeToSymbol(scope), duple, references, true);
        IUsingDirectiveSymbol usingDirective = null;
        if (symbol != null) {
            try {
                usingDirective = ((ASTScope)scope).getContainerSymbol().addUsingDirective((IContainerSymbol)symbol);
            }
            catch (ParserSymbolTableException pste) {
                this.handleProblem(pste.createProblemID(), duple.toCharArray(), startingOffset, endingOffset, startingLine, true);
            }
        }
        ASTUsingDirective using = new ASTUsingDirective(this.scopeToSymbol(scope), usingDirective, startingOffset, startingLine, endingOffset, endingLine, references, this.filename);
        this.attachSymbolExtension(usingDirective, using);
        return using;
    }

    private void setFilename(ITokenDuple duple) {
        this.filename = duple == null ? BaseASTFactory.EMPTY_STRING : duple.getFilename();
    }

    protected IContainerSymbol getScopeToSearchUpon(IASTScope currentScope, IToken firstToken) {
        if (firstToken.getType() == 3) {
            return this.pst.getCompilationUnit();
        }
        return this.scopeToSymbol(currentScope);
    }

    protected IContainerSymbol scopeToSymbol(IASTScope currentScope) {
        if (currentScope instanceof ASTScope) {
            return ((ASTScope)currentScope).getContainerSymbol();
        }
        if (currentScope instanceof ASTTemplateDeclaration) {
            return ((ASTTemplateDeclaration)currentScope).getContainerSymbol();
        }
        if (currentScope instanceof ASTTemplateInstantiation) {
            return ((ASTTemplateInstantiation)currentScope).getContainerSymbol();
        }
        return this.scopeToSymbol(((ASTAnonymousDeclaration)((Object)currentScope)).getOwnerScope());
    }

    public IASTUsingDeclaration createUsingDeclaration(IASTScope scope, boolean isTypeName, ITokenDuple name, int startingOffset, int startingLine, int endingOffset, int endingLine) throws ASTSemanticException {
        this.setFilename(name);
        ArrayList references = new ArrayList();
        IUsingDeclarationSymbol endResult = null;
        if (name.getSegmentCount() > 1) {
            ITokenDuple duple = name.getLeadingSegments();
            IContainerSymbol containerSymbol = null;
            if (duple == null) {
                containerSymbol = this.scopeToSymbol(scope).getSymbolTable().getCompilationUnit();
            } else {
                ISymbol symbol = this.lookupQualifiedName(this.scopeToSymbol(scope), duple, references, true);
                if (symbol instanceof IContainerSymbol) {
                    containerSymbol = (IContainerSymbol)symbol;
                } else if (symbol instanceof IDeferredTemplateInstance) {
                    containerSymbol = ((IDeferredTemplateInstance)symbol).getTemplate().getTemplatedSymbol();
                }
            }
            try {
                endResult = this.scopeToSymbol(scope).addUsingDeclaration(name.getLastToken().getCharImage(), containerSymbol);
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), name.getLastToken().getCharImage(), startingOffset, endingOffset, startingLine, true);
            }
        } else {
            try {
                endResult = this.scopeToSymbol(scope).addUsingDeclaration(name.getLastToken().getCharImage());
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), name.getLastToken().getCharImage(), startingOffset, endingOffset, startingLine, true);
            }
        }
        if (endResult != null) {
            List refs = endResult.getReferencedSymbols();
            int numRefs = refs.size();
            int i = 0;
            while (i < numRefs) {
                this.addReference(references, this.createReference((ISymbol)refs.get(i), name.getLastToken().getCharImage(), name.getLastToken().getOffset()));
                ++i;
            }
        }
        ASTUsingDeclaration using = new ASTUsingDeclaration(scope, name.getLastToken().getCharImage(), endResult.getReferencedSymbols(), isTypeName, startingOffset, startingLine, endingOffset, endingLine, references, this.filename);
        this.attachSymbolExtension(endResult, using);
        return using;
    }

    public IASTASMDefinition createASMDefinition(IASTScope scope, char[] assembly, int startingOffset, int startingLine, int endingOffset, int endingLine, char[] fn) {
        return new ASTASMDefinition(this.scopeToSymbol(scope), assembly, startingOffset, startingLine, endingOffset, endingLine, fn);
    }

    public IASTNamespaceDefinition createNamespaceDefinition(IASTScope scope, char[] identifier, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLineNumber, char[] fn) throws ASTSemanticException {
        IContainerSymbol pstScope = this.scopeToSymbol(scope);
        ISymbol namespaceSymbol = null;
        if (!identifier.equals(BaseASTFactory.EMPTY_STRING)) {
            try {
                namespaceSymbol = pstScope.qualifiedLookup(identifier);
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), identifier, nameOffset, nameEndOffset, nameLineNumber, true);
            }
        }
        if (namespaceSymbol != null) {
            if (namespaceSymbol.getType() != ITypeInfo.t_namespace) {
                this.handleProblem(0x8000004, identifier, nameOffset, nameEndOffset, nameLineNumber, true);
            }
        } else {
            namespaceSymbol = this.pst.newContainerSymbol(identifier, ITypeInfo.t_namespace);
            if (identifier.equals(BaseASTFactory.EMPTY_STRING)) {
                namespaceSymbol.setContainingSymbol(pstScope);
            } else {
                try {
                    pstScope.addSymbol(namespaceSymbol);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {}
            }
        }
        ASTNamespaceDefinition namespaceDef = new ASTNamespaceDefinition(namespaceSymbol, startingOffset, startingLine, nameOffset, nameEndOffset, nameLineNumber, fn);
        this.attachSymbolExtension(namespaceSymbol, namespaceDef, true);
        return namespaceDef;
    }

    public IASTCompilationUnit createCompilationUnit() {
        IContainerSymbol symbol = this.pst.getCompilationUnit();
        ASTCompilationUnit compilationUnit = new ASTCompilationUnit(symbol);
        this.attachSymbolExtension(symbol, compilationUnit, true);
        return compilationUnit;
    }

    protected void attachSymbolExtension(IExtensibleSymbol symbol, ASTNode astNode) {
        ExtensibleSymbolExtension symbolExtension = new ExtensibleSymbolExtension(symbol, astNode);
        symbol.setASTExtension(symbolExtension);
    }

    protected void attachSymbolExtension(ISymbol symbol, ASTSymbol astSymbol, boolean asDefinition) {
        ISymbolASTExtension symbolExtension = symbol.getASTExtension();
        if (symbolExtension == null) {
            symbolExtension = astSymbol instanceof IASTNamespaceDefinition ? new NamespaceSymbolExtension(symbol, astSymbol) : (astSymbol instanceof IASTFunction || astSymbol instanceof IASTMethod || astSymbol instanceof IASTEnumerationSpecifier || astSymbol instanceof IASTClassSpecifier || astSymbol instanceof IASTElaboratedTypeSpecifier ? new ForewardDeclaredSymbolExtension(symbol, astSymbol) : (astSymbol instanceof IASTTemplateDeclaration ? new TemplateSymbolExtension(symbol, astSymbol) : new StandardSymbolExtension(symbol, astSymbol)));
            symbol.setASTExtension(symbolExtension);
        } else if (asDefinition) {
            try {
                symbolExtension.addDefinition(astSymbol);
            }
            catch (ISymbolASTExtension.ExtensionException extensionException) {}
        }
    }

    public IASTLinkageSpecification createLinkageSpecification(IASTScope scope, char[] spec, int startingOffset, int startingLine, char[] fn) {
        return new ASTLinkageSpecification(this.scopeToSymbol(scope), spec, startingOffset, startingLine, fn);
    }

    public IASTClassSpecifier createClassSpecifier(IASTScope scope, ITokenDuple name, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, ASTAccessVisibility access, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, char[] fn) throws ASTSemanticException {
        this.setFilename(fn);
        IContainerSymbol currentScopeSymbol = this.scopeToSymbol(scope);
        ITypeInfo.eType pstType = this.classKindToTypeInfo(kind);
        ArrayList references = new ArrayList();
        char[] newSymbolName = BaseASTFactory.EMPTY_STRING;
        List templateIdArgList = null;
        boolean isTemplateId = false;
        if (name != null) {
            IToken nameToken = null;
            if (name.getSegmentCount() != 1) {
                ITokenDuple containerSymbolName = name.getLeadingSegments();
                ISymbol temp = this.lookupQualifiedName(currentScopeSymbol, containerSymbolName, references, true);
                if ((currentScopeSymbol = temp instanceof IDeferredTemplateInstance ? ((IDeferredTemplateInstance)temp).getTemplate().getTemplatedSymbol() : (IContainerSymbol)temp) == null) {
                    this.handleProblem(0x8000002, containerSymbolName.toCharArray(), containerSymbolName.getFirstToken().getOffset(), containerSymbolName.getLastToken().getEndOffset(), containerSymbolName.getLastToken().getLineNumber(), true);
                }
                nameToken = name.getLastSegment().getFirstToken();
            } else {
                nameToken = name.getFirstToken();
            }
            List[] array = name.getTemplateIdArgLists();
            if (array != null) {
                templateIdArgList = array[array.length - 1];
                isTemplateId = templateIdArgList != null;
            }
            newSymbolName = nameToken.getCharImage();
        }
        ISymbol classSymbol = null;
        if (!CharArrayUtils.equals(newSymbolName, BaseASTFactory.EMPTY_STRING) && !isTemplateId) {
            try {
                classSymbol = currentScopeSymbol.lookupMemberForDefinition(newSymbolName);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                this.handleProblem(0x8000001, name.toCharArray(), nameOffset, nameEndOffset, nameLine, true);
            }
            if (classSymbol != null && !classSymbol.isForwardDeclaration()) {
                this.handleProblem(0x8000001, newSymbolName, nameOffset, nameEndOffset, nameLine, true);
            }
            if (classSymbol != null && classSymbol.getType() != pstType) {
                boolean isError = true;
                if (classSymbol.isType(ITypeInfo.t_class, ITypeInfo.t_union) && (pstType == ITypeInfo.t_class || pstType == ITypeInfo.t_struct || pstType == ITypeInfo.t_union)) {
                    isError = false;
                }
                this.handleProblem(0x8000004, newSymbolName, nameOffset, nameEndOffset, nameLine, isError);
            }
        }
        IDerivableContainerSymbol newSymbol = this.pst.newDerivableContainerSymbol(newSymbolName, pstType);
        if (classSymbol != null) {
            classSymbol.setForwardSymbol(newSymbol);
        }
        List args = null;
        if (isTemplateId) {
            args = this.getTemplateArgList(templateIdArgList);
        }
        try {
            if (!isTemplateId) {
                currentScopeSymbol.addSymbol(newSymbol);
            } else {
                currentScopeSymbol.addTemplateId(newSymbol, args);
            }
        }
        catch (ParserSymbolTableException e2) {
            this.handleProblem(e2.createProblemID(), newSymbolName);
        }
        if (name != null && name.getTemplateIdArgLists() != null) {
            int i = 0;
            while (i < name.getTemplateIdArgLists().length) {
                this.addTemplateIdReferences(references, name.getTemplateIdArgLists()[i]);
                ++i;
            }
            name.freeReferences(this.cache);
        }
        ASTClassSpecifier classSpecifier = new ASTClassSpecifier(newSymbol, kind, type, access, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, references, this.filename);
        this.attachSymbolExtension(newSymbol, classSpecifier, true);
        return classSpecifier;
    }

    private List getTemplateArgList(List args) {
        if (args == null) {
            return null;
        }
        int size = args.size();
        ArrayList<ITypeInfo> list = new ArrayList<ITypeInfo>(size);
        int i = 0;
        while (i < size) {
            ASTExpression exp = (ASTExpression)args.get(i);
            ITypeInfo info = exp.getResultType().getResult();
            list.add(info);
            ++i;
        }
        return list;
    }

    protected void handleProblem(int id, char[] attribute) throws ASTSemanticException {
        this.handleProblem(null, id, attribute, -1, -1, -1, true);
    }

    protected void handleProblem(IASTScope scope, int id, char[] attribute) throws ASTSemanticException {
        this.handleProblem(scope, id, attribute, -1, -1, -1, true);
    }

    protected void handleProblem(int id, char[] attribute, int startOffset, int endOffset, int lineNumber, boolean isError) throws ASTSemanticException {
        this.handleProblem(null, id, attribute, startOffset, endOffset, lineNumber, isError);
    }

    protected void handleProblem(IASTScope scope, int id, char[] attribute, int startOffset, int endOffset, int lineNumber, boolean isError) throws ASTSemanticException {
        IProblem p = problemFactory.createProblem(id, startOffset, endOffset, lineNumber, this.filename, attribute, !isError, isError);
        TraceUtil.outputTrace(this.logService, "CompleteParseASTFactory - IProblem : ", p);
        if (this.shouldThrowException(scope, id, !isError)) {
            throw new ASTSemanticException(p);
        }
    }

    protected boolean shouldThrowException(IASTScope scope, int id, boolean isWarning) {
        IContainerSymbol symbol;
        if (isWarning) {
            return false;
        }
        return scope == null || !(symbol = this.scopeToSymbol(scope)).isTemplateMember() || id != 0x800000F && id != 0x8000007;
    }

    protected ITypeInfo.eType classKindToTypeInfo(ASTClassKind kind) {
        ITypeInfo.eType pstType = null;
        if (kind == ASTClassKind.CLASS) {
            pstType = ITypeInfo.t_class;
        } else if (kind == ASTClassKind.STRUCT) {
            pstType = ITypeInfo.t_struct;
        } else if (kind == ASTClassKind.UNION) {
            pstType = ITypeInfo.t_union;
        } else if (kind == ASTClassKind.ENUM) {
            pstType = ITypeInfo.t_enumeration;
        }
        return pstType;
    }

    public void addBaseSpecifier(IASTClassSpecifier astClassSpec, boolean isVirtual, ASTAccessVisibility visibility, ITokenDuple parentClassName) throws ASTSemanticException {
        List[] templateArgumentLists;
        ISymbol symbol;
        this.setFilename(parentClassName);
        IDerivableContainerSymbol classSymbol = (IDerivableContainerSymbol)this.scopeToSymbol(astClassSpec);
        ArrayList references = new ArrayList();
        if (parentClassName == null || parentClassName.getFirstToken() == null) {
            this.handleProblem(0x8000003, null);
        }
        if ((symbol = this.lookupQualifiedName(classSymbol, parentClassName, references, true)) instanceof ITemplateSymbol) {
            this.handleProblem(0x800000C, parentClassName.toCharArray(), parentClassName.getStartOffset(), parentClassName.getEndOffset(), parentClassName.getLineNumber(), true);
        }
        if ((templateArgumentLists = parentClassName.getTemplateIdArgLists()) != null) {
            int i = 0;
            while (i < templateArgumentLists.length) {
                this.addTemplateIdReferences(references, templateArgumentLists[i]);
                ++i;
            }
        }
        parentClassName.freeReferences(this.cache);
        classSymbol.addParent(symbol, isVirtual, visibility, parentClassName.getFirstToken().getOffset(), references);
    }

    protected IASTReference createReference(ISymbol symbol, char[] referenceElementName, int offset) throws ASTSemanticException {
        ASTSymbol definition;
        if (this.mode != ParserMode.COMPLETE_PARSE) {
            return null;
        }
        if (symbol.getASTExtension() == null) {
            return null;
        }
        Iterator i = symbol.getASTExtension().getAllDefinitions();
        ASTSymbol declaration = i.hasNext() ? (ASTSymbol)i.next() : null;
        ASTSymbol aSTSymbol = definition = i.hasNext() ? (ASTSymbol)i.next() : null;
        if (symbol.getTypeInfo().checkBit(256) || symbol.getASTExtension().getPrimaryDeclaration() instanceof IASTTypedefDeclaration) {
            return this.cache.getReference(offset, declaration);
        }
        if (symbol.getType() == ITypeInfo.t_namespace) {
            return this.cache.getReference(offset, declaration);
        }
        if (symbol.getType() == ITypeInfo.t_class || symbol.getType() == ITypeInfo.t_struct || symbol.getType() == ITypeInfo.t_union) {
            return this.cache.getReference(offset, (ISourceElementCallbackDelegate)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == ITypeInfo.t_enumeration) {
            return this.cache.getReference(offset, (IASTEnumerationSpecifier)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == ITypeInfo.t_enumerator) {
            return this.cache.getReference(offset, declaration);
        }
        if (symbol.getType() == ITypeInfo.t_function || symbol.getType() == ITypeInfo.t_constructor) {
            ASTSymbol referenced;
            ASTSymbol aSTSymbol2 = referenced = definition != null ? definition : declaration;
            if (referenced instanceof IASTMethod) {
                return this.cache.getReference(offset, (IASTMethod)((Object)referenced));
            }
            return this.cache.getReference(offset, (IASTFunction)((Object)referenced));
        }
        if (symbol.getType() == ITypeInfo.t_type || symbol.getType() == ITypeInfo.t_bool || symbol.getType() == ITypeInfo.t_char || symbol.getType() == ITypeInfo.t_wchar_t || symbol.getType() == ITypeInfo.t_int || symbol.getType() == ITypeInfo.t_float || symbol.getType() == ITypeInfo.t_double || symbol.getType() == ITypeInfo.t_void || symbol.getType() == ITypeInfo.t__Bool || symbol.getType() == ITypeInfo.t_templateParameter) {
            ASTSymbol s;
            if (symbol.getContainingSymbol().getType() == ITypeInfo.t_class || symbol.getContainingSymbol().getType() == ITypeInfo.t_struct || symbol.getContainingSymbol().getType() == ITypeInfo.t_union) {
                return this.cache.getReference(offset, definition != null ? definition : declaration);
            }
            if ((symbol.getContainingSymbol().getType() == ITypeInfo.t_function || symbol.getContainingSymbol().getType() == ITypeInfo.t_constructor) && symbol.getContainingSymbol() instanceof IParameterizedSymbol && ((IParameterizedSymbol)symbol.getContainingSymbol()).getParameterList() != null && ((IParameterizedSymbol)symbol.getContainingSymbol()).getParameterList().contains(symbol)) {
                return this.cache.getReference(offset, declaration);
            }
            ASTSymbol aSTSymbol3 = s = definition != null ? definition : declaration;
            if (s instanceof IASTVariable) {
                return this.cache.getReference(offset, (IASTVariable)((Object)s));
            }
            if (s instanceof IASTParameterDeclaration) {
                return this.cache.getReference(offset, (IASTParameterDeclaration)((Object)s));
            }
            if (s instanceof IASTTemplateParameter) {
                return this.cache.getReference(offset, (IASTTemplateParameter)((Object)s));
            }
        }
        return null;
    }

    public IASTEnumerationSpecifier createEnumerationSpecifier(IASTScope scope, char[] name, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, char[] fn) throws ASTSemanticException {
        this.setFilename(fn);
        IContainerSymbol containerSymbol = this.scopeToSymbol(scope);
        ITypeInfo.eType pstType = ITypeInfo.t_enumeration;
        IDerivableContainerSymbol classSymbol = this.pst.newDerivableContainerSymbol(name, pstType);
        try {
            containerSymbol.addSymbol(classSymbol);
        }
        catch (ParserSymbolTableException e) {
            this.handleProblem(e.createProblemID(), name);
        }
        ASTEnumerationSpecifier enumSpecifier = new ASTEnumerationSpecifier(classSymbol, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, fn);
        this.attachSymbolExtension(classSymbol, enumSpecifier, true);
        return enumSpecifier;
    }

    private void setFilename(char[] fn) {
        this.filename = fn;
    }

    public IASTEnumerator addEnumerator(IASTEnumerationSpecifier enumeration, char[] name, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endingOffset, int endLine, IASTExpression initialValue, char[] fn) throws ASTSemanticException {
        ISymbol enumeratorSymbol;
        block2: {
            this.setFilename(fn);
            IContainerSymbol enumerationSymbol = (IContainerSymbol)((ISymbolOwner)((Object)enumeration)).getSymbol();
            enumeratorSymbol = this.pst.newSymbol(name, ITypeInfo.t_enumerator);
            try {
                enumerationSymbol.addSymbol(enumeratorSymbol);
            }
            catch (ParserSymbolTableException e1) {
                if (e1.reason != 3) break block2;
                this.handleProblem(0x8000004, name, startingOffset, endingOffset, startingLine, true);
            }
        }
        ASTEnumerator enumerator = new ASTEnumerator(enumeratorSymbol, enumeration, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, endingOffset, endLine, initialValue, fn);
        ((ASTEnumerationSpecifier)enumeration).addEnumerator(enumerator);
        this.attachSymbolExtension(enumeratorSymbol, enumerator, true);
        return enumerator;
    }

    public IASTExpression createExpression(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, ITokenDuple idExpression, char[] literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor) throws ASTSemanticException {
        this.setFilename(idExpression);
        if (idExpression != null && this.logService.isTracing()) {
            TraceUtil.outputTrace(this.logService, "Entering createExpression with Kind=", null, kind.getKindName(), " idexpression=", idExpression.toString());
        } else if (literal != null && literal.length > 0 && this.logService.isTracing()) {
            TraceUtil.outputTrace(this.logService, "Entering createExpression with Kind=", null, kind.getKindName(), " literal=", String.valueOf(literal));
        }
        ArrayList references = new ArrayList();
        ISymbol symbol = this.getExpressionSymbol(scope, kind, lhs, rhs, idExpression, references);
        ExpressionResult expressionResult = this.getExpressionResultType(scope, kind, lhs, rhs, thirdExpression, typeId, literal, symbol);
        if (newDescriptor != null) {
            this.createConstructorReference(newDescriptor, typeId, references);
        }
        if (symbol == null) {
            this.purgeBadReferences(kind, rhs);
        }
        ASTExpression expression = null;
        expression = this.extension.overrideCreateExpressionMethod() ? (ASTExpression)this.extension.createExpression(scope, kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor, references) : ExpressionFactory.createExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor, references);
        expression.setResultType(expressionResult);
        return expression;
    }

    private void createConstructorReference(IASTExpression.IASTNewExpressionDescriptor descriptor, IASTTypeId typeId, List references) {
        ITokenDuple duple;
        ISymbol symbol = null;
        try {
            symbol = typeId.getTypeSymbol();
            if (symbol.isType(ITypeInfo.t_type)) {
                symbol = symbol.getTypeSymbol();
            }
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {
            return;
        }
        if (symbol == null || !(symbol instanceof IDerivableContainerSymbol)) {
            return;
        }
        List initializers = ((ASTNewDescriptor)descriptor).getNewInitializerExpressionsList();
        ASTExpression exp = initializers.size() > 0 ? (ASTExpression)initializers.get(0) : null;
        if (this.createConstructorReference(symbol, exp, duple = ((ASTTypeId)typeId).getTokenDuple().getLastSegment(), references)) {
            List refs = ((ASTTypeId)typeId).getReferences();
            int size = refs.size();
            int i = 0;
            while (i < size) {
                ReferenceCache.ASTReference ref = (ReferenceCache.ASTReference)refs.get(i);
                if (CharArrayUtils.equals(ref.getNameCharArray(), duple.toCharArray()) && ref.getOffset() == duple.getStartOffset()) {
                    this.cache.returnReference(ref);
                    refs.remove(i--);
                    --size;
                }
                ++i;
            }
        }
    }

    private boolean createConstructorReference(ISymbol classSymbol, ASTExpression expressionList, ITokenDuple duple, List references) {
        if (classSymbol != null && classSymbol.getTypeInfo().checkBit(256)) {
            TypeInfoProvider provider = this.pst.getTypeInfoProvider();
            ITypeInfo info = classSymbol.getTypeInfo().getFinalType(provider);
            classSymbol = info.getTypeSymbol();
            provider.returnTypeInfo(info);
        }
        if (classSymbol == null || !(classSymbol instanceof IDerivableContainerSymbol)) {
            return false;
        }
        ArrayList<ITypeInfo> parameters = new ArrayList<ITypeInfo>();
        while (expressionList != null) {
            parameters.add(expressionList.getResultType().getResult());
            expressionList = (ASTExpression)expressionList.getRHSExpression();
        }
        IParameterizedSymbol constructor = null;
        try {
            constructor = ((IDerivableContainerSymbol)classSymbol).lookupConstructor(parameters);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            return false;
        }
        if (constructor != null) {
            IASTReference reference = null;
            try {
                reference = this.createReference(constructor, duple.toCharArray(), duple.getStartOffset());
            }
            catch (ASTSemanticException aSTSemanticException) {
                return false;
            }
            if (reference != null) {
                this.addReference(references, reference);
                return true;
            }
        }
        return false;
    }

    private void purgeBadReferences(IASTExpression.Kind kind, IASTExpression rhs) {
        ASTExpression astExpression;
        char[] idExpression;
        if (rhs == null) {
            return;
        }
        if ((kind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP || kind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS) && (idExpression = (astExpression = (ASTExpression)rhs).getIdExpressionCharArray()).length > 0) {
            List refs = astExpression.getReferences();
            int size = refs.size();
            int i = 0;
            while (i < size) {
                IASTReference r = (IASTReference)refs.get(i);
                if (CharArrayUtils.equals(r.getNameCharArray(), idExpression)) {
                    refs.remove(i--);
                    --size;
                    this.cache.returnReference(r);
                }
                ++i;
            }
        }
    }

    private ISymbol getExpressionSymbol(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, ITokenDuple idExpression, List references) throws ASTSemanticException {
        IContainerSymbol searchScope;
        ISymbol symbol = null;
        IContainerSymbol startingScope = this.scopeToSymbol(scope);
        if (idExpression != null) {
            symbol = this.lookupQualifiedName(startingScope, idExpression, references, false);
        }
        if ((searchScope = this.getSearchScope(kind, lhs, startingScope)) != null && !searchScope.equals(startingScope)) {
            symbol = this.lookupQualifiedName(searchScope, ((ASTIdExpression)rhs).getIdExpressionTokenDuple(), references, false, LookupType.QUALIFIED);
        }
        if (kind == IASTExpression.Kind.PRIMARY_THIS) {
            try {
                symbol = startingScope.lookup(THIS);
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), THIS);
            }
        }
        if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            ITokenDuple functionId = this.getFunctionId(lhs);
            IContainerSymbol functionScope = this.getSearchScope(lhs.getExpressionKind(), lhs.getLHSExpression(), startingScope);
            if (functionScope == null) {
                return null;
            }
            ExpressionResult expResult = ((ASTExpression)rhs).getResultType();
            List<ITypeInfo> parameters = null;
            if (expResult instanceof ExpressionResultList) {
                ExpressionResultList expResultList = (ExpressionResultList)expResult;
                parameters = expResultList.getResultList();
            } else {
                parameters = new ArrayList(1);
                parameters.add(expResult.getResult());
            }
            symbol = functionScope.equals(startingScope) ? this.lookupQualifiedName(functionScope, functionId, ITypeInfo.t_function, parameters, references, false) : this.lookupQualifiedName(functionScope, functionId, ITypeInfo.t_function, parameters, references, false, LookupType.QUALIFIED);
        }
        return symbol;
    }

    private ITokenDuple getFunctionId(IASTExpression expression) {
        if (expression.getExpressionKind().isPostfixMemberReference() && expression.getRHSExpression() instanceof ASTIdExpression) {
            return ((ASTIdExpression)expression.getRHSExpression()).getIdExpressionTokenDuple();
        }
        if (expression instanceof ASTIdExpression) {
            return ((ASTIdExpression)expression).getIdExpressionTokenDuple();
        }
        return null;
    }

    private IContainerSymbol getSearchScope(IASTExpression.Kind kind, IASTExpression lhs, IContainerSymbol startingScope) throws ASTSemanticException {
        if (kind.isPostfixMemberReference()) {
            ITypeInfo lhsInfo = ((ASTExpression)lhs).getResultType().getResult();
            if (lhsInfo != null) {
                TypeInfoProvider provider = this.pst.getTypeInfoProvider();
                ITypeInfo info = null;
                try {
                    info = lhsInfo.getFinalType(provider);
                }
                catch (ParserSymbolTableError parserSymbolTableError) {
                    return null;
                }
                ISymbol containingScope = info.getTypeSymbol();
                provider.returnTypeInfo(info);
                if (containingScope instanceof IDeferredTemplateInstance) {
                    return ((IDeferredTemplateInstance)containingScope).getTemplate().getTemplatedSymbol();
                }
                return containingScope instanceof IContainerSymbol ? (IContainerSymbol)containingScope : null;
            }
            return null;
        }
        return startingScope;
    }

    protected ITypeInfo conditionalExpressionConversions(ITypeInfo second, ITypeInfo third) {
        ITypeInfo info = null;
        if (second.equals(third)) {
            info = second;
            return info;
        }
        if (second.getType() == ITypeInfo.t_void && third.getType() != ITypeInfo.t_void) {
            info = third;
            return info;
        }
        if (second.getType() != ITypeInfo.t_void && third.getType() == ITypeInfo.t_void) {
            info = second;
            return info;
        }
        if (second.getType() == ITypeInfo.t_void && third.getType() == ITypeInfo.t_void) {
            info = second;
            return info;
        }
        try {
            info = this.pst.getConditionalOperand(second, third);
            return info;
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            return info;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ITypeInfo usualArithmeticConversions(IASTScope scope, ITypeInfo lhs, ITypeInfo rhs) throws ASTSemanticException {
        if (lhs == null) {
            return null;
        }
        if (rhs != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            lhs = lhs.getTypeSymbol().getTypeInfo();
lbl6:
            // 2 sources

            ** while (lhs.getType() == ITypeInfo.t_type && lhs.getTypeSymbol() != null)
        }
lbl7:
        // 2 sources

        while (rhs.getType() == ITypeInfo.t_type && rhs.getTypeSymbol() != null) {
            rhs = rhs.getTypeSymbol().getTypeInfo();
        }
        if (!lhs.isType(ITypeInfo.t__Bool, ITypeInfo.t_enumerator) && !rhs.isType(ITypeInfo.t__Bool, ITypeInfo.t_enumerator)) {
            this.handleProblem(scope, 0x800000F, null);
        }
        info = TypeInfoProvider.newTypeInfo();
        if (lhs.checkBit(16384) && lhs.getType() == ITypeInfo.t_double || rhs.checkBit(16384) && rhs.getType() == ITypeInfo.t_double) {
            info.setType(ITypeInfo.t_double);
            info.setBit(true, 16384);
            return info;
        }
        if (lhs.getType() == ITypeInfo.t_double || rhs.getType() == ITypeInfo.t_double) {
            info.setType(ITypeInfo.t_double);
            return info;
        }
        if (lhs.getType() == ITypeInfo.t_float || rhs.getType() == ITypeInfo.t_float) {
            info.setType(ITypeInfo.t_float);
            return info;
        }
        info.setType(ITypeInfo.t_int);
        if (lhs.checkBit(4096) && lhs.checkBit(16384) || rhs.checkBit(4096) && rhs.checkBit(16384)) {
            info.setBit(true, 4096);
            info.setBit(true, 16384);
            return info;
        }
        if (lhs.checkBit(4096) && rhs.checkBit(16384) || rhs.checkBit(4096) && lhs.checkBit(16384)) {
            info.setBit(true, 4096);
            info.setBit(true, 16384);
            return info;
        }
        if (lhs.checkBit(16384) || rhs.checkBit(16384)) {
            info.setBit(true, 16384);
            return info;
        }
        if (lhs.checkBit(4096) || rhs.checkBit(4096)) {
            info.setBit(true, 4096);
            return info;
        }
        return info;
    }

    private ITypeInfo modifyTypeInfo(ASTExpression exp, IASTExpression.Kind kind) {
        ITypeInfo info = exp.getResultType().getResult();
        if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT) {
            info.setBit(true, 8192);
        }
        if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG) {
            info.setBit(true, 16384);
        }
        if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED) {
            info.setBit(true, 4096);
        }
        if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED) {
            info.setBit(true, 4096);
        }
        return info;
    }

    private void constructBasicType(TypeInfoProvider provider, IASTExpression.Kind kind) {
        if (kind == IASTExpression.Kind.PRIMARY_EMPTY || kind == IASTExpression.Kind.THROWEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR || kind == IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR || kind == IASTExpression.Kind.DELETE_CASTEXPRESSION || kind == IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION) {
            provider.setType(ITypeInfo.t_void);
            return;
        }
        if (kind == IASTExpression.Kind.PRIMARY_INTEGER_LITERAL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT) {
            provider.setType(ITypeInfo.t_int);
            return;
        }
        if (kind == IASTExpression.Kind.UNARY_SIZEOF_TYPEID || kind == IASTExpression.Kind.UNARY_SIZEOF_UNARYEXPRESSION) {
            provider.setType(ITypeInfo.t_int);
            provider.setTypeBits(4096);
            return;
        }
        if (kind == IASTExpression.Kind.PRIMARY_CHAR_LITERAL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR || kind == IASTExpression.Kind.PRIMARY_STRING_LITERAL) {
            provider.setType(ITypeInfo.t_char);
            return;
        }
        if (kind == IASTExpression.Kind.PRIMARY_FLOAT_LITERAL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT) {
            provider.setType(ITypeInfo.t_float);
            return;
        }
        if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE) {
            provider.setType(ITypeInfo.t_double);
            return;
        }
        if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART) {
            provider.setType(ITypeInfo.t_wchar_t);
            return;
        }
        if (kind == IASTExpression.Kind.PRIMARY_BOOLEAN_LITERAL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL || kind == IASTExpression.Kind.RELATIONAL_GREATERTHAN || kind == IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO || kind == IASTExpression.Kind.RELATIONAL_LESSTHAN || kind == IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO || kind == IASTExpression.Kind.EQUALITY_EQUALS || kind == IASTExpression.Kind.EQUALITY_NOTEQUALS || kind == IASTExpression.Kind.LOGICALANDEXPRESSION || kind == IASTExpression.Kind.LOGICALOREXPRESSION) {
            provider.setType(ITypeInfo.t_bool);
            return;
        }
    }

    protected ExpressionResult getExpressionResultType(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, char[] literal, ISymbol symbol) throws ASTSemanticException {
        ITypeInfo info = null;
        ExpressionResult result = null;
        if (this.extension.canHandleExpressionKind(kind)) {
            info = this.extension.getExpressionResultType(kind, lhs, rhs, typeId);
            return new ExpressionResult(info);
        }
        if (kind.isBasicType()) {
            TypeInfoProvider provider = this.pst.getTypeInfoProvider();
            provider.beginTypeConstruction();
            if (literal != null && !literal.equals(BaseASTFactory.EMPTY_STRING) && kind.isLiteral()) {
                provider.setDefaultObj(literal);
            }
            this.constructBasicType(provider, kind);
            info = provider.completeConstruction();
            if (kind == IASTExpression.Kind.PRIMARY_STRING_LITERAL || literal.length > 3 && (kind == IASTExpression.Kind.PRIMARY_CHAR_LITERAL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR)) {
                info.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
            }
            return new ExpressionResult(info);
        }
        if (kind.isPostfixSimpleType()) {
            info = this.modifyTypeInfo((ASTExpression)lhs, kind);
            return new ExpressionResult(info);
        }
        if (kind == IASTExpression.Kind.ID_EXPRESSION) {
            info = TypeInfoProvider.newTypeInfo(ITypeInfo.t_type);
            info.setTypeSymbol(symbol);
            result = new ExpressionResult(info);
            if (symbol == null) {
                result.setFailedToDereference(true);
            }
            return result;
        }
        if (kind == IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION) {
            ASTExpression left = (ASTExpression)lhs;
            if (left == null) {
                this.handleProblem(scope, 0x8000010, null);
            }
            if ((info = left.getResultType().getResult()) != null) {
                info = info.getFinalType(null);
                info.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION) {
            ASTExpression left = (ASTExpression)lhs;
            if (left == null) {
                this.handleProblem(scope, 0x8000010, null);
            }
            if ((info = left.getResultType().getResult()) != null) {
                info = info.getFinalType(null);
                info.applyOperatorExpression(ITypeInfo.OperatorExpression.indirection);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.POSTFIX_SUBSCRIPT) {
            ASTExpression left = (ASTExpression)lhs;
            if (left == null) {
                this.handleProblem(scope, 0x8000010, null);
            }
            if ((info = left.getResultType().getResult()) != null) {
                info = info.getFinalType(null);
                info.applyOperatorExpression(ITypeInfo.OperatorExpression.subscript);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP) {
            if (symbol != null) {
                info = TypeInfoProvider.newTypeInfo(symbol.getTypeInfo());
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.PM_DOTSTAR || kind == IASTExpression.Kind.PM_ARROWSTAR) {
            ASTExpression right = (ASTExpression)rhs;
            if (right == null) {
                this.handleProblem(scope, 0x8000010, null);
            }
            if ((info = right.getResultType().getResult()) != null && symbol != null) {
                info.setTypeSymbol(symbol);
                info = info.getFinalType(null);
                info.applyOperatorExpression(ITypeInfo.OperatorExpression.indirection);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.PRIMARY_THIS) {
            if (symbol != null) {
                info = TypeInfoProvider.newTypeInfo(ITypeInfo.t_type);
                info.setTypeSymbol(symbol);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.CONDITIONALEXPRESSION) {
            ASTExpression right = (ASTExpression)rhs;
            ASTExpression third = (ASTExpression)thirdExpression;
            if (right != null && third != null) {
                ITypeInfo rightType = right.getResultType().getResult();
                ITypeInfo thirdType = third.getResultType().getResult();
                if (rightType != null && thirdType != null) {
                    info = this.conditionalExpressionConversions(rightType, thirdType);
                } else {
                    this.handleProblem(scope, 0x8000010, null);
                }
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.NEW_TYPEID || kind == IASTExpression.Kind.NEW_NEWTYPEID) {
            try {
                info = typeId.getTypeSymbol().getTypeInfo();
                info.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY || kind == IASTExpression.Kind.MULTIPLICATIVE_DIVIDE || kind == IASTExpression.Kind.MULTIPLICATIVE_MODULUS || kind == IASTExpression.Kind.ADDITIVE_PLUS || kind == IASTExpression.Kind.ADDITIVE_MINUS || kind == IASTExpression.Kind.ANDEXPRESSION || kind == IASTExpression.Kind.EXCLUSIVEOREXPRESSION || kind == IASTExpression.Kind.INCLUSIVEOREXPRESSION) {
            ASTExpression left = (ASTExpression)lhs;
            ASTExpression right = (ASTExpression)rhs;
            if (left != null && right != null) {
                ITypeInfo leftType = left.getResultType().getResult();
                ITypeInfo rightType = right.getResultType().getResult();
                info = this.usualArithmeticConversions(scope, leftType, rightType);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION || kind == IASTExpression.Kind.POSTFIX_INCREMENT || kind == IASTExpression.Kind.POSTFIX_DECREMENT || kind == IASTExpression.Kind.POSTFIX_TYPEID_EXPRESSION || kind == IASTExpression.Kind.UNARY_INCREMENT || kind == IASTExpression.Kind.UNARY_DECREMENT || kind == IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION || kind == IASTExpression.Kind.SHIFT_LEFT || kind == IASTExpression.Kind.SHIFT_RIGHT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR) {
            ASTExpression left = (ASTExpression)lhs;
            if (left != null) {
                info = left.getResultType().getResult();
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.CASTEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DYNAMIC_CAST || kind == IASTExpression.Kind.POSTFIX_STATIC_CAST || kind == IASTExpression.Kind.POSTFIX_REINTERPRET_CAST || kind == IASTExpression.Kind.POSTFIX_CONST_CAST) {
            try {
                info = TypeInfoProvider.newTypeInfo(typeId.getTypeSymbol().getTypeInfo());
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.EXPRESSIONLIST) {
            result = new ExpressionResultList();
            if (lhs != null) {
                ExpressionResult resultType = ((ASTExpression)lhs).getResultType();
                if (resultType instanceof ExpressionResultList) {
                    ((ExpressionResultList)result).setResult((ExpressionResultList)resultType);
                } else {
                    result.setResult(resultType.getResult());
                }
            }
            if (rhs != null) {
                ITypeInfo rightType = ((ASTExpression)rhs).getResultType().getResult();
                result.setResult(rightType);
            }
            return result;
        }
        if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            if (symbol != null) {
                IParameterizedSymbol psymbol = (IParameterizedSymbol)symbol;
                ISymbol returnTypeSymbol = psymbol.getReturnType();
                if (returnTypeSymbol != null) {
                    info = TypeInfoProvider.newTypeInfo(returnTypeSymbol.getTypeInfo());
                }
            } else {
                info = TypeInfoProvider.newTypeInfo();
            }
            result = new ExpressionResult(info);
            if (symbol == null) {
                result.setFailedToDereference(true);
            }
            return result;
        }
        if (kind == IASTExpression.Kind.POSTFIX_TYPEID_TYPEID) {
            try {
                info = typeId.getTypeSymbol().getTypeInfo();
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            result = new ExpressionResult(info);
            return result;
        }
        if (kind == IASTExpression.Kind.POSTFIX_TYPENAME_IDENTIFIER || kind == IASTExpression.Kind.POSTFIX_TYPENAME_TEMPLATEID) {
            if (symbol != null) {
                info = TypeInfoProvider.newTypeInfo(ITypeInfo.t_type);
                info.setTypeSymbol(symbol);
            } else {
                this.handleProblem(scope, 0x8000010, null);
            }
            result = new ExpressionResult(info);
            return result;
        }
        return null;
    }

    protected void getExpressionReferences(IASTExpression expression, List references) {
        if (expression != null) {
            List eRefs = ((ASTExpression)expression).getReferences();
            if (eRefs != null && !eRefs.isEmpty()) {
                int i = 0;
                while (i < eRefs.size()) {
                    IASTReference r = (IASTReference)eRefs.get(i);
                    references.add(this.cache.getReference(r.getOffset(), r.getReferencedElement()));
                    ++i;
                }
            }
            if (expression.getLHSExpression() != null) {
                this.getExpressionReferences(expression.getLHSExpression(), references);
            }
            if (expression.getRHSExpression() != null) {
                this.getExpressionReferences(expression.getRHSExpression(), references);
            }
        }
    }

    public IASTExpression.IASTNewExpressionDescriptor createNewDescriptor(List newPlacementExpressions, List newTypeIdExpressions, List newInitializerExpressions) {
        return new ASTNewDescriptor(newPlacementExpressions, newTypeIdExpressions, newInitializerExpressions);
    }

    public IASTExceptionSpecification createExceptionSpecification(IASTScope scope, List typeIds) throws ASTSemanticException {
        ArrayList<String> newTypeIds = new ArrayList<String>();
        if (typeIds != null) {
            int size = typeIds.size();
            int i = 0;
            while (i < size) {
                newTypeIds.add(((IASTTypeId)typeIds.get(i)).toString());
                ++i;
            }
        }
        return new ASTExceptionSpecification(newTypeIds);
    }

    public IASTConstructorMemberInitializer createConstructorMemberInitializer(IASTScope scope, ITokenDuple duple, IASTExpression expressionList) {
        ISymbol symbol;
        boolean requireReferenceResolution;
        ArrayList references;
        block4: {
            this.setFilename(duple);
            references = new ArrayList();
            IContainerSymbol scopeSymbol = this.scopeToSymbol(scope);
            requireReferenceResolution = false;
            symbol = null;
            if (duple != null) {
                try {
                    symbol = this.lookupQualifiedName(scopeSymbol, duple, references, true);
                }
                catch (ASTSemanticException aSTSemanticException) {
                    if (!(scope instanceof ASTClassSpecifier)) break block4;
                    ASTClassSpecifier classSpecifier = (ASTClassSpecifier)scope;
                    classSpecifier.addUnresolvedReference(new UnresolvedReferenceDuple(scopeSymbol, duple));
                }
            }
        }
        if (symbol != null) {
            this.createConstructorReference(symbol, (ASTExpression)expressionList, duple, references);
        }
        this.getExpressionReferences(expressionList, references);
        return new ASTConstructorMemberInitializer(expressionList, duple == null ? BaseASTFactory.EMPTY_STRING : duple.toCharArray(), duple == null ? 0 : duple.getFirstToken().getOffset(), references, requireReferenceResolution);
    }

    public IASTSimpleTypeSpecifier createSimpleTypeSpecifier(IASTScope scope, IASTSimpleTypeSpecifier.Type kind, ITokenDuple typeName, boolean isShort, boolean isLong, boolean isSigned, boolean isUnsigned, boolean isTypename, boolean isComplex, boolean isImaginary, boolean isGlobal, Map extensionParms) throws ASTSemanticException {
        IASTSimpleTypeSpecifier query;
        this.setFilename(typeName);
        if (this.extension.overrideCreateSimpleTypeSpecifierMethod(kind)) {
            return this.extension.createSimpleTypeSpecifier(this.pst, scope, kind, typeName, isShort, isLong, isSigned, isUnsigned, isTypename, isComplex, isImaginary, isGlobal, extensionParms);
        }
        char[] typeNameAsString = typeName.toCharArray();
        if (kind != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME && (query = (IASTSimpleTypeSpecifier)this.simpleTypeSpecCache.get(typeNameAsString)) != null) {
            return query;
        }
        ITypeInfo.eType type = null;
        if (kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
            type = ITypeInfo.t_type;
        } else if (kind == IASTSimpleTypeSpecifier.Type.BOOL) {
            type = ITypeInfo.t_bool;
        } else if (kind == IASTSimpleTypeSpecifier.Type.CHAR) {
            type = ITypeInfo.t_char;
        } else if (kind == IASTSimpleTypeSpecifier.Type.DOUBLE || kind == IASTSimpleTypeSpecifier.Type.FLOAT) {
            type = ITypeInfo.t_double;
        } else if (kind == IASTSimpleTypeSpecifier.Type.INT) {
            type = ITypeInfo.t_int;
        } else if (kind == IASTSimpleTypeSpecifier.Type.VOID) {
            type = ITypeInfo.t_void;
        } else if (kind == IASTSimpleTypeSpecifier.Type.WCHAR_T) {
            type = ITypeInfo.t_wchar_t;
        } else if (kind == IASTSimpleTypeSpecifier.Type._BOOL) {
            type = ITypeInfo.t__Bool;
        }
        ArrayList references = kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME ? new ArrayList(4) : null;
        ISymbol s = this.pst.newSymbol(BaseASTFactory.EMPTY_STRING, type);
        if (kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
            IToken last = typeName.getLastToken();
            IToken current = null;
            ISymbol typeSymbol = this.getScopeToSearchUpon(scope, typeName.getFirstToken());
            if (isGlobal) {
                typeSymbol = typeSymbol.getSymbolTable().getCompilationUnit();
            }
            List[] argLists = typeName.getTemplateIdArgLists();
            int idx = 0;
            while (current != last) {
                IToken iToken = current = current != null ? current.getNext() : typeName.getFirstToken();
                if (current.getType() == 3) {
                    ++idx;
                    continue;
                }
                char[] image = current.getCharImage();
                int offset = current.getOffset();
                if (argLists != null && argLists[idx] != null && current != last && current.getNext().getType() == 42) {
                    current = TokenFactory.consumeTemplateIdArguments(current.getNext(), last);
                }
                if (typeSymbol instanceof IDeferredTemplateInstance) {
                    typeSymbol = ((IDeferredTemplateInstance)typeSymbol).getTemplate().getTemplatedSymbol();
                }
                try {
                    typeSymbol = argLists != null && argLists[idx] != null ? typeSymbol.lookupTemplateId(image, this.getTemplateArgList(argLists[idx])) : (current != last ? typeSymbol.lookupNestedNameSpecifier(image) : typeSymbol.lookup(image));
                    if (typeSymbol != null) {
                        this.addReference(references, this.createReference(typeSymbol, image, offset));
                        if (argLists == null || argLists[idx] == null) continue;
                        this.addTemplateIdReferences(references, argLists[idx]);
                        typeName.freeReferences(this.cache);
                        continue;
                    }
                    this.handleProblem(0x8000002, image, current.getOffset(), current.getEndOffset(), current.getLineNumber(), true);
                }
                catch (ParserSymbolTableException e) {
                    this.handleProblem(e.createProblemID(), image, typeName.getStartOffset(), typeName.getEndOffset(), typeName.getLineNumber(), true);
                }
            }
            s.setTypeSymbol(typeSymbol);
        }
        s.getTypeInfo().setBit(isLong, 16384);
        s.getTypeInfo().setBit(isShort, 8192);
        s.getTypeInfo().setBit(isUnsigned, 4096);
        s.getTypeInfo().setBit(isComplex, 65536);
        s.getTypeInfo().setBit(isImaginary, 131072);
        s.getTypeInfo().setBit(isSigned, 524288);
        ASTSimpleTypeSpecifier result = new ASTSimpleTypeSpecifier(s, false, typeNameAsString, references);
        if (kind != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
            this.simpleTypeSpecCache.put(typeNameAsString, result);
        }
        return result;
    }

    public IASTFunction createFunction(IASTScope scope, ITokenDuple name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int startLine, int nameOffset, int nameEndOffset, int nameLine, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, List constructorChain, boolean isFunctionDefinition, boolean hasFunctionTryBlock, boolean hasVariableArguments) throws ASTSemanticException {
        ISymbol symbol;
        this.setFilename(name);
        ArrayList references = new ArrayList();
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        if (name.getSegmentCount() > 1) {
            symbol = this.lookupQualifiedName(ownerScope, name.getLeadingSegments(), references, false, LookupType.FORPARENTSCOPE);
            IContainerSymbol parentScope = null;
            if (symbol instanceof IContainerSymbol) {
                parentScope = (IContainerSymbol)symbol;
            } else if (symbol instanceof IDeferredTemplateInstance) {
                parentScope = ((IDeferredTemplateInstance)symbol).getTemplate().getTemplatedSymbol();
            }
            if (parentScope != null && (parentScope.getType() == ITypeInfo.t_class || parentScope.getType() == ITypeInfo.t_struct || parentScope.getType() == ITypeInfo.t_union)) {
                if (parentScope.getASTExtension().getPrimaryDeclaration() instanceof IASTElaboratedTypeSpecifier) {
                    this.handleProblem(scope, 0x8000000, name.toCharArray(), startOffset, nameEndOffset, startLine, true);
                }
                IASTScope methodParentScope = (IASTScope)((Object)parentScope.getASTExtension().getPrimaryDeclaration());
                ITokenDuple newName = name.getLastSegment();
                return this.createMethod(methodParentScope, newName, parameters, returnType, exception, isInline, isFriend, isStatic, startOffset, startLine, newName.getFirstToken().getOffset(), nameEndOffset, nameLine, ownerTemplate, isConst, isVolatile, isVirtual, isExplicit, isPureVirtual, ASTAccessVisibility.PRIVATE, constructorChain, references, isFunctionDefinition, hasFunctionTryBlock, hasVariableArguments);
            }
        }
        symbol = this.pst.newParameterizedSymbol(name.extractNameFromTemplateId(), ITypeInfo.t_function);
        this.setFunctionTypeInfoBits(isInline, isFriend, isStatic, (IParameterizedSymbol)symbol);
        symbol.setHasVariableArgs(hasVariableArguments);
        symbol.prepareForParameters(parameters.size());
        this.setParameter((IParameterizedSymbol)symbol, returnType, false, references);
        this.setParameters((IParameterizedSymbol)symbol, references, parameters);
        symbol.setIsForwardDeclaration(!isFunctionDefinition);
        boolean previouslyDeclared = false;
        int size = parameters.size();
        ArrayList<ITypeInfo> functionParameters = new ArrayList<ITypeInfo>(size);
        int i = 0;
        while (i < size) {
            ASTParameterDeclaration param = (ASTParameterDeclaration)parameters.get(i);
            if (param.getSymbol() == null) {
                this.handleProblem(0x8000000, param.getNameCharArray(), param.getNameOffset(), param.getEndingOffset(), param.getStartingLine(), true);
            }
            functionParameters.add(param.getSymbol().getTypeInfo());
            ++i;
        }
        IParameterizedSymbol functionDeclaration = null;
        functionDeclaration = (IParameterizedSymbol)this.lookupQualifiedName(ownerScope, name.getFirstToken().getCharImage(), ITypeInfo.t_function, functionParameters, 0, null, false, LookupType.FORDEFINITION);
        if (functionDeclaration != null && symbol.isType(ITypeInfo.t_function)) {
            previouslyDeclared = true;
            if (isFunctionDefinition) {
                functionDeclaration.setForwardSymbol(symbol);
            }
        }
        if (!previouslyDeclared || isFunctionDefinition) {
            try {
                ownerScope.addSymbol(symbol);
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), name.toCharArray());
            }
        } else {
            symbol = functionDeclaration;
        }
        ASTFunction function = new ASTFunction((IParameterizedSymbol)symbol, nameEndOffset, parameters, returnType, exception, startOffset, startLine, nameOffset, nameLine, ownerTemplate, references, previouslyDeclared, hasFunctionTryBlock, isFriend, this.filename);
        this.attachSymbolExtension(symbol, function, isFunctionDefinition);
        return function;
    }

    protected void setFunctionTypeInfoBits(boolean isInline, boolean isFriend, boolean isStatic, IParameterizedSymbol symbol) {
        symbol.getTypeInfo().setBit(isInline, 32);
        symbol.getTypeInfo().setBit(isFriend, 512);
        symbol.getTypeInfo().setBit(isStatic, 4);
    }

    protected void setParameters(IParameterizedSymbol symbol, List references, List params) throws ASTSemanticException {
        int size = params.size();
        int i = 0;
        while (i < size) {
            this.setParameter(symbol, (IASTParameterDeclaration)params.get(i), true, references);
            ++i;
        }
    }

    protected ITypeInfo getParameterTypeInfo(IASTAbstractDeclaration absDecl) throws ASTSemanticException {
        TypeInfoProvider provider = this.pst.getTypeInfoProvider();
        provider.beginTypeConstruction();
        if (absDecl.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleType = (IASTSimpleTypeSpecifier)absDecl.getTypeSpecifier();
            IASTSimpleTypeSpecifier.Type kind = simpleType.getType();
            if (kind == IASTSimpleTypeSpecifier.Type.BOOL) {
                provider.setType(ITypeInfo.t_bool);
            } else if (kind == IASTSimpleTypeSpecifier.Type.CHAR) {
                provider.setType(ITypeInfo.t_char);
            } else if (kind == IASTSimpleTypeSpecifier.Type.DOUBLE) {
                provider.setType(ITypeInfo.t_double);
            } else if (kind == IASTSimpleTypeSpecifier.Type.FLOAT) {
                provider.setType(ITypeInfo.t_float);
            } else if (kind == IASTSimpleTypeSpecifier.Type.INT) {
                provider.setType(ITypeInfo.t_int);
            } else if (kind == IASTSimpleTypeSpecifier.Type.VOID) {
                provider.setType(ITypeInfo.t_void);
            } else if (kind == IASTSimpleTypeSpecifier.Type.WCHAR_T) {
                provider.setType(ITypeInfo.t_wchar_t);
            } else if (kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
                provider.setType(ITypeInfo.t_type);
            } else if (kind == IASTSimpleTypeSpecifier.Type._BOOL) {
                provider.setType(ITypeInfo.t__Bool);
            }
            this.setTypeBitFlags(provider, simpleType);
        } else if (absDecl.getTypeSpecifier() instanceof IASTClassSpecifier) {
            provider.setType(ITypeInfo.t_type);
            provider.setTypeSymbol(((ASTClassSpecifier)absDecl.getTypeSpecifier()).getSymbol());
        } else if (absDecl.getTypeSpecifier() instanceof IASTEnumerationSpecifier) {
            provider.setType(ITypeInfo.t_type);
            provider.setTypeSymbol(((ASTEnumerationSpecifier)absDecl.getTypeSpecifier()).getSymbol());
        } else if (absDecl.getTypeSpecifier() instanceof IASTElaboratedTypeSpecifier) {
            provider.setType(ITypeInfo.t_type);
            provider.setTypeSymbol(((ASTElaboratedTypeSpecifier)absDecl.getTypeSpecifier()).getSymbol());
        }
        return provider.completeConstruction();
    }

    private void setTypeBitFlags(TypeInfoProvider provider, IASTSimpleTypeSpecifier simpleType) {
        provider.setBit(simpleType.isLong(), 16384);
        provider.setBit(simpleType.isShort(), 8192);
        provider.setBit(simpleType.isUnsigned(), 4096);
        provider.setBit(simpleType.isComplex(), 65536);
        provider.setBit(simpleType.isImaginary(), 131072);
        provider.setBit(simpleType.isSigned(), 524288);
    }

    protected void setParameter(IParameterizedSymbol symbol, IASTAbstractDeclaration absDecl, boolean isParameter, List references) throws ASTSemanticException {
        if (absDecl.getTypeSpecifier() == null) {
            return;
        }
        ITypeInfo info = this.getParameterTypeInfo(absDecl);
        ITypeInfo.eType type = info.getType();
        ISymbol xrefSymbol = info.getTypeSymbol();
        ArrayList<IASTReference> newReferences = null;
        int infoBits = 0;
        if (absDecl.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier) {
            if (((IASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getType() == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
                xrefSymbol = ((ASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getSymbol();
                newReferences = ((ASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getReferences();
            }
            infoBits = ((ASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getSymbol().getTypeInfo().getTypeBits();
        } else if (absDecl.getTypeSpecifier() instanceof ASTElaboratedTypeSpecifier) {
            ASTElaboratedTypeSpecifier elab = (ASTElaboratedTypeSpecifier)absDecl.getTypeSpecifier();
            xrefSymbol = elab.getSymbol();
            List elabReferences = elab.getReferences();
            newReferences = new ArrayList<IASTReference>(elabReferences.size());
            int i = 0;
            while (i < elabReferences.size()) {
                IASTReference r = (IASTReference)elabReferences.get(i);
                newReferences.add(this.cache.getReference(r.getOffset(), r.getReferencedElement()));
                ++i;
            }
            if (xrefSymbol != null) {
                this.addReference(newReferences, this.createReference(xrefSymbol, elab.getNameCharArray(), elab.getNameOffset()));
            }
        }
        char[] paramName = BaseASTFactory.EMPTY_STRING;
        if (absDecl instanceof IASTParameterDeclaration) {
            paramName = ((ASTParameterDeclaration)absDecl).getNameCharArray();
        }
        ISymbol paramSymbol = this.pst.newSymbol(paramName, type);
        if (xrefSymbol != null) {
            if (absDecl.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier) {
                paramSymbol.setTypeSymbol(xrefSymbol.getTypeSymbol());
            } else {
                paramSymbol.setTypeSymbol(xrefSymbol);
            }
        }
        paramSymbol.getTypeInfo().setTypeBits(infoBits);
        paramSymbol.getTypeInfo().setBit(absDecl.isConst(), 1024);
        paramSymbol.getTypeInfo().setBit(absDecl.isVolatile(), 2048);
        List ptrs = null;
        List arrayMods = null;
        if (absDecl instanceof ASTParameterDeclaration) {
            ptrs = ((ASTParameterDeclaration)absDecl).getPointerOperatorsList();
            arrayMods = ((ASTParameterDeclaration)absDecl).getArrayModifiersList();
        } else {
            ptrs = ((ASTAbstractDeclaration)absDecl).getPointerOperatorsList();
            arrayMods = ((ASTAbstractDeclaration)absDecl).getArrayModifiersList();
        }
        this.setPointerOperators(paramSymbol, ptrs, arrayMods);
        if (isParameter) {
            symbol.addParameter(paramSymbol);
        } else {
            symbol.setReturnType(paramSymbol);
        }
        if (newReferences != null && !newReferences.isEmpty()) {
            references.addAll(newReferences);
        }
        if (absDecl instanceof ASTParameterDeclaration) {
            ASTParameterDeclaration parm = (ASTParameterDeclaration)absDecl;
            parm.setSymbol(paramSymbol);
            this.attachSymbolExtension(paramSymbol, parm, true);
        }
    }

    protected void setPointerOperators(ISymbol symbol, List pointerOps, List arrayMods) throws ASTSemanticException {
        int ptrOpsSize = pointerOps.size();
        int i = 0;
        while (i < ptrOpsSize) {
            ASTPointerOperator pointerOperator = (ASTPointerOperator)pointerOps.get(i);
            if (pointerOperator == ASTPointerOperator.REFERENCE) {
                symbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference));
            } else if (pointerOperator == ASTPointerOperator.POINTER) {
                symbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
            } else if (pointerOperator == ASTPointerOperator.CONST_POINTER) {
                symbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, true, false));
            } else if (pointerOperator == ASTPointerOperator.VOLATILE_POINTER) {
                symbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, true));
            } else if (pointerOperator == ASTPointerOperator.RESTRICT_POINTER) {
                symbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
            }
            ++i;
        }
        int arrayModsSize = arrayMods.size();
        int i2 = 0;
        while (i2 < arrayModsSize) {
            symbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_array));
            ++i2;
        }
    }

    public IASTMethod createMethod(IASTScope scope, ITokenDuple name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int startLine, int nameOffset, int nameEndOffset, int nameLine, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChain, boolean isFunctionDefinition, boolean hasFunctionTryBlock, boolean hasVariableArguments) throws ASTSemanticException {
        return this.createMethod(scope, name, parameters, returnType, exception, isInline, isFriend, isStatic, startOffset, startLine, nameOffset, nameEndOffset, nameLine, ownerTemplate, isConst, isVolatile, isVirtual, isExplicit, isPureVirtual, visibility, constructorChain, null, isFunctionDefinition, hasFunctionTryBlock, hasVariableArguments);
    }

    public IASTMethod createMethod(IASTScope scope, ITokenDuple nameDuple, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChain, List references, boolean isFunctionDefinition, boolean hasFunctionTryBlock, boolean hasVariableArguments) throws ASTSemanticException {
        this.setFilename(nameDuple);
        boolean isConstructor = false;
        boolean isDestructor = false;
        IContainerSymbol ownerScope = this.scopeToSymbol(ownerTemplate != null ? (IASTScope)((Object)ownerTemplate) : scope);
        IParameterizedSymbol symbol = null;
        if (references == null) {
            ITokenDuple leadingSegments;
            ISymbol test;
            references = new ArrayList();
            if (nameDuple.length() > 2 && (test = this.lookupQualifiedName(ownerScope, leadingSegments = nameDuple.getLeadingSegments(), references, false)) == ownerScope) {
                nameDuple = nameDuple.getLastSegment();
            }
        }
        char[] methodName = null;
        List templateIdArgList = null;
        if (nameDuple.getTemplateIdArgLists() != null) {
            templateIdArgList = nameDuple.getTemplateIdArgLists()[0];
            methodName = nameDuple.extractNameFromTemplateId();
        } else {
            methodName = nameDuple.toCharArray();
        }
        symbol = this.pst.newParameterizedSymbol(methodName, ITypeInfo.t_function);
        this.setFunctionTypeInfoBits(isInline, isFriend, isStatic, symbol);
        this.setMethodTypeInfoBits(symbol, isConst, isVolatile, isVirtual, isExplicit);
        symbol.setHasVariableArgs(hasVariableArguments);
        symbol.prepareForParameters(parameters.size());
        if (returnType.getTypeSpecifier() != null) {
            this.setParameter(symbol, returnType, false, references);
        }
        this.setParameters(symbol, references, parameters);
        IASTClassSpecifier classifier = null;
        classifier = scope instanceof IASTTemplateDeclaration ? (IASTClassSpecifier)((IASTTemplateDeclaration)scope).getOwnerScope() : (IASTClassSpecifier)scope;
        char[] parentName = ((ASTClassSpecifier)classifier).getNameCharArray();
        if (returnType.getTypeSpecifier() == null) {
            if (CharArrayUtils.indexOf(IASTFactory.DOUBLE_COLON, parentName) != -1) {
                parentName = CharArrayUtils.lastSegment(parentName, IASTFactory.DOUBLE_COLON);
            }
            if (CharArrayUtils.equals(parentName, methodName)) {
                isConstructor = true;
            } else if (methodName[0] == '~' && CharArrayUtils.equals(methodName, 1, methodName.length - 1, parentName)) {
                isDestructor = true;
            }
        }
        symbol.setIsForwardDeclaration(!isFunctionDefinition);
        boolean previouslyDeclared = false;
        IParameterizedSymbol functionDeclaration = null;
        if (isFunctionDefinition || isFriend) {
            int size = parameters.size();
            ArrayList<ITypeInfo> functionParameters = new ArrayList<ITypeInfo>(size);
            int i = 0;
            while (i < size) {
                ASTParameterDeclaration param = (ASTParameterDeclaration)parameters.get(i);
                if (param.getSymbol() == null) {
                    this.handleProblem(0x8000000, param.getNameCharArray(), param.getNameOffset(), param.getEndingOffset(), param.getNameLineNumber(), true);
                }
                functionParameters.add(param.getSymbol().getTypeInfo());
                ++i;
            }
            functionDeclaration = (IParameterizedSymbol)this.lookupQualifiedName(ownerScope, nameDuple, isConstructor ? ITypeInfo.t_constructor : ITypeInfo.t_function, functionParameters, null, false, isFriend ? LookupType.FORFRIENDSHIP : LookupType.FORDEFINITION);
            boolean bl = functionDeclaration != null && functionDeclaration.isType(isConstructor ? ITypeInfo.t_constructor : ITypeInfo.t_function) ? true : (previouslyDeclared = false);
            if (isFriend) {
                if (functionDeclaration != null && functionDeclaration.isType(isConstructor ? ITypeInfo.t_constructor : ITypeInfo.t_function)) {
                    symbol.setForwardSymbol(functionDeclaration);
                    visibility = ASTAccessVisibility.PRIVATE;
                } else if (ownerScope.getContainingSymbol().isType(ITypeInfo.t_constructor) || ownerScope.getContainingSymbol().isType(ITypeInfo.t_function) || ownerScope.getContainingSymbol().isType(ITypeInfo.t_block)) {
                    this.handleProblem(0x8000011, nameDuple.toCharArray(), nameDuple.getStartOffset(), nameDuple.getEndOffset(), nameDuple.getLineNumber(), true);
                }
            } else if (functionDeclaration != null && functionDeclaration.isType(isConstructor ? ITypeInfo.t_constructor : ITypeInfo.t_function)) {
                functionDeclaration.setForwardSymbol(symbol);
                visibility = ((IASTMethod)((Object)functionDeclaration.getASTExtension().getPrimaryDeclaration())).getVisiblity();
            }
        }
        try {
            if (isFriend) {
                if (functionDeclaration != null) {
                    ((IDerivableContainerSymbol)ownerScope).addFriend(functionDeclaration);
                } else {
                    ((IDerivableContainerSymbol)ownerScope).addFriend(symbol);
                }
            } else if (!isConstructor) {
                if (templateIdArgList == null) {
                    ownerScope.addSymbol(symbol);
                } else {
                    ownerScope.addTemplateId(symbol, this.getTemplateArgList(templateIdArgList));
                }
            } else {
                symbol.setType(ITypeInfo.t_constructor);
                ((IDerivableContainerSymbol)ownerScope).addConstructor(symbol);
            }
        }
        catch (ParserSymbolTableException e) {
            this.handleProblem(e.createProblemID(), nameDuple.toCharArray(), nameDuple.getStartOffset(), nameDuple.getEndOffset(), nameDuple.getLineNumber(), true);
        }
        this.resolveLeftoverConstructorInitializerMembers(symbol, constructorChain);
        ASTMethod method = new ASTMethod(symbol, parameters, returnType, exception, startOffset, startingLine, nameOffset, nameEndOffset, nameLine, ownerTemplate, references, previouslyDeclared, isConstructor, isDestructor, isPureVirtual, visibility, constructorChain, hasFunctionTryBlock, isFriend, this.filename);
        if (functionDeclaration != null && isFunctionDefinition) {
            this.attachSymbolExtension(symbol, (ASTSymbol)functionDeclaration.getASTExtension().getPrimaryDeclaration(), false);
        }
        this.attachSymbolExtension(symbol, method, isFunctionDefinition);
        return method;
    }

    protected void resolveLeftoverConstructorInitializerMembers(IParameterizedSymbol symbol, List constructorChain) throws ASTSemanticException {
        if (constructorChain != null) {
            int size = constructorChain.size();
            int i = 0;
            while (i < size) {
                IASTConstructorMemberInitializer initializer = (IASTConstructorMemberInitializer)constructorChain.get(i);
                if (initializer.getNameCharArray().length > 0 && initializer instanceof ASTConstructorMemberInitializer && ((ASTConstructorMemberInitializer)initializer).requiresNameResolution()) {
                    ASTConstructorMemberInitializer realInitializer = (ASTConstructorMemberInitializer)initializer;
                    IDerivableContainerSymbol container = (IDerivableContainerSymbol)symbol.getContainingSymbol();
                    this.lookupQualifiedName(container, realInitializer.getNameCharArray(), ITypeInfo.t_any, null, realInitializer.getNameOffset(), realInitializer.getReferences(), false, LookupType.QUALIFIED);
                }
                ++i;
            }
        }
    }

    protected void setMethodTypeInfoBits(IParameterizedSymbol symbol, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit) {
        symbol.getTypeInfo().setBit(isConst, 1024);
        symbol.getTypeInfo().setBit(isVolatile, 2048);
        symbol.getTypeInfo().setBit(isVirtual, 64);
        symbol.getTypeInfo().setBit(isExplicit, 128);
    }

    public IASTVariable createVariable(IASTScope scope, ITokenDuple name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, IASTExpression constructorExpression, char[] fn) throws ASTSemanticException {
        ISymbol variableDeclaration;
        ISymbol newSymbol;
        this.setFilename(fn);
        ArrayList references = new ArrayList();
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        if (name == null) {
            this.handleProblem(0x8000003, null, startingOffset, nameEndOffset, nameLine, true);
        }
        if (name.getSegmentCount() > 1) {
            ISymbol symbol = this.lookupQualifiedName(ownerScope, name.getLeadingSegments(), references, false, LookupType.FORPARENTSCOPE);
            IContainerSymbol parentScope = null;
            if (symbol instanceof IContainerSymbol) {
                parentScope = (IContainerSymbol)symbol;
            } else if (symbol instanceof IDeferredTemplateInstance) {
                parentScope = ((IDeferredTemplateInstance)symbol).getTemplate().getTemplatedSymbol();
            }
            if (parentScope != null && (parentScope.getType() == ITypeInfo.t_class || parentScope.getType() == ITypeInfo.t_struct || parentScope.getType() == ITypeInfo.t_union)) {
                IASTScope fieldParentScope = (IASTScope)((Object)parentScope.getASTExtension().getPrimaryDeclaration());
                ITokenDuple newName = name.getLastSegment();
                return this.createField(fieldParentScope, newName, isAuto, initializerClause, bitfieldExpression, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, startingOffset, startingLine, newName.getStartOffset(), nameEndOffset, nameLine, constructorExpression, ASTAccessVisibility.PRIVATE, references, fn);
            }
        }
        if ((newSymbol = this.cloneSimpleTypeSymbol(name.getFirstToken().getCharImage(), abstractDeclaration, references)) == null) {
            this.handleProblem(0x8000000, name.toCharArray());
        }
        this.setVariableTypeInfoBits(isAuto, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, newSymbol);
        int numPtrOps = ((ASTAbstractDeclaration)abstractDeclaration).getNumArrayModifiers() + ((ASTAbstractDeclaration)abstractDeclaration).getNumPointerOperators();
        newSymbol.preparePtrOperatros(numPtrOps);
        this.setPointerOperators(newSymbol, ((ASTAbstractDeclaration)abstractDeclaration).getPointerOperatorsList(), ((ASTAbstractDeclaration)abstractDeclaration).getArrayModifiersList());
        newSymbol.setIsForwardDeclaration(isStatic || isExtern);
        boolean previouslyDeclared = false;
        if (!isStatic && (variableDeclaration = this.lookupQualifiedName(ownerScope, name.toCharArray(), null, false, LookupType.UNQUALIFIED)) != null && newSymbol.getType() == variableDeclaration.getType()) {
            ITypeInfo varInfo;
            TypeInfoProvider provider = this.pst.getTypeInfoProvider();
            ITypeInfo newInfo = newSymbol.getTypeInfo().getFinalType(provider);
            if (newInfo.equals(varInfo = variableDeclaration.getTypeInfo().getFinalType(provider))) {
                variableDeclaration.setForwardSymbol(newSymbol);
                previouslyDeclared = true;
            }
            provider.returnTypeInfo(newInfo);
            provider.returnTypeInfo(varInfo);
        }
        try {
            ownerScope.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException e) {
            this.handleProblem(e.createProblemID(), name.getFirstToken().getCharImage());
        }
        ASTVariable variable = new ASTVariable(newSymbol, abstractDeclaration, initializerClause, bitfieldExpression, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, references, constructorExpression, previouslyDeclared, this.filename);
        if (variable.getInitializerClause() != null) {
            variable.getInitializerClause().setOwnerVariableDeclaration(variable);
            this.addDesignatorReferences((ASTInitializerClause)variable.getInitializerClause());
        }
        this.attachSymbolExtension(newSymbol, variable, !isStatic);
        return variable;
    }

    protected void addDesignatorReferences(ASTInitializerClause clause) {
        if (clause.getKind() == IASTInitializerClause.Kind.DESIGNATED_INITIALIZER_LIST || clause.getKind() == IASTInitializerClause.Kind.DESIGNATED_ASSIGNMENT_EXPRESSION) {
            ISymbol variableSymbol = ((ASTVariable)clause.getOwnerVariableDeclaration()).getSymbol();
            ISymbol currentSymbol = variableSymbol.getTypeSymbol();
            if (currentSymbol == null) {
                return;
            }
            ITypeInfo currentTypeInfo = TypeInfoProvider.newTypeInfo(currentSymbol.getTypeInfo());
            List designators = clause.getDesignatorList();
            int size = designators.size();
            int i = 0;
            while (i < size) {
                ASTDesignator designator = (ASTDesignator)designators.get(i);
                if (designator.getKind() == IASTDesignator.DesignatorKind.FIELD) {
                    ISymbol lookup = null;
                    if (!(currentSymbol instanceof IContainerSymbol)) break;
                    try {
                        lookup = ((IContainerSymbol)currentSymbol).lookup(designator.fieldNameCharArray());
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {
                        break;
                    }
                    if (lookup == null || lookup.getContainingSymbol() != currentSymbol) break;
                    try {
                        if (lookup != null) {
                            this.addReference(clause.getReferences(), this.createReference(lookup, designator.fieldNameCharArray(), designator.fieldOffset()));
                        }
                    }
                    catch (ASTSemanticException aSTSemanticException) {}
                    currentTypeInfo = TypeInfoProvider.newTypeInfo(lookup.getTypeInfo());
                    if (lookup.getTypeInfo() == null) break;
                    currentSymbol = lookup.getTypeSymbol();
                } else if (designator.getKind() == IASTDesignator.DesignatorKind.SUBSCRIPT) {
                    currentTypeInfo.applyOperatorExpression(SUBSCRIPT);
                }
                ++i;
            }
        }
        if (clause.getKind() == IASTInitializerClause.Kind.DESIGNATED_INITIALIZER_LIST || clause.getKind() == IASTInitializerClause.Kind.INITIALIZER_LIST) {
            List subInitializers = clause.getInitializersList();
            int size = subInitializers.size();
            int i = 0;
            while (i < size) {
                this.addDesignatorReferences((ASTInitializerClause)subInitializers.get(i));
                ++i;
            }
        }
    }

    protected void setVariableTypeInfoBits(boolean isAuto, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, ISymbol newSymbol) {
        newSymbol.getTypeInfo().setBit(isMutable, 16);
        newSymbol.getTypeInfo().setBit(isAuto, 1);
        newSymbol.getTypeInfo().setBit(isExtern, 8);
        newSymbol.getTypeInfo().setBit(isRegister, 2);
        newSymbol.getTypeInfo().setBit(isStatic, 4);
        newSymbol.getTypeInfo().setBit(abstractDeclaration.isConst(), 1024);
        newSymbol.getTypeInfo().setBit(abstractDeclaration.isVolatile(), 2048);
    }

    protected ISymbol cloneSimpleTypeSymbol(char[] name, IASTAbstractDeclaration abstractDeclaration, List references) throws ASTSemanticException {
        ISymbol newSymbol = null;
        ISymbol symbolToBeCloned = null;
        if (abstractDeclaration.getTypeSpecifier() instanceof ASTSimpleTypeSpecifier) {
            symbolToBeCloned = ((ASTSimpleTypeSpecifier)abstractDeclaration.getTypeSpecifier()).getSymbol();
            if (references != null) {
                List absRefs = ((ASTSimpleTypeSpecifier)abstractDeclaration.getTypeSpecifier()).getReferences();
                int i = 0;
                while (i < absRefs.size()) {
                    IASTReference r = (IASTReference)absRefs.get(i);
                    references.add(this.cache.getReference(r.getOffset(), r.getReferencedElement()));
                    ++i;
                }
            }
        } else if (abstractDeclaration.getTypeSpecifier() instanceof ASTClassSpecifier) {
            symbolToBeCloned = this.pst.newSymbol(name, ITypeInfo.t_type);
            symbolToBeCloned.setTypeSymbol(((ASTClassSpecifier)abstractDeclaration.getTypeSpecifier()).getSymbol());
        } else if (abstractDeclaration.getTypeSpecifier() instanceof ASTElaboratedTypeSpecifier) {
            ASTElaboratedTypeSpecifier elab = (ASTElaboratedTypeSpecifier)abstractDeclaration.getTypeSpecifier();
            symbolToBeCloned = this.pst.newSymbol(name, ITypeInfo.t_type);
            symbolToBeCloned.setTypeSymbol(elab.getSymbol());
            if (elab.getSymbol() != null && references != null) {
                this.addReference(references, this.createReference(elab.getSymbol(), elab.getNameCharArray(), elab.getNameOffset()));
            }
        } else if (abstractDeclaration.getTypeSpecifier() instanceof ASTEnumerationSpecifier) {
            symbolToBeCloned = this.pst.newSymbol(name, ITypeInfo.t_type);
            symbolToBeCloned.setTypeSymbol(((ASTEnumerationSpecifier)abstractDeclaration.getTypeSpecifier()).getSymbol());
        }
        if (symbolToBeCloned != null) {
            newSymbol = (ISymbol)symbolToBeCloned.clone();
            newSymbol.setName(name);
        }
        return newSymbol;
    }

    public IASTField createField(IASTScope scope, ITokenDuple name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, IASTExpression constructorExpression, ASTAccessVisibility visibility, char[] fn) throws ASTSemanticException {
        return this.createField(scope, name, isAuto, initializerClause, bitfieldExpression, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, constructorExpression, visibility, null, fn);
    }

    public IASTField createField(IASTScope scope, ITokenDuple name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, IASTExpression constructorExpression, ASTAccessVisibility visibility, List references, char[] fn) throws ASTSemanticException {
        ISymbol fieldDeclaration;
        ISymbol newSymbol;
        char[] image;
        this.setFilename(fn);
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        char[] cArray = image = name != null ? name.toCharArray() : BaseASTFactory.EMPTY_STRING;
        if (references == null) {
            references = new ArrayList();
        }
        if ((newSymbol = this.cloneSimpleTypeSymbol(image, abstractDeclaration, references)) == null) {
            this.handleProblem(0x8000000, image);
        }
        this.setVariableTypeInfoBits(isAuto, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, newSymbol);
        this.setPointerOperators(newSymbol, ((ASTAbstractDeclaration)abstractDeclaration).getPointerOperatorsList(), ((ASTAbstractDeclaration)abstractDeclaration).getArrayModifiersList());
        newSymbol.setIsForwardDeclaration(isStatic);
        boolean previouslyDeclared = false;
        if (!isStatic && !image.equals(BaseASTFactory.EMPTY_STRING) && (fieldDeclaration = this.lookupQualifiedName(ownerScope, image, null, false, LookupType.FORDEFINITION)) != null && newSymbol.getType() == fieldDeclaration.getType()) {
            ITypeInfo fieldInfo;
            TypeInfoProvider provider = this.pst.getTypeInfoProvider();
            ITypeInfo newInfo = newSymbol.getTypeInfo().getFinalType(provider);
            if (newInfo.equals(fieldInfo = fieldDeclaration.getTypeInfo().getFinalType(provider))) {
                previouslyDeclared = true;
                fieldDeclaration.setForwardSymbol(newSymbol);
                visibility = ((IASTField)((Object)fieldDeclaration.getASTExtension().getPrimaryDeclaration())).getVisiblity();
            }
            provider.returnTypeInfo(newInfo);
            provider.returnTypeInfo(fieldInfo);
        }
        try {
            ownerScope.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException e) {
            this.handleProblem(e.createProblemID(), image);
        }
        ASTField field = new ASTField(newSymbol, abstractDeclaration, initializerClause, bitfieldExpression, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, references, previouslyDeclared, constructorExpression, visibility, this.filename);
        this.attachSymbolExtension(newSymbol, field, !isStatic);
        return field;
    }

    public IASTTemplateDeclaration createTemplateDeclaration(IASTScope scope, List templateParameters, boolean exported, int startingOffset, int startingLine, char[] fn) throws ASTSemanticException {
        this.setFilename(fn);
        ITemplateSymbol template = this.pst.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        int size = templateParameters.size();
        int i = 0;
        while (i < size) {
            ASTTemplateParameter param = (ASTTemplateParameter)templateParameters.get(i);
            try {
                template.addTemplateParameter(param.getSymbol());
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), param.getNameCharArray(), startingOffset, -1, startingLine, true);
            }
            ++i;
        }
        ASTTemplateDeclaration ast = new ASTTemplateDeclaration(template, scope, templateParameters, this.filename);
        ast.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.attachSymbolExtension(template, ast, false);
        return ast;
    }

    public IASTTemplateParameter createTemplateParameter(IASTTemplateParameter.ParamKind kind, char[] identifier, IASTTypeId defaultValue, IASTParameterDeclaration parameter, List parms, IASTCodeScope parameterScope, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endingOffset, int endingLine, char[] fn) throws ASTSemanticException {
        ISymbol symbol = null;
        TypeInfoProvider provider = this.pst.getTypeInfoProvider();
        provider.beginTypeConstruction();
        if (defaultValue != null) {
            try {
                provider.setDefaultObj(defaultValue.getTypeSymbol().getTypeInfo());
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
        }
        if (kind == IASTTemplateParameter.ParamKind.TEMPLATE_LIST) {
            ITemplateSymbol template = this.pst.newTemplateSymbol(identifier);
            provider.setType(ITypeInfo.t_templateParameter);
            provider.setTemplateParameterType(ITypeInfo.t_template);
            template.setTypeInfo(provider.completeConstruction());
            int size = parms.size();
            int i = 0;
            while (i < size) {
                ASTTemplateParameter param = (ASTTemplateParameter)parms.get(i);
                try {
                    template.addTemplateParameter(param.getSymbol());
                }
                catch (ParserSymbolTableException e) {
                    this.handleProblem(e.createProblemID(), param.getNameCharArray(), param.getStartingOffset(), param.getEndingOffset(), param.getStartingLine(), true);
                }
                ++i;
            }
            symbol = template;
        } else if (kind == IASTTemplateParameter.ParamKind.CLASS || kind == IASTTemplateParameter.ParamKind.TYPENAME) {
            symbol = this.pst.newSymbol(identifier);
            provider.setType(ITypeInfo.t_templateParameter);
            provider.setTemplateParameterType(ITypeInfo.t_typeName);
            symbol.setTypeInfo(provider.completeConstruction());
        } else {
            symbol = this.cloneSimpleTypeSymbol(((ASTParameterDeclaration)parameter).getNameCharArray(), parameter, null);
            provider.setTemplateParameterType(symbol.getType());
            provider.setType(ITypeInfo.t_templateParameter);
            provider.setTypeSymbol(symbol.getTypeSymbol());
            ITypeInfo info = provider.completeConstruction();
            info.addPtrOperator(symbol.getPtrOperators());
            info.setTypeBits(symbol.getTypeInfo().getTypeBits());
            symbol.setTypeInfo(info);
        }
        IContainerSymbol codeScope = ((ASTCodeScope)parameterScope).getContainerSymbol();
        try {
            codeScope.addSymbol(symbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        ASTTemplateParameter ast = new ASTTemplateParameter(symbol, defaultValue, parameter, parms, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, endingOffset, endingLine, fn);
        this.attachSymbolExtension(symbol, ast, false);
        return ast;
    }

    public IASTTemplateInstantiation createTemplateInstantiation(IASTScope scope, int startingOffset, int startingLine, char[] fn) {
        ASTTemplateInstantiation inst = new ASTTemplateInstantiation(scope, fn);
        inst.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        return inst;
    }

    public IASTTemplateSpecialization createTemplateSpecialization(IASTScope scope, int startingOffset, int startingLine, char[] fn) {
        ITemplateSymbol template = this.pst.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        ASTTemplateSpecialization ast = new ASTTemplateSpecialization(template, scope, fn);
        ast.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.attachSymbolExtension(template, ast, false);
        return ast;
    }

    public IASTTypedefDeclaration createTypedef(IASTScope scope, char[] name, IASTAbstractDeclaration mapping, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, char[] fn) throws ASTSemanticException {
        List mappingReferences;
        IContainerSymbol containerSymbol = this.scopeToSymbol(scope);
        ISymbol typeSymbol = this.cloneSimpleTypeSymbol(name, mapping, null);
        if (typeSymbol == null) {
            this.handleProblem(scope, 0x8000000, name, nameOffset, nameEndOffset, nameLine, true);
        }
        this.setPointerOperators(typeSymbol, ((ASTAbstractDeclaration)mapping).getPointerOperatorsList(), ((ASTAbstractDeclaration)mapping).getArrayModifiersList());
        if (typeSymbol.getType() != ITypeInfo.t_type) {
            ISymbol newSymbol = this.pst.newSymbol(name, ITypeInfo.t_type);
            newSymbol.getTypeInfo().setBit(true, 256);
            newSymbol.setTypeSymbol(typeSymbol);
            typeSymbol = newSymbol;
        } else {
            typeSymbol.getTypeInfo().setBit(true, 256);
        }
        ArrayList<IASTReference> references = new ArrayList<IASTReference>();
        if (mapping.getTypeSpecifier() instanceof ASTSimpleTypeSpecifier && (mappingReferences = ((ASTSimpleTypeSpecifier)mapping.getTypeSpecifier()).getReferences()) != null && !mappingReferences.isEmpty()) {
            int i = 0;
            while (i < mappingReferences.size()) {
                IASTReference r = (IASTReference)mappingReferences.get(i);
                references.add(this.cache.getReference(r.getOffset(), r.getReferencedElement()));
                ++i;
            }
        }
        try {
            containerSymbol.addSymbol(typeSymbol);
        }
        catch (ParserSymbolTableException e) {
            this.handleProblem(e.createProblemID(), name);
        }
        ASTTypedef d = new ASTTypedef(typeSymbol, mapping, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, references, this.filename);
        this.attachSymbolExtension(typeSymbol, d, true);
        return d;
    }

    public IASTAbstractTypeSpecifierDeclaration createTypeSpecDeclaration(IASTScope scope, IASTTypeSpecifier typeSpecifier, IASTTemplate template, int startingOffset, int startingLine, int endingOffset, int endingLine, boolean isFriend, char[] fn) {
        return new ASTAbstractTypeSpecifierDeclaration(this.scopeToSymbol(scope), typeSpecifier, template, startingOffset, startingLine, endingOffset, endingLine, isFriend, fn);
    }

    public IASTElaboratedTypeSpecifier createElaboratedTypeSpecifier(IASTScope scope, ASTClassKind kind, ITokenDuple name, int startingOffset, int startingLine, int endOffset, int endingLine, boolean isForewardDecl, boolean isFriend) throws ASTSemanticException {
        List[] array;
        IContainerSymbol currentScopeSymbol;
        this.setFilename(name);
        IContainerSymbol originalScope = currentScopeSymbol = this.scopeToSymbol(scope);
        ITypeInfo.eType pstType = this.classKindToTypeInfo(kind);
        ArrayList references = new ArrayList();
        IToken nameToken = name.getFirstToken();
        char[] newSymbolName = BaseASTFactory.EMPTY_STRING;
        List templateIdArgList = null;
        boolean isTemplateId = false;
        if (name.getSegmentCount() != 1) {
            ITokenDuple containerSymbolName = name.getLeadingSegments();
            currentScopeSymbol = containerSymbolName == null ? currentScopeSymbol.getSymbolTable().getCompilationUnit() : (IContainerSymbol)this.lookupQualifiedName(currentScopeSymbol, containerSymbolName, references, true);
            if (currentScopeSymbol == null) {
                this.handleProblem(0x8000002, containerSymbolName.toCharArray(), containerSymbolName.getFirstToken().getOffset(), containerSymbolName.getLastToken().getEndOffset(), containerSymbolName.getLastToken().getLineNumber(), true);
            }
            nameToken = name.getLastSegment().getFirstToken();
        }
        if ((array = name.getTemplateIdArgLists()) != null) {
            isTemplateId = true;
            templateIdArgList = array[array.length - 1];
        }
        newSymbolName = nameToken.getCharImage();
        ISymbol checkSymbol = null;
        if (!isTemplateId) {
            try {
                checkSymbol = isFriend ? ((IDerivableContainerSymbol)currentScopeSymbol).lookupForFriendship(newSymbolName) : currentScopeSymbol.elaboratedLookup(pstType, newSymbolName);
            }
            catch (ParserSymbolTableException e) {
                this.handleProblem(e.createProblemID(), nameToken.getCharImage(), nameToken.getOffset(), nameToken.getEndOffset(), nameToken.getLineNumber(), true);
            }
        }
        List args = null;
        if (isTemplateId) {
            args = this.getTemplateArgList(templateIdArgList);
        }
        if (scope instanceof IASTTemplateInstantiation) {
            if (isTemplateId) {
                checkSymbol = this.pst.newDerivableContainerSymbol(newSymbolName, pstType);
                try {
                    currentScopeSymbol.addTemplateId(checkSymbol, args);
                }
                catch (ParserSymbolTableException e) {
                    this.handleProblem(e.createProblemID(), nameToken.getCharImage(), nameToken.getOffset(), nameToken.getEndOffset(), nameToken.getLineNumber(), true);
                }
            } else {
                this.handleProblem(0x8000009, nameToken.getCharImage());
            }
            checkSymbol = ((ASTTemplateInstantiation)scope).getInstanceSymbol();
        } else {
            if (checkSymbol == null) {
                checkSymbol = this.pst.newDerivableContainerSymbol(newSymbolName, pstType);
                checkSymbol.setIsForwardDeclaration(true);
                try {
                    if (isFriend) {
                        ((IDerivableContainerSymbol)originalScope).addFriend(checkSymbol);
                    } else if (!isTemplateId) {
                        currentScopeSymbol.addSymbol(checkSymbol);
                    } else {
                        currentScopeSymbol.addTemplateId(checkSymbol, args);
                    }
                }
                catch (ParserSymbolTableException e1) {
                    this.handleProblem(e1.createProblemID(), nameToken.getCharImage(), nameToken.getOffset(), nameToken.getEndOffset(), nameToken.getLineNumber(), true);
                }
                ASTElaboratedTypeSpecifier elab = new ASTElaboratedTypeSpecifier(checkSymbol, kind, startingOffset, startingLine, name.getFirstToken().getOffset(), name.getLastToken().getEndOffset(), name.getLastToken().getLineNumber(), endOffset, endingLine, references, isForewardDecl, this.filename);
                this.attachSymbolExtension(checkSymbol, elab, !isForewardDecl);
                return elab;
            }
            if (isFriend) {
                ((IDerivableContainerSymbol)originalScope).addFriend(checkSymbol);
            }
        }
        if (checkSymbol != null) {
            if (scope instanceof IASTTemplateInstantiation) {
                this.addReference(references, this.createReference(checkSymbol, newSymbolName, nameToken.getOffset()));
            }
            if (checkSymbol instanceof ITemplateSymbol) {
                checkSymbol = ((ITemplateSymbol)checkSymbol).getTemplatedSymbol();
            }
            if (checkSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTClassSpecifier || checkSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTEnumerationSpecifier || checkSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTElaboratedTypeSpecifier) {
                ASTElaboratedTypeSpecifier elab = new ASTElaboratedTypeSpecifier(checkSymbol, kind, startingOffset, startingLine, name.getFirstToken().getOffset(), name.getLastToken().getEndOffset(), name.getLastToken().getLineNumber(), endOffset, endingLine, references, isForewardDecl, this.filename);
                this.attachSymbolExtension(checkSymbol, elab, !isForewardDecl);
                return elab;
            }
        } else {
            this.handleProblem(0x8000002, newSymbolName, nameToken.getOffset(), nameToken.getEndOffset(), nameToken.getLineNumber(), true);
        }
        return null;
    }

    public IASTNamespaceAlias createNamespaceAlias(IASTScope scope, char[] identifier, ITokenDuple alias, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endingLine) throws ASTSemanticException {
        this.setFilename(alias);
        IContainerSymbol startingSymbol = this.scopeToSymbol(scope);
        ArrayList references = new ArrayList();
        ISymbol namespaceSymbol = this.lookupQualifiedName(startingSymbol, alias, references, true);
        if (namespaceSymbol.getType() != ITypeInfo.t_namespace) {
            this.handleProblem(0x8000004, alias.toCharArray(), startingOffset, endOffset, startingLine, true);
        }
        IContainerSymbol newSymbol = this.pst.newContainerSymbol(identifier, ITypeInfo.t_namespace);
        newSymbol.setForwardSymbol(namespaceSymbol);
        try {
            startingSymbol.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException e) {
            this.handleProblem(e.createProblemID(), identifier, startingOffset, endOffset, startingLine, true);
        }
        ASTNamespaceAlias astAlias = new ASTNamespaceAlias(newSymbol, alias.toCharArray(), (IASTNamespaceDefinition)((Object)namespaceSymbol.getASTExtension().getPrimaryDeclaration()), startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, endOffset, endingLine, references, this.filename);
        this.attachSymbolExtension(newSymbol, astAlias, true);
        return astAlias;
    }

    public IASTCodeScope createNewCodeBlock(IASTScope scope) {
        IContainerSymbol symbol = this.scopeToSymbol(scope);
        IContainerSymbol newScope = this.pst.newContainerSymbol(BaseASTFactory.EMPTY_STRING, ITypeInfo.t_block);
        newScope.setContainingSymbol(symbol);
        newScope.setIsTemplateMember(symbol.isTemplateMember());
        ASTCodeScope codeScope = new ASTCodeScope(newScope);
        this.attachSymbolExtension(newScope, codeScope, true);
        return codeScope;
    }

    public IASTScope getDeclaratorScope(IASTScope scope, ITokenDuple duple) {
        if (duple != null && duple.getSegmentCount() > 1) {
            ISymbol symbol;
            IContainerSymbol ownerScope = this.scopeToSymbol(scope);
            try {
                symbol = this.lookupQualifiedName(ownerScope, duple.getLeadingSegments(), null, false, LookupType.FORDEFINITION);
            }
            catch (ASTSemanticException aSTSemanticException) {
                return scope;
            }
            IContainerSymbol parentScope = null;
            if (symbol instanceof IContainerSymbol) {
                parentScope = (IContainerSymbol)symbol;
            } else if (symbol instanceof IDeferredTemplateInstance) {
                parentScope = ((IDeferredTemplateInstance)symbol).getTemplate().getTemplatedSymbol();
            }
            if (parentScope != null && parentScope.getASTExtension() != null) {
                if (scope instanceof IASTTemplateDeclaration || scope instanceof IASTTemplateSpecialization) {
                    symbol = this.scopeToSymbol(scope);
                    if (symbol instanceof ITemplateFactory) {
                        symbol.setContainingSymbol(parentScope);
                    }
                    return scope;
                }
                return (IASTScope)((Object)parentScope.getASTExtension().getPrimaryDeclaration());
            }
        }
        return scope;
    }

    public boolean queryIsTypeName(IASTScope scope, ITokenDuple nameInQuestion) {
        ISymbol lookupSymbol = null;
        try {
            lookupSymbol = this.lookupQualifiedName(this.scopeToSymbol(scope), nameInQuestion, null, false);
        }
        catch (ASTSemanticException aSTSemanticException) {}
        if (lookupSymbol == null) {
            return false;
        }
        return lookupSymbol.isType(ITypeInfo.t_type, ITypeInfo.t_enumeration) || lookupSymbol.isType(ITypeInfo.t_templateParameter) && lookupSymbol.getTypeInfo().getTemplateParameterType() == ITypeInfo.t_typeName || lookupSymbol.getASTExtension() != null && lookupSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTTypedefDeclaration;
    }

    public IASTParameterDeclaration createParameterDeclaration(boolean isConst, boolean isVolatile, IASTTypeSpecifier typeSpecifier, List pointerOperators, List arrayModifiers, List parameters, ASTPointerOperator pointerOp, char[] parameterName, IASTInitializerClause initializerClause, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endingOffset, int endingLine, char[] fn) {
        this.setFilename(fn);
        return new ASTParameterDeclaration(null, isConst, isVolatile, typeSpecifier, pointerOperators, arrayModifiers, parameters, pointerOp, parameterName, initializerClause, startingOffset, startingLine, nameOffset, nameEndOffset, nameLine, endingOffset, endingLine, this.filename);
    }

    public IASTTypeId createTypeId(IASTScope scope, IASTSimpleTypeSpecifier.Type kind, boolean isConst, boolean isVolatile, boolean isShort, boolean isLong, boolean isSigned, boolean isUnsigned, boolean isTypename, ITokenDuple name, List pointerOps, List arrayMods, char[] completeSignature) throws ASTSemanticException {
        IASTTypeId check;
        if (kind != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME && (check = (IASTTypeId)this.typeIdCache.get(completeSignature)) != null) {
            return check;
        }
        ASTTypeId result = new ASTTypeId(kind, name, pointerOps, arrayMods, completeSignature, isConst, isVolatile, isUnsigned, isSigned, isShort, isLong, isTypename);
        result.setTypeSymbol(this.createSymbolForTypeId(scope, result));
        if (kind != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
            this.typeIdCache.put(completeSignature, result);
        }
        return result;
    }

    public static ITypeInfo.eType getTypeKind(IASTTypeId id) {
        IASTSimpleTypeSpecifier.Type type = id.getKind();
        if (type == IASTSimpleTypeSpecifier.Type.BOOL) {
            return ITypeInfo.t_bool;
        }
        if (type == IASTSimpleTypeSpecifier.Type._BOOL) {
            return ITypeInfo.t__Bool;
        }
        if (type == IASTSimpleTypeSpecifier.Type.CHAR) {
            return ITypeInfo.t_char;
        }
        if (type == IASTSimpleTypeSpecifier.Type.WCHAR_T) {
            return ITypeInfo.t_wchar_t;
        }
        if (type == IASTSimpleTypeSpecifier.Type.DOUBLE) {
            return ITypeInfo.t_double;
        }
        if (type == IASTSimpleTypeSpecifier.Type.FLOAT) {
            return ITypeInfo.t_float;
        }
        if (type == IASTSimpleTypeSpecifier.Type.INT) {
            return ITypeInfo.t_int;
        }
        if (type == IASTSimpleTypeSpecifier.Type.VOID) {
            return ITypeInfo.t_void;
        }
        if (id.isShort() || id.isLong() || id.isUnsigned() || id.isSigned()) {
            return ITypeInfo.t_int;
        }
        return ITypeInfo.t_type;
    }

    protected ISymbol createSymbolForTypeId(IASTScope scope, IASTTypeId id) throws ASTSemanticException {
        if (id == null) {
            return null;
        }
        ASTTypeId typeId = (ASTTypeId)id;
        ISymbol result = this.pst.newSymbol(BaseASTFactory.EMPTY_STRING, CompleteParseASTFactory.getTypeKind(id));
        result.getTypeInfo().setBit(id.isConst(), 1024);
        result.getTypeInfo().setBit(id.isVolatile(), 2048);
        result.getTypeInfo().setBit(id.isShort(), 8192);
        result.getTypeInfo().setBit(id.isLong(), 16384);
        result.getTypeInfo().setBit(id.isUnsigned(), 4096);
        result.getTypeInfo().setBit(id.isSigned(), 524288);
        ArrayList refs = new ArrayList();
        if (result.getType() == ITypeInfo.t_type) {
            ISymbol typeSymbol = this.lookupQualifiedName(this.scopeToSymbol(scope), typeId.getTokenDuple(), refs, true);
            if (typeSymbol == null) {
                this.freeReferences(refs);
                this.handleProblem(scope, 0x8000007, typeId.getTypeOrClassNameCharArray());
            }
            result.setTypeSymbol(typeSymbol);
            typeId.addReferences(refs, this.cache);
        }
        this.setPointerOperators(result, ((ASTTypeId)id).getPointerOperatorsList(), ((ASTTypeId)id).getArrayModifiersList());
        return result;
    }

    private void freeReferences(List refs) {
        if (refs == null || refs.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < refs.size()) {
            this.cache.returnReference((IASTReference)refs.get(i));
            ++i;
        }
        refs.clear();
    }

    public void signalEndOfClassSpecifier(IASTClassSpecifier astClassSpecifier) {
        ASTClassSpecifier astImplementation = (ASTClassSpecifier)astClassSpecifier;
        try {
            ((IDerivableContainerSymbol)astImplementation.getSymbol()).addCopyConstructor();
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        astImplementation.setProcessingUnresolvedReferences(true);
        List unresolved = astImplementation.getUnresolvedReferences();
        ArrayList references = new ArrayList();
        int size = unresolved.size();
        int i = 0;
        while (i < size) {
            UnresolvedReferenceDuple duple = (UnresolvedReferenceDuple)unresolved.get(i);
            try {
                this.lookupQualifiedName(duple.getScope(), duple.getName(), references, false);
            }
            catch (ASTSemanticException aSTSemanticException) {}
            ++i;
        }
        astImplementation.setProcessingUnresolvedReferences(false);
        if (!references.isEmpty()) {
            astImplementation.setExtraReferences(references, this.cache);
        }
    }

    public IASTInitializerClause createInitializerClause(IASTScope scope, IASTInitializerClause.Kind kind, IASTExpression assignmentExpression, List initializerClauses, List designators) {
        return new ASTInitializerClause(kind, assignmentExpression, initializerClauses, designators);
    }

    public IASTNode lookupSymbolInContext(IASTScope scope, ITokenDuple duple, IASTNode reference) throws ASTNotImplementedException {
        IExtensibleSymbol s = null;
        if (reference == null) {
            try {
                s = this.lookupQualifiedName(this.scopeToSymbol(scope), duple, null, false);
            }
            catch (ASTSemanticException aSTSemanticException) {}
        } else if (reference instanceof ASTExpression) {
            ASTExpression expression = (ASTExpression)reference;
            char[] dupleAsCharArray = duple.toCharArray();
            if (expression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION && CharArrayUtils.equals(expression.getLHSExpression().getIdExpressionCharArray(), dupleAsCharArray)) {
                try {
                    s = this.lookupQualifiedName(this.scopeToSymbol(scope), duple, null, false);
                }
                catch (ASTSemanticException aSTSemanticException) {}
            } else {
                if (expression.getExpressionKind() == IASTExpression.Kind.NEW_NEWTYPEID || expression.getExpressionKind() == IASTExpression.Kind.NEW_TYPEID) {
                    ISymbol classSymbol = null;
                    try {
                        classSymbol = (IContainerSymbol)this.lookupQualifiedName(this.scopeToSymbol(scope), duple, null, false);
                    }
                    catch (ASTSemanticException aSTSemanticException) {}
                    if (classSymbol != null && classSymbol.getTypeInfo().checkBit(256)) {
                        ITypeInfo info = classSymbol.getTypeInfo().getFinalType(this.pst.getTypeInfoProvider());
                        classSymbol = (IContainerSymbol)info.getTypeSymbol();
                        this.pst.getTypeInfoProvider().returnTypeInfo(info);
                    }
                    if (classSymbol == null || !(classSymbol instanceof IDerivableContainerSymbol)) {
                        return null;
                    }
                    ArrayList<ITypeInfo> parameters = new ArrayList<ITypeInfo>();
                    ASTNewDescriptor newDescriptor = (ASTNewDescriptor)expression.getNewExpressionDescriptor();
                    List newInitializerExpressions = newDescriptor.getNewInitializerExpressionsList();
                    int size = newInitializerExpressions.size();
                    int i = 0;
                    while (i < size) {
                        ASTExpression expressionList = (ASTExpression)newInitializerExpressions.get(i);
                        while (expressionList != null) {
                            parameters.add(expressionList.getResultType().getResult());
                            expressionList = (ASTExpression)expressionList.getRHSExpression();
                        }
                        ++i;
                    }
                    try {
                        s = ((IDerivableContainerSymbol)classSymbol).lookupConstructor(parameters);
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {
                        return null;
                    }
                }
                if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_FUNCTIONCALL && CharArrayUtils.equals(expression.getLHSExpression().getIdExpressionCharArray(), dupleAsCharArray)) {
                    try {
                        ISymbol symbol = this.getExpressionSymbol(scope, expression.getExpressionKind(), expression.getLHSExpression(), expression.getRHSExpression(), null, null);
                        if (symbol == null) {
                            return null;
                        }
                        return symbol.getASTExtension().getPrimaryDeclaration();
                    }
                    catch (ASTSemanticException aSTSemanticException) {
                        return null;
                    }
                }
                ASTExpression ownerExpression = expression.findOwnerExpressionForIDExpression(duple);
                if (ownerExpression == null) {
                    return null;
                }
                if (ownerExpression.getExpressionKind().isPostfixMemberReference()) {
                    try {
                        s = this.lookupQualifiedName(this.getSearchScope(ownerExpression.getExpressionKind(), ownerExpression.getLHSExpression(), this.scopeToSymbol(scope)), duple, null, false);
                    }
                    catch (ASTSemanticException aSTSemanticException) {
                        return null;
                    }
                }
                try {
                    s = this.lookupQualifiedName(this.scopeToSymbol(scope), duple, null, false);
                }
                catch (ASTSemanticException aSTSemanticException) {}
            }
        }
        if (s == null) {
            return null;
        }
        return s.getASTExtension().getPrimaryDeclaration();
    }

    public IASTNode expressionToMostPreciseASTNode(IASTScope scope, IASTExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION && expression instanceof ASTExpression) {
            try {
                return this.lookupSymbolInContext(scope, ((ASTIdExpression)expression).getIdExpressionTokenDuple(), null);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
        }
        return expression;
    }

    public boolean validateIndirectMemberOperation(IASTNode node) {
        List pointerOps = null;
        TypeInfoProvider provider = this.pst.getTypeInfoProvider();
        ITypeInfo typeInfo = null;
        if (node instanceof ISymbolOwner) {
            ISymbol symbol = ((ISymbolOwner)((Object)node)).getSymbol();
            typeInfo = symbol.getTypeInfo().getFinalType(provider);
            pointerOps = typeInfo.getPtrOperators();
            provider.returnTypeInfo(typeInfo);
        } else if (node instanceof ASTExpression) {
            ITypeInfo info = ((ASTExpression)node).getResultType().getResult();
            if (info != null) {
                typeInfo = info.getFinalType(provider);
                pointerOps = typeInfo.getPtrOperators();
                provider.returnTypeInfo(typeInfo);
            }
        } else {
            return false;
        }
        if (pointerOps == null || pointerOps.isEmpty()) {
            return false;
        }
        ITypeInfo.PtrOp lastOperator = (ITypeInfo.PtrOp)pointerOps.get(pointerOps.size() - 1);
        return lastOperator.getType() == ITypeInfo.PtrOp.t_array || lastOperator.getType() == ITypeInfo.PtrOp.t_pointer;
    }

    public boolean validateDirectMemberOperation(IASTNode node) {
        List pointerOps = null;
        if (node instanceof ISymbolOwner) {
            ISymbol symbol = ((ISymbolOwner)((Object)node)).getSymbol();
            TypeInfoProvider provider = this.pst.getTypeInfoProvider();
            ITypeInfo info = symbol.getTypeInfo().getFinalType(provider);
            pointerOps = info.getPtrOperators();
            provider.returnTypeInfo(info);
        } else if (node instanceof ASTExpression) {
            ITypeInfo info = ((ASTExpression)node).getResultType().getResult();
            if (info != null) {
                TypeInfoProvider provider = this.pst.getTypeInfoProvider();
                info = info.getFinalType(provider);
                pointerOps = info.getPtrOperators();
                provider.returnTypeInfo(info);
            }
        } else {
            return false;
        }
        if (pointerOps == null || pointerOps.isEmpty()) {
            return true;
        }
        ITypeInfo.PtrOp lastOperator = (ITypeInfo.PtrOp)pointerOps.get(pointerOps.size() - 1);
        return lastOperator.getType() == ITypeInfo.PtrOp.t_reference;
    }

    public void constructExpressions(boolean flag) {
    }

    public IReferenceManager getReferenceManager() {
        return this.cache;
    }

    public boolean validateCaches() {
        return this.cache.isBalanced() && this.pst.getTypeInfoProvider().numAllocated() == 0;
    }

    private static class LookupType
    extends Enum {
        public static final LookupType QUALIFIED = new LookupType(1);
        public static final LookupType UNQUALIFIED = new LookupType(2);
        public static final LookupType FORDEFINITION = new LookupType(3);
        public static final LookupType FORFRIENDSHIP = new LookupType(4);
        public static final LookupType FORPARENTSCOPE = new LookupType(5);

        LookupType(int constant) {
            super(constant);
        }
    }
}

