/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.pst.DeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.DerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectMap;

public class TemplateSymbol
extends ParameterizedSymbol
implements ITemplateSymbol {
    private List _specializations = Collections.EMPTY_LIST;
    private ObjectMap _explicitSpecializations = ObjectMap.EMPTY_MAP;
    private ObjectMap _defnParameterMap = ObjectMap.EMPTY_MAP;
    private ObjectMap _instantiations = ObjectMap.EMPTY_MAP;
    private List _deferredInstantiations = Collections.EMPTY_LIST;
    private boolean _processingDeferred = false;

    protected TemplateSymbol(ParserSymbolTable table, char[] name) {
        super(table, name, ITypeInfo.t_template);
    }

    public Object clone() {
        TemplateSymbol copy = (TemplateSymbol)super.clone();
        copy._defnParameterMap = this._defnParameterMap != ObjectMap.EMPTY_MAP ? (ObjectMap)this._defnParameterMap.clone() : this._defnParameterMap;
        copy._instantiations = this._instantiations != ObjectMap.EMPTY_MAP ? (ObjectMap)this._instantiations.clone() : this._instantiations;
        return copy;
    }

    public IContainerSymbol getTemplatedSymbol() {
        Iterator iter = this.getContentsIterator();
        if (iter.hasNext()) {
            IContainerSymbol contained = (IContainerSymbol)iter.next();
            return contained;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISymbol instantiate(List arguments) throws ParserSymbolTableException {
        void var10_11;
        List paramList;
        if (this.getType() != ITypeInfo.t_template && (this.getType() != ITypeInfo.t_templateParameter || this.getTypeInfo().getTemplateParameterType() != ITypeInfo.t_template)) {
            return null;
        }
        ITemplateSymbol template = TemplateEngine.matchTemplatePartialSpecialization(this, arguments);
        if (template != null && template instanceof ISpecializedSymbol) {
            return template.instantiate(arguments);
        }
        if (template == null) {
            template = this;
        }
        int numParams = (paramList = template.getParameterList()) != null ? paramList.size() : 0;
        int numArgs = arguments.size();
        if (numParams == 0) {
            return null;
        }
        ObjectMap map = new ObjectMap(numParams);
        ISymbol param = null;
        ITypeInfo arg = null;
        ArrayList<ITypeInfo> actualArgs = new ArrayList<ITypeInfo>(numParams);
        IContainerSymbol iContainerSymbol = template.getTemplatedSymbol();
        while (var10_11 != null && var10_11.isTemplateInstance()) {
            ISymbol iSymbol = var10_11.getInstantiatedSymbol();
        }
        int i = 0;
        while (i < numParams) {
            param = (ISymbol)paramList.get(i);
            param = TemplateEngine.translateParameterForDefinition((ISymbol)var10_11, param, this.getDefinitionParameterMap());
            if (i < numArgs) {
                arg = (ITypeInfo)arguments.get(i);
                if (arg.isType(ITypeInfo.t_type)) {
                    if (arg.getTypeSymbol() == null) {
                        throw new ParserSymbolTableException(8);
                    }
                    if (arg.getTypeSymbol().isType(ITypeInfo.t_templateParameter)) {
                        return this.deferredInstance(arguments);
                    }
                }
            } else {
                Object obj = param.getTypeInfo().getDefault();
                if (obj == null || !(obj instanceof ITypeInfo)) throw new ParserSymbolTableException(8);
                arg = (ITypeInfo)obj;
                if (arg.isType(ITypeInfo.t_type) && arg.getTypeSymbol().isType(ITypeInfo.t_templateParameter)) {
                    if (!map.containsKey(arg.getTypeSymbol())) throw new ParserSymbolTableException(8);
                    arg = (ITypeInfo)map.get(arg.getTypeSymbol());
                } else if (arg.isType(ITypeInfo.t_type) && arg.getTypeSymbol() instanceof IDeferredTemplateInstance) {
                    IDeferredTemplateInstance deferred = (IDeferredTemplateInstance)arg.getTypeSymbol();
                    arg = TypeInfoProvider.newTypeInfo(arg);
                    arg.setTypeSymbol(deferred.instantiate(this, map));
                }
            }
            if (!TemplateEngine.matchTemplateParameterAndArgument(param, arg)) {
                throw new ParserSymbolTableException(8);
            }
            map.put(param, arg);
            actualArgs.add(arg);
            ++i;
        }
        IContainerSymbol instance = this.findInstantiation(actualArgs);
        if (instance != null) {
            return instance;
        }
        if (template.isType(ITypeInfo.t_templateParameter)) {
            return this.deferredInstance(arguments);
        }
        IContainerSymbol symbol = template.getTemplatedSymbol();
        ISymbol temp = TemplateEngine.checkForTemplateExplicitSpecialization(template, symbol, actualArgs);
        symbol = (IContainerSymbol)(temp != null ? temp : symbol);
        instance = (IContainerSymbol)symbol.instantiate(template, map);
        this.addInstantiation(instance, actualArgs);
        try {
            this.processDeferredInstantiations();
            return instance;
        }
        catch (ParserSymbolTableException e) {
            if (e.reason != 11) throw e;
            this.removeInstantiation(instance);
            throw e;
        }
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        TemplateSymbol newTemplate = (TemplateSymbol)super.instantiate(template, argMap);
        List parameters = newTemplate.getParameterList();
        int size = parameters.size();
        ISymbol param = null;
        int i = 0;
        while (i < size) {
            param = (ISymbol)parameters.get(i);
            Object obj = param.getTypeInfo().getDefault();
            if (obj instanceof ITypeInfo) {
                param.getTypeInfo().setDefault(TemplateEngine.instantiateTypeInfo((ITypeInfo)obj, template, argMap));
            }
            ++i;
        }
        return newTemplate;
    }

    public void addParameter(ISymbol param) {
        throw new ParserSymbolTableError(0);
    }

    public void addTemplateParameter(ISymbol param) throws ParserSymbolTableException {
        if (this.isType(ITypeInfo.t_template) || this.getTypeInfo().getTemplateParameterType() == ITypeInfo.t_template) {
            if (!this.isAllowableTemplateParameter(param)) {
                throw new ParserSymbolTableException(9);
            }
            this.modifyTemplateParameter(param);
        }
        super.addParameter(param);
    }

    private boolean isAllowableTemplateParameter(ISymbol param) {
        ITypeInfo info;
        if (!param.isType(ITypeInfo.t_templateParameter)) {
            return false;
        }
        if (!CharArrayUtils.equals(this.getName(), ParserSymbolTable.EMPTY_NAME_ARRAY) && CharArrayUtils.equals(param.getName(), this.getName())) {
            return false;
        }
        return param.getTypeInfo().getTemplateParameterType() == ITypeInfo.t_typeName || param.getTypeInfo().getTemplateParameterType() == ITypeInfo.t_template || (info = param.getTypeInfo()).getPtrOperators().size() != 0 || info.getTemplateParameterType() != ITypeInfo.t_float && info.getTemplateParameterType() != ITypeInfo.t_double && info.getTemplateParameterType() != ITypeInfo.t_class && info.getTemplateParameterType() != ITypeInfo.t_struct && info.getTemplateParameterType() != ITypeInfo.t_union && info.getTemplateParameterType() != ITypeInfo.t_enumeration && info.getTemplateParameterType() != ITypeInfo.t_void;
    }

    private void modifyTemplateParameter(ISymbol param) {
        List ptrs = param.getPtrOperators();
        if (ptrs.size() > 0) {
            ITypeInfo.PtrOp op = (ITypeInfo.PtrOp)ptrs.get(0);
            if (op.getType() == ITypeInfo.PtrOp.t_array) {
                op.setType(ITypeInfo.PtrOp.t_pointer);
            }
        } else if (param.isType(ITypeInfo.t_type) && param.getTypeSymbol().isType(ITypeInfo.t_function)) {
            param.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        }
    }

    public boolean hasSpecializations() {
        return !this._specializations.isEmpty();
    }

    public void addExplicitSpecialization(ISymbol symbol, List args) throws ParserSymbolTableException {
        List actualArgs = TemplateEngine.verifyExplicitArguments(this, args, symbol);
        if (this._explicitSpecializations == ObjectMap.EMPTY_MAP) {
            this._explicitSpecializations = new ObjectMap(2);
        }
        ObjectMap specs = null;
        List key = null;
        int i = 0;
        while (i < this._explicitSpecializations.size()) {
            List list = (List)this._explicitSpecializations.keyAt(i);
            if (list.equals(args)) {
                key = list;
                break;
            }
            ++i;
        }
        if (key != null) {
            specs = (ObjectMap)this._explicitSpecializations.get(key);
        } else {
            specs = new ObjectMap(2);
            this._explicitSpecializations.put(new ArrayList(actualArgs), specs);
        }
        ISymbol found = null;
        try {
            if (symbol.isType(ITypeInfo.t_function) || symbol.isType(ITypeInfo.t_constructor)) {
                List params = ((IParameterizedSymbol)symbol).getParameterList();
                int size = params.size();
                ArrayList<ITypeInfo> fnArgs = new ArrayList<ITypeInfo>(size);
                int i2 = 0;
                while (i2 < size) {
                    fnArgs.add(((ISymbol)params.get(i2)).getTypeInfo());
                    ++i2;
                }
                found = this.getTemplatedSymbol().lookupMethodForDefinition(symbol.getName(), fnArgs);
            } else {
                found = this.getTemplatedSymbol().lookupMemberForDefinition(symbol.getName());
            }
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        if (found == null && CharArrayUtils.equals(this.getTemplatedSymbol().getName(), symbol.getName())) {
            found = this.getTemplatedSymbol();
            IContainerSymbol instance = this.findInstantiation(actualArgs);
            if (instance != null) {
                this._instantiations.remove(this.findArgumentsFor(instance));
            }
        }
        if (found != null) {
            if (found.isForwardDeclaration() && found.getForwardSymbol() == symbol) {
                found.setForwardSymbol(null);
            }
            while (found.isTemplateInstance()) {
                found = found.getInstantiatedSymbol();
            }
        }
        if (found != null) {
            symbol.setIsTemplateMember(true);
            symbol.setContainingSymbol(found.getContainingSymbol());
            specs.put(found, symbol);
        }
    }

    public void addSpecialization(ISpecializedSymbol spec) {
        if (this._specializations == Collections.EMPTY_LIST) {
            this._specializations = new ArrayList(4);
        }
        this._specializations.add(spec);
        spec.setContainingSymbol(this.getContainingSymbol());
        spec.setPrimaryTemplate(this);
    }

    public List getSpecializations() {
        return this._specializations;
    }

    public void addInstantiation(IContainerSymbol instance, List args) {
        ArrayList key = new ArrayList(args);
        if (this._instantiations == ObjectMap.EMPTY_MAP) {
            this._instantiations = new ObjectMap(2);
        }
        this._instantiations.put(key, instance);
    }

    public IContainerSymbol findInstantiation(List arguments) {
        if (this._instantiations == ObjectMap.EMPTY_MAP) {
            return null;
        }
        int size = this._instantiations.size();
        List args = null;
        int i = 0;
        while (i < size) {
            args = (List)this._instantiations.keyAt(i);
            if (args.equals(arguments)) {
                return (IContainerSymbol)this._instantiations.get(args);
            }
            ++i;
        }
        return null;
    }

    public List findArgumentsFor(IContainerSymbol instance) {
        if (instance == null || !instance.isTemplateInstance()) {
            return null;
        }
        int size = this._instantiations.size();
        int i = 0;
        while (i < size) {
            List args = (List)this._instantiations.keyAt(i);
            if (this._instantiations.get(args) == instance) {
                return args;
            }
            ++i;
        }
        return null;
    }

    public void removeInstantiation(IContainerSymbol symbol) {
        List args = this.findArgumentsFor(symbol);
        if (args != null) {
            this._instantiations.remove(args);
        }
    }

    public ObjectMap getDefinitionParameterMap() {
        return this._defnParameterMap;
    }

    protected void addToDefinitionParameterMap(ISymbol newSymbol, ObjectMap defnMap) {
        if (this._defnParameterMap == ObjectMap.EMPTY_MAP) {
            this._defnParameterMap = new ObjectMap(2);
        }
        this._defnParameterMap.put(newSymbol, defnMap);
    }

    public IDeferredTemplateInstance deferredInstance(List args) {
        return new DeferredTemplateInstance(this.getSymbolTable(), this, args);
    }

    public ObjectMap getExplicitSpecializations() {
        return this._explicitSpecializations;
    }

    public void registerDeferredInstatiation(Object obj0, Object obj1, ITemplateSymbol.DeferredKind kind, ObjectMap argMap) {
        if (this._deferredInstantiations == Collections.EMPTY_LIST) {
            this._deferredInstantiations = new ArrayList(8);
        }
        this._deferredInstantiations.add(new Object[]{obj0, obj1, kind, argMap});
    }

    public int getNumberDeferredInstantiations() {
        return this._deferredInstantiations.size();
    }

    protected void processDeferredInstantiations() throws ParserSymbolTableException {
        if (this._deferredInstantiations == Collections.EMPTY_LIST) {
            return;
        }
        if (this._processingDeferred) {
            return;
        }
        this._processingDeferred = true;
        int numDeferred = this._deferredInstantiations.size();
        int numProcessed = 0;
        int loopCount = 0;
        while (numDeferred > numProcessed) {
            int i = numProcessed;
            while (i < numDeferred) {
                Object[] objs = (Object[])this._deferredInstantiations.get(i);
                ITemplateSymbol.DeferredKind kind = (ITemplateSymbol.DeferredKind)objs[2];
                if (kind == ITemplateSymbol.DeferredKind.PARENT) {
                    DerivableContainerSymbol d = (DerivableContainerSymbol)objs[0];
                    d.instantiateDeferredParent((ISymbol)objs[1], this, (ObjectMap)objs[3]);
                } else if (kind == ITemplateSymbol.DeferredKind.RETURN_TYPE) {
                    ParameterizedSymbol p = (ParameterizedSymbol)objs[0];
                    p.instantiateDeferredReturnType((ISymbol)objs[1], this, (ObjectMap)objs[3]);
                } else if (kind == ITemplateSymbol.DeferredKind.TYPE_SYMBOL) {
                    TemplateEngine.instantiateDeferredTypeInfo((ITypeInfo)objs[0], this, (ObjectMap)objs[3]);
                }
                ++numProcessed;
                ++i;
            }
            numDeferred = this._deferredInstantiations.size();
            if (++loopCount <= 10) continue;
            this.discardDeferredInstantiations();
            this._processingDeferred = false;
            throw new ParserSymbolTableException(11);
        }
        this._processingDeferred = false;
    }

    private void discardDeferredInstantiations() {
        int size = this._deferredInstantiations.size();
        int i = 0;
        while (i < size) {
            Object[] objs = (Object[])this._deferredInstantiations.get(i);
            ITemplateSymbol.DeferredKind kind = (ITemplateSymbol.DeferredKind)objs[2];
            if (kind == ITemplateSymbol.DeferredKind.PARENT) {
                DerivableContainerSymbol d = (DerivableContainerSymbol)objs[0];
                d.discardDeferredParent((IDeferredTemplateInstance)objs[1], this, (ObjectMap)objs[3]);
            } else if (kind == ITemplateSymbol.DeferredKind.RETURN_TYPE) {
                ParameterizedSymbol p = (ParameterizedSymbol)objs[0];
                p.discardDeferredReturnType((ISymbol)objs[1], this, (ObjectMap)objs[3]);
            } else if (kind == ITemplateSymbol.DeferredKind.TYPE_SYMBOL) {
                TemplateEngine.discardDeferredTypeInfo((ITypeInfo)objs[0], this, (ObjectMap)objs[3]);
            }
            ++i;
        }
        this._deferredInstantiations.clear();
    }
}

