/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     */
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String errorMessage = null;
        if (part instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IResource resource = ToggleBreakpointAdapter.getResource((IWorkbenchPart)textEditor);
            if (resource == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_resource_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
            int lineNumber = bv.getValidLineBreakpointLocation(document, ((ITextSelection)selection).getStartLine());
            if (lineNumber == -1) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            String sourceHandle = this.getSourceHandle(input);
            ICLineBreakpoint breakpoint = CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                return;
            }
            CDIDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
            return;
        }
        if (!(part instanceof DisassemblyView)) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IEditorInput input = ((DisassemblyView)part).getInput();
        if (!(input instanceof DisassemblyEditorInput)) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
        int lineNumber = bv.getValidAddressBreakpointLocation(null, ((ITextSelection)selection).getStartLine());
        if (lineNumber == -1) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        String sourceHandle = this.getSourceHandle(input);
        long address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
        if (address == 0L) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ICAddressBreakpoint breakpoint = CDIDebugModel.addressBreakpointExists((String)sourceHandle, (IResource)resource, (long)address);
        if (breakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            return;
        }
        CDIDebugModel.createAddressBreakpoint((String)sourceHandle, (IResource)resource, (long)address, (boolean)true, (int)0, (String)"", (boolean)true);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        IEditorInput input;
        if (part instanceof DisassemblyView && (!((input = ((DisassemblyView)part).getInput()) instanceof DisassemblyEditorInput) || ((DisassemblyEditorInput)input).equals(DisassemblyEditorInput.EMPTY_EDITOR_INPUT))) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ss.getFirstElement() instanceof IFunction) {
            String functionName;
            IResource resource;
            IFunction function = (IFunction)ss.getFirstElement();
            String sourceHandle = this.getSourceHandle((IDeclaration)function);
            ICFunctionBreakpoint breakpoint = CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)(resource = this.getElementResource((IDeclaration)function)), (String)(functionName = this.getFunctionName(function)));
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                int lineNumber = -1;
                int charStart = -1;
                int charEnd = -1;
                try {
                    ISourceRange sourceRange = function.getSourceRange();
                    if (sourceRange != null && (charEnd = (charStart = sourceRange.getStartPos()) + sourceRange.getLength()) == 0) {
                        lineNumber = sourceRange.getStartLine();
                    }
                }
                catch (CModelException e) {
                    DebugPlugin.log((Throwable)e);
                }
                CDIDebugModel.createFunctionBreakpoint((String)sourceHandle, (IResource)resource, (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement() instanceof IFunction;
        }
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ss.getFirstElement() instanceof IVariable) {
            this.toggleVariableWatchpoint(part, (IVariable)ss.getFirstElement());
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement() instanceof IVariable;
        }
        return false;
    }

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)part.getAdapter((Class)clazz)) != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected static IResource getResource(IWorkbenchPart part) {
        IEditorInput editorInput;
        if (part instanceof IEditorPart && (editorInput = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String getSourceHandle(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getName();
        }
        if (input instanceof DisassemblyEditorInput) {
            return ((DisassemblyEditorInput)input).getModuleFile();
        }
        return "";
    }

    private void toggleVariableWatchpoint(IWorkbenchPart part, IVariable variable) throws CoreException {
        String expression;
        IResource resource;
        String sourceHandle = this.getSourceHandle((IDeclaration)variable);
        ICWatchpoint watchpoint = CDIDebugModel.watchpointExists((String)sourceHandle, (IResource)(resource = this.getElementResource((IDeclaration)variable)), (String)(expression = this.getVariableName(variable)));
        if (watchpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)watchpoint, true);
        } else {
            AddWatchpointDialog dlg = new AddWatchpointDialog(part.getSite().getShell(), true, false, expression);
            if (dlg.open() != 0) {
                return;
            }
            expression = dlg.getExpression();
            CDIDebugModel.createWatchpoint((String)sourceHandle, (IResource)resource, (boolean)dlg.getWriteAccess(), (boolean)dlg.getReadAccess(), (String)expression, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    private String getSourceHandle(IDeclaration declaration) {
        IPath path;
        ITranslationUnit tu = declaration.getTranslationUnit();
        if (tu != null && (path = tu.getPath()) != null) {
            return path.toOSString();
        }
        return "";
    }

    private IResource getElementResource(IDeclaration declaration) {
        return declaration.getUnderlyingResource();
    }

    private String getFunctionName(IFunction function) {
        String functionName = function.getElementName();
        StringBuffer name = new StringBuffer(functionName);
        if (functionName.indexOf("::") != -1 && functionName.indexOf(40) == -1) {
            String[] params = function.getParameterTypes();
            name.append('(');
            if (params.length == 0) {
                name.append("void");
            } else {
                int i = 0;
                while (i < params.length) {
                    name.append(params[i]);
                    if (i != params.length - 1) {
                        name.append(',');
                    }
                    ++i;
                }
            }
            name.append(')');
        }
        return name.toString();
    }

    private String getVariableName(IVariable variable) {
        return variable.getElementName();
    }
}

