/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public final class ScannerConfigUtil {
    private static Random sRandom = new Random();
    private static final QualifiedName discoveredScannerConfigFileNameProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "discoveredScannerConfigFileName");

    public static boolean scAddSymbolsList2SymbolEntryMap(Map sumSymbols, List symbols, boolean active) {
        boolean rc = false;
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            String key;
            String symbol = (String)i.next();
            String value = null;
            int index = symbol.indexOf("=");
            if (index != -1) {
                key = symbol.substring(0, index).trim();
                value = symbol.substring(index + 1).trim();
            } else {
                key = symbol.trim();
            }
            SymbolEntry sEntry = (SymbolEntry)sumSymbols.get(key);
            if (sEntry == null) {
                sEntry = new SymbolEntry(key, value, true);
                rc = true;
            } else {
                rc |= sEntry.add(value, active);
            }
            sumSymbols.put(key, sEntry);
        }
        return rc;
    }

    public static List scSymbolsSymbolEntryMap2List(Map sumSymbols, boolean active) {
        Set symbols = sumSymbols.entrySet();
        ArrayList rv = new ArrayList(symbols.size());
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            SymbolEntry sEntry = (SymbolEntry)i.next().getValue();
            if (active) {
                rv.addAll(sEntry.getActiveRaw());
                continue;
            }
            rv.addAll(sEntry.getRemovedRaw());
        }
        return rv;
    }

    public static Map scSymbolEntryMap2Map(Map sumSymbols) {
        HashMap<String, String> rv = new HashMap<String, String>();
        Iterator i = sumSymbols.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            SymbolEntry values = (SymbolEntry)sumSymbols.get(key);
            Iterator j = values.getValuesOnly(true).iterator();
            while (j.hasNext()) {
                String value = (String)j.next();
                rv.put(key, value);
            }
        }
        return rv;
    }

    public static boolean scAddSymbolString2SymbolEntryMap(Map symbols, String symbol, boolean active) {
        String key;
        boolean rc = false;
        String value = null;
        int index = symbol.indexOf("=");
        if (index != -1) {
            key = symbol.substring(0, index).trim();
            value = symbol.substring(index + 1).trim();
        } else {
            key = symbol.trim();
        }
        SymbolEntry sEntry = (SymbolEntry)symbols.get(key);
        if (sEntry == null) {
            sEntry = new SymbolEntry(key, value, active);
            rc = true;
        } else {
            rc |= sEntry.add(value, active);
        }
        symbols.put(key, sEntry);
        return rc;
    }

    public static boolean scAddSymbolEntryMap2SymbolEntryMap(Map result, Map addend) {
        boolean rc = false;
        Iterator i = addend.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (result.keySet().contains(key)) {
                SymbolEntry rSE = (SymbolEntry)result.get(key);
                SymbolEntry aSE = (SymbolEntry)addend.get(key);
                List activeValues = rSE.getActiveRaw();
                Iterator j = aSE.getActiveRaw().iterator();
                while (j.hasNext()) {
                    String aValue = (String)j.next();
                    if (activeValues.contains(aValue)) continue;
                    rSE.add(aValue, true);
                    rc |= true;
                }
                List removedValues = rSE.getRemovedRaw();
                Iterator j2 = aSE.getRemovedRaw().iterator();
                while (j2.hasNext()) {
                    String aValue = (String)j2.next();
                    if (removedValues.contains(aValue)) continue;
                    rSE.add(aValue, false);
                    rc |= true;
                }
                continue;
            }
            SymbolEntry aSymbolEntry = (SymbolEntry)addend.get(key);
            result.put(key, aSymbolEntry);
            rc |= true;
        }
        return rc;
    }

    public static String getSymbolKey(String symbol) {
        int index = symbol.indexOf(61);
        if (index != -1) {
            return symbol.substring(0, index);
        }
        return symbol;
    }

    public static String getSymbolValue(String symbol) {
        int index = symbol.indexOf(61);
        if (index != -1) {
            return symbol.substring(index + 1);
        }
        return null;
    }

    public static void removeSymbolEntryValue(String symbol, Map symbolEntryMap) {
        String key = ScannerConfigUtil.getSymbolKey(symbol);
        String value = ScannerConfigUtil.getSymbolValue(symbol);
        SymbolEntry se = (SymbolEntry)symbolEntryMap.get(key);
        if (se != null) {
            se.remove(value);
            if (se.numberOfValues() == 0) {
                symbolEntryMap.remove(key);
            }
        }
    }

    public static LinkedHashMap swapIncludePaths(LinkedHashMap sumPaths, int index1, int index2) {
        int size = sumPaths.size();
        if (index1 == index2 || index1 < 0 || index1 >= size || index2 < 0 || index2 >= size) {
            return sumPaths;
        }
        ArrayList pathKeyList = new ArrayList(sumPaths.keySet());
        String temp1 = (String)pathKeyList.get(index1);
        String temp2 = (String)pathKeyList.get(index2);
        pathKeyList.set(index1, temp2);
        pathKeyList.set(index2, temp1);
        LinkedHashMap newSumPaths = new LinkedHashMap(sumPaths.size());
        Iterator i = pathKeyList.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            newSumPaths.put(key, sumPaths.get(key));
        }
        return newSumPaths;
    }

    public static String[] tokenizeStringWithQuotes(String line, String quoteStyle) {
        ArrayList<String> allTokens = new ArrayList<String>();
        String[] tokens = line.split(quoteStyle);
        int i = 0;
        while (i < tokens.length) {
            if (i % 2 == 0) {
                String[] sTokens = tokens[i].split("\\s");
                int j = 0;
                while (j < sTokens.length) {
                    if (sTokens[j].length() > 0) {
                        allTokens.add(sTokens[j]);
                    }
                    ++j;
                }
            } else {
                allTokens.add(tokens[i]);
            }
            ++i;
        }
        return allTokens.toArray(new String[allTokens.size()]);
    }

    public static String[] iPathArray2StringArray(IPath[] paths) {
        String[] rv = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            rv[i] = paths[i].toString();
            ++i;
        }
        return rv;
    }

    public static IPath getDiscoveredScannerConfigStore(IProject project, boolean delete) {
        File file;
        String fileName = null;
        try {
            fileName = project.getPersistentProperty(discoveredScannerConfigFileNameProperty);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e.getStatus());
        }
        if (fileName == null) {
            fileName = String.valueOf(String.valueOf(sRandom.nextLong())) + ".sc";
            try {
                project.setPersistentProperty(discoveredScannerConfigFileNameProperty, fileName);
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e.getStatus());
            }
        }
        IPath path = MakeCorePlugin.getWorkingDirectory();
        path = path.append(fileName);
        if (delete && (file = path.toFile()).exists()) {
            file.delete();
        }
        return path;
    }
}

