/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;

public class MakeTarget
extends PlatformObject
implements IMakeTarget {
    private final MakeTargetManager manager;
    private String name;
    private String target;
    private String buildArguments;
    private IPath buildCommand;
    private boolean isDefaultBuildCmd;
    private boolean isStopOnError;
    private boolean runAllBuidlers = true;
    private String targetBuilderID;
    private IContainer container;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    MakeTarget(MakeTargetManager manager, IProject project, String targetBuilderID, String name) throws CoreException {
        this.manager = manager;
        this.targetBuilderID = targetBuilderID;
        this.name = name;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(project, manager.getBuilderID(targetBuilderID));
        this.buildCommand = info.getBuildCommand();
        this.buildArguments = info.getBuildArguments();
        this.isDefaultBuildCmd = info.isDefaultBuildCmd();
        this.isStopOnError = info.isStopOnError();
    }

    public void setContainer(IContainer container) {
        this.container = container;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetBuilderID() {
        return this.targetBuilderID;
    }

    public boolean isStopOnError() {
        return this.isStopOnError;
    }

    public void setStopOnError(boolean stopOnError) throws CoreException {
        this.isStopOnError = stopOnError;
        this.manager.updateTarget(this);
    }

    public boolean isDefaultBuildCmd() {
        return this.isDefaultBuildCmd;
    }

    public void setUseDefaultBuildCmd(boolean useDefault) throws CoreException {
        this.isDefaultBuildCmd = useDefault;
        this.manager.updateTarget(this);
    }

    public IPath getBuildCommand() {
        return this.buildCommand != null ? this.buildCommand : new Path("");
    }

    public void setBuildCommand(IPath command) throws CoreException {
        this.buildCommand = command;
        this.manager.updateTarget(this);
    }

    public String getBuildArguments() {
        return this.buildArguments != null ? this.buildArguments : "";
    }

    public void setBuildArguments(String arguments) throws CoreException {
        this.buildArguments = arguments;
        this.manager.updateTarget(this);
    }

    public IContainer getContainer() {
        return this.container;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MakeTarget) {
            MakeTarget other = (MakeTarget)obj;
            return (this.container != null ? this.container.equals((Object)other.getContainer()) : other.getContainer() == null) && this.name.equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode() * 17 + this.name.hashCode();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(IProgressMonitor monitor) throws CoreException {
        final IProject project = this.container.getProject();
        final String builderID = this.manager.getBuilderID(this.targetBuilderID);
        final HashMap infoMap = new HashMap();
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(infoMap, builderID);
        if (this.buildArguments != null) {
            info.setBuildArguments(this.buildArguments);
        }
        if (this.buildCommand != null) {
            info.setBuildCommand(this.buildCommand);
        }
        info.setUseDefaultBuildCmd(this.isDefaultBuildCmd);
        info.setStopOnError(this.isStopOnError);
        info.setFullBuildEnable(true);
        info.setFullBuildTarget(this.target);
        if (this.container != null) {
            info.setBuildLocation(this.container.getFullPath());
        }
        IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(project, builderID);
        info.setErrorParsers(projectInfo.getErrorParsers());
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (MakeTarget.this.runAllBuidlers) {
                    ICommand[] commands = project.getDescription().getBuildSpec();
                    monitor.beginTask("", commands.length);
                    int i = 0;
                    while (i < commands.length) {
                        if (commands[i].getBuilderName().equals(builderID)) {
                            project.build(6, builderID, (Map)infoMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            project.build(6, commands[i].getBuilderName(), commands[i].getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        ++i;
                    }
                    monitor.done();
                } else {
                    project.build(6, builderID, (Map)infoMap, monitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, monitor);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
    }

    public void setBuildTarget(String target) throws CoreException {
        this.target = target;
        this.manager.updateTarget(this);
    }

    public String getBuildTarget() {
        return this.target != null ? this.target : "";
    }

    public void setRunAllBuilders(boolean runAllBuilders) {
        this.runAllBuidlers = runAllBuilders;
    }

    public boolean runAllBuilders() {
        return this.runAllBuidlers;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.container.getProject();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this.container;
        }
        return super.getAdapter(adapter);
    }
}

