/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class MacroDeclarationPattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[] decodedSimpleName;

    public MacroDeclarationPattern(char[] name, int matchMode, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.simpleName = name;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (!(node instanceof IASTMacro) || !this.canAccept(limit)) {
            return 0;
        }
        char[] nodeName = ((IASTOffsetableNamedElement)node).getNameCharArray();
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName)) {
            return 0;
        }
        return 2;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                requestor.acceptMacroDeclaration(path, this.decodedSimpleName);
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int firstSlash = CharOperation.indexOf('/', word, 0);
        this.decodedSimpleName = CharOperation.subarray(word, firstSlash + 1, -1);
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestMacroPrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        return this.simpleName == null || this.matchesName(this.simpleName, this.decodedSimpleName);
    }
}

