/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFunctionType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIStructType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIVoidType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IncompleteType;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;

public class VariableObject
extends CObject
implements ICDIVariableObject {
    String castingType;
    int castingIndex;
    int castingLength;
    String name;
    int position;
    ICDIStackFrame frame;
    int stackdepth;
    String qualifiedName = null;
    String fullName = null;
    ICDIType type = null;
    String typename = null;
    String sizeof = null;

    public VariableObject(VariableObject obj) {
        super(obj.getTarget());
        this.name = obj.getName();
        this.fullName = obj.fullName;
        this.sizeof = obj.sizeof;
        this.type = obj.type;
        try {
            this.frame = obj.getStackFrame();
        }
        catch (CDIException cDIException) {}
        this.position = obj.getPosition();
        this.stackdepth = obj.getStackDepth();
        this.castingIndex = obj.getCastingArrayStart();
        this.castingLength = obj.getCastingArrayEnd();
        this.castingType = obj.getCastingType();
    }

    public VariableObject(ICDITarget target, String n, ICDIStackFrame stack, int pos, int depth) {
        this(target, n, null, stack, pos, depth);
    }

    public VariableObject(ICDITarget target, String n, String fn, ICDIStackFrame stack, int pos, int depth) {
        super(target);
        this.name = n;
        this.fullName = fn;
        this.frame = stack;
        this.position = pos;
        this.stackdepth = depth;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStackDepth() {
        return this.stackdepth;
    }

    public void setCastingArrayStart(int start) {
        this.castingIndex = start;
    }

    public int getCastingArrayStart() {
        return this.castingIndex;
    }

    public void setCastingArrayEnd(int end) {
        this.castingLength = end;
    }

    public int getCastingArrayEnd() {
        return this.castingLength;
    }

    public void setCastingType(String t) {
        this.castingType = t;
    }

    public String getCastingType() {
        return this.castingType;
    }

    public String encodeVariable() {
        String fn = this.getFullName();
        if (this.castingLength > 0 || this.castingIndex > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("*(");
            buffer.append('(').append(fn).append(')');
            if (this.castingIndex != 0) {
                buffer.append('+').append(this.castingIndex);
            }
            buffer.append(')');
            buffer.append('@').append(this.castingLength);
            fn = buffer.toString();
        } else if (this.castingType != null && this.castingType.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("((").append(this.castingType).append(')');
            buffer.append(fn).append(')');
            fn = buffer.toString();
        }
        return fn;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.getName();
        }
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public ICDIType getType() throws CDIException {
        if (this.type == null) {
            ICDITarget target = this.getTarget();
            Session session = (Session)target.getSession();
            SourceManager sourceMgr = (SourceManager)session.getSourceManager();
            String nametype = sourceMgr.getTypeName(this.getQualifiedName());
            try {
                this.type = sourceMgr.getType(target, nametype);
            }
            catch (CDIException cDIException) {
                try {
                    String ptype = sourceMgr.getDetailTypeName(nametype);
                    this.type = sourceMgr.getType(target, ptype);
                }
                catch (CDIException cDIException2) {
                    try {
                        String ptype = sourceMgr.getDetailTypeName(this.getQualifiedName());
                        this.type = sourceMgr.getType(target, ptype);
                    }
                    catch (CDIException cDIException3) {}
                }
            }
            if (this.type == null) {
                this.type = new IncompleteType(target, nametype);
            }
        }
        return this.type;
    }

    public int sizeof() throws CDIException {
        if (this.sizeof == null) {
            ICDITarget target = this.getTarget();
            Session session = (Session)target.getSession();
            MISession mi = session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            String exp = "sizeof(" + this.getTypeName() + ")";
            MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(exp);
            try {
                mi.postCommand(evaluate);
                MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.VariableObject.Target_not_responding"));
                }
                this.sizeof = info.getExpression();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        if (this.sizeof != null) {
            try {
                return Integer.parseInt(this.sizeof);
            }
            catch (NumberFormatException e) {
                throw new CDIException(e.getMessage());
            }
        }
        return 0;
    }

    public boolean isEditable() throws CDIException {
        ICDIType t = this.getType();
        return !(t instanceof ICDIArrayType) && !(t instanceof ICDIStructType) && !(t instanceof ICDIVoidType) && !(t instanceof ICDIFunctionType);
    }

    public ICDIStackFrame getStackFrame() throws CDIException {
        return this.frame;
    }

    public String getTypeName() throws CDIException {
        if (this.typename == null) {
            ICDIType theType = this.getType();
            this.typename = theType.getTypeName();
        }
        return this.typename;
    }

    public boolean hasChildren() throws CDIException {
        ICDIType t = this.getType();
        if (t instanceof ICDIReferenceType) {
            t = ((ICDIReferenceType)t).getComponentType();
        }
        if (t instanceof ICDIArrayType || t instanceof ICDIStructType) {
            return true;
        }
        if (t instanceof ICDIPointerType) {
            ICDIType sub = ((ICDIPointerType)t).getComponentType();
            return !(sub instanceof ICDIVoidType);
        }
        return false;
    }

    public String getQualifiedName() throws CDIException {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.encodeVariable();
        }
        return this.qualifiedName;
    }

    public boolean equals(ICDIVariableObject varObj) {
        VariableObject var;
        if (varObj instanceof VariableObject && (var = (VariableObject)varObj).getName().equals(this.getName()) && var.getCastingArrayStart() == this.getCastingArrayStart() && var.getCastingArrayEnd() == this.getCastingArrayEnd() && (var.getCastingType() == null && this.getCastingType() == null || var.getCastingType() != null && this.getCastingType() != null && var.getCastingType().equals(this.getCastingType()))) {
            ICDIStackFrame varFrame = null;
            ICDIStackFrame ourFrame = null;
            try {
                varFrame = var.getStackFrame();
                ourFrame = this.getStackFrame();
            }
            catch (CDIException cDIException) {}
            if (ourFrame == null && varFrame == null) {
                return true;
            }
            if (varFrame != null && ourFrame != null && varFrame.equals(ourFrame) && var.getStackDepth() == this.getStackDepth() && var.getPosition() == this.getPosition()) {
                return true;
            }
        }
        return super.equals(varObj);
    }
}

