/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Watchpoint
extends Breakpoint
implements ICDIWatchpoint {
    int watchType;
    String what;

    public Watchpoint(BreakpointManager m, String expression, int type, int wType, ICDICondition cond) {
        super(m, type, null, cond, "");
        this.watchType = wType;
        this.what = expression;
    }

    public Watchpoint(BreakpointManager m, MIBreakpoint miBreak) {
        super(m, miBreak);
    }

    public String getWatchExpression() throws CDIException {
        MIBreakpoint miPoint = this.getMIBreakpoint();
        if (miPoint != null) {
            return this.getMIBreakpoint().getWhat();
        }
        return this.what;
    }

    public boolean isReadType() {
        MIBreakpoint miPoint = this.getMIBreakpoint();
        if (miPoint != null) {
            return this.getMIBreakpoint().isReadWatchpoint() || this.getMIBreakpoint().isAccessWatchpoint();
        }
        return (this.watchType & 2) == 2;
    }

    public boolean isWriteType() {
        MIBreakpoint miPoint = this.getMIBreakpoint();
        if (miPoint != null) {
            return this.getMIBreakpoint().isAccessWatchpoint() || this.getMIBreakpoint().isWriteWatchpoint();
        }
        return (this.watchType & 1) == 1;
    }
}

