/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;

public class CGlobalVariableManager
implements ICGlobalVariableManager {
    private CDebugTarget fDebugTarget;
    private ArrayList fGlobals = new ArrayList(10);

    public CGlobalVariableManager(CDebugTarget target) {
        this.setDebugTarget(target);
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDebugTarget(CDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    public ICGlobalVariable[] getGlobals() {
        return this.fGlobals.toArray(new ICGlobalVariable[this.fGlobals.size()]);
    }

    public void addGlobals(IGlobalVariableDescriptor[] descriptors) throws DebugException {
        MultiStatus ms = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 0, "", null);
        ArrayList<ICGlobalVariable> globals = new ArrayList<ICGlobalVariable>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            try {
                globals.add(CDIDebugModel.createGlobalVariable(this.getDebugTarget(), descriptors[i]));
            }
            catch (DebugException e) {
                ms.add(e.getStatus());
            }
            ++i;
        }
        if (globals.size() > 0) {
            ArrayList arrayList = this.fGlobals;
            synchronized (arrayList) {
                this.fGlobals.addAll(globals);
            }
            this.getDebugTarget().fireChangeEvent(512);
        }
        if (!ms.isOK()) {
            throw new DebugException((IStatus)ms);
        }
    }

    public void removeGlobals(ICGlobalVariable[] globals) {
        ArrayList arrayList = this.fGlobals;
        synchronized (arrayList) {
            this.fGlobals.removeAll(Arrays.asList(globals));
        }
        int i = 0;
        while (i < globals.length) {
            globals[i].dispose();
            ++i;
        }
        this.getDebugTarget().fireChangeEvent(512);
    }

    public void removeAllGlobals() {
        ICGlobalVariable[] globals = new ICGlobalVariable[]{};
        ArrayList arrayList = this.fGlobals;
        synchronized (arrayList) {
            globals = this.fGlobals.toArray(new ICGlobalVariable[this.fGlobals.size()]);
            this.fGlobals.clear();
        }
        int i = 0;
        while (i < globals.length) {
            ((CVariable)((Object)globals[i])).dispose();
            ++i;
        }
        this.getDebugTarget().fireChangeEvent(512);
    }

    public void dispose() {
        Iterator it = this.fGlobals.iterator();
        while (it.hasNext()) {
            ((ICGlobalVariable)it.next()).dispose();
        }
        this.fGlobals.clear();
    }

    public IGlobalVariableDescriptor[] getDescriptors() {
        return null;
    }
}

