/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.actions.RedoRefactoringAction;
import org.eclipse.cdt.internal.ui.refactoring.actions.RenameRefactoringAction;
import org.eclipse.cdt.internal.ui.refactoring.actions.UndoRefactoringAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class RefactoringActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.cdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String REFACTOR_RENAME = "org.eclipse.cdt.ui.actions.refactor.RenameAction";
    public static final String REFACTOR_UNDO = "org.eclipse.cdt.ui.actions.refactor.UndoAction";
    public static final String REFACTOR_REDO = "org.eclipse.cdt.ui.actions.refactor.RedoAction";
    private IWorkbenchSite fSite;
    private CEditor fEditor;
    private String fGroupName = "group.reorganize";
    private RenameRefactoringAction fRenameAction;
    private RedoRefactoringAction fRedoAction;
    private UndoRefactoringAction fUndoAction;
    private List fEditorActions;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactoringActionGroup(IViewPart part, String groupName) {
        this((IWorkbenchSite)part.getSite(), groupName);
    }

    public RefactoringActionGroup(Page page, String groupName) {
        this((IWorkbenchSite)page.getSite(), groupName);
    }

    public RefactoringActionGroup(CEditor editor, String groupName) {
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        if (groupName != null && groupName.length() > 0) {
            this.fGroupName = groupName;
        }
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fEditorActions = new ArrayList(3);
        this.fRenameAction = new RenameRefactoringAction(editor);
        this.fRenameAction.update(selection);
        editor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fEditorActions.add(this.fRenameAction);
        this.fUndoAction = new UndoRefactoringAction(editor);
        this.fUndoAction.update(selection);
        editor.setAction("UndoAction", (IAction)this.fUndoAction);
        this.fEditorActions.add(this.fUndoAction);
        this.fRedoAction = new RedoRefactoringAction(editor);
        this.fRedoAction.update(selection);
        editor.setAction("RedoAction", (IAction)this.fRedoAction);
        this.fEditorActions.add(this.fRedoAction);
    }

    public RefactoringActionGroup(IWorkbenchSite site, String groupName) {
        this.fSite = site;
        if (groupName != null && groupName.length() > 0) {
            this.fGroupName = groupName;
        }
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fRenameAction = new RenameRefactoringAction(site);
        RefactoringActionGroup.initAction(this.fRenameAction, provider, selection);
        this.fUndoAction = new UndoRefactoringAction(site);
        RefactoringActionGroup.initAction(this.fUndoAction, provider, selection);
        this.fRedoAction = new RedoRefactoringAction(site);
        RefactoringActionGroup.initAction(this.fRedoAction, provider, selection);
    }

    private static void initAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(REFACTOR_RENAME, (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(REFACTOR_UNDO, (IAction)this.fUndoAction);
        actionBars.setGlobalActionHandler(REFACTOR_REDO, (IAction)this.fRedoAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (this.fRenameAction != null) {
            this.disposeAction(this.fRenameAction, provider);
            this.fRenameAction = null;
        }
        if (this.fUndoAction != null) {
            this.disposeAction(this.fUndoAction, provider);
            this.fUndoAction.dispose();
            this.fUndoAction = null;
        }
        if (this.fRedoAction != null) {
            this.disposeAction(this.fRedoAction, provider);
            this.fRedoAction.dispose();
            this.fRedoAction = null;
        }
        if (this.fEditorActions != null) {
            this.fEditorActions.clear();
            this.fEditorActions = null;
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        provider.removeSelectionChangedListener(action);
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        MenuManager refactorSubmenu = new MenuManager(ActionMessages.getString("RefactorMenu.label"), MENU_ID);
        if (this.fEditor != null) {
            ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            Iterator iter = this.fEditorActions.iterator();
            while (iter.hasNext()) {
                SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
                action.update((ISelection)textSelection);
            }
            refactorSubmenu.removeAll();
            if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) == 0) {
                refactorSubmenu.add((IAction)this.fNoActionAvailable);
            }
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        } else if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fUndoAction);
        return added += this.addAction(refactorSubmenu, (IAction)this.fRedoAction);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private ICElement getEditorInput() {
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return CUIPlugin.getDefault().getDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(RefactoringMessages.getString("RefactorActionGroup.no_refactoring_available"));
        }
    }
}

