/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;

public class ASTAbstractDeclaration
implements IASTAbstractDeclaration {
    private final boolean isVolatile;
    private final List parms;
    private final boolean isConst;
    private final IASTTypeSpecifier typeSpecifier;
    private final List pointerOperators;
    private final List arrayModifiers;
    private final ASTPointerOperator pointerOperator;

    public ASTAbstractDeclaration(boolean isConst, boolean isVolatile, IASTTypeSpecifier typeSpecifier, List pointerOperators, List arrayModifiers, List parameters, ASTPointerOperator pointerOp) {
        this.isConst = isConst;
        this.typeSpecifier = typeSpecifier;
        this.pointerOperators = pointerOperators;
        this.arrayModifiers = arrayModifiers;
        this.parms = parameters;
        this.pointerOperator = pointerOp;
        this.isVolatile = isVolatile;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return this.typeSpecifier;
    }

    public Iterator getPointerOperators() {
        if (this.pointerOperators == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.pointerOperators.iterator();
    }

    public List getPointerOperatorsList() {
        if (this.pointerOperators == null) {
            return Collections.EMPTY_LIST;
        }
        return this.pointerOperators;
    }

    public int getNumPointerOperators() {
        if (this.pointerOperators == null) {
            return 0;
        }
        return this.pointerOperators.size();
    }

    public Iterator getArrayModifiers() {
        if (this.arrayModifiers == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.arrayModifiers.iterator();
    }

    public List getArrayModifiersList() {
        if (this.arrayModifiers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.arrayModifiers;
    }

    public int getNumArrayModifiers() {
        if (this.arrayModifiers == null) {
            return 0;
        }
        return this.arrayModifiers.size();
    }

    public Iterator getParameters() {
        if (this.parms == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.parms.iterator();
    }

    public ASTPointerOperator getPointerToFunctionOperator() {
        return this.pointerOperator;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        List arrayMods = this.getArrayModifiersList();
        int size = arrayMods.size();
        int i = 0;
        while (i < size) {
            ((IASTArrayModifier)arrayMods.get(i)).acceptElement(requestor, manager);
            ++i;
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }
}

