/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTVariable
extends ASTDeclaration
implements IASTVariable {
    private IASTExpression constructorExpression;
    private final boolean isAuto;
    private final IASTInitializerClause initializerClause;
    private final IASTExpression bitfieldExpression;
    private final IASTAbstractDeclaration abstractDeclaration;
    private final boolean isMutable;
    private final boolean isExtern;
    private final boolean isRegister;
    private final boolean isStatic;
    private final char[] name;
    private final ASTQualifiedNamedElement qualifiedName;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTVariable(IASTScope scope, char[] name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int startLine, int nameOffset, int nameEndOffset, int nameLine, IASTExpression constructorExpression, char[] filename) {
        super(scope);
        this.isAuto = isAuto;
        this.initializerClause = initializerClause;
        this.bitfieldExpression = bitfieldExpression;
        this.abstractDeclaration = abstractDeclaration;
        this.isMutable = isMutable;
        this.isExtern = isExtern;
        this.isRegister = isRegister;
        this.isStatic = isStatic;
        this.name = name;
        this.constructorExpression = constructorExpression;
        this.qualifiedName = new ASTQualifiedNamedElement(scope, name);
        this.setStartingOffsetAndLineNumber(startingOffset, startLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        if (initializerClause != null) {
            initializerClause.setOwnerVariableDeclaration(this);
        }
        this.fn = filename;
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isExtern() {
        return this.isExtern;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public IASTAbstractDeclaration getAbstractDeclaration() {
        return this.abstractDeclaration;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public boolean isBitfield() {
        return this.bitfieldExpression != null;
    }

    public IASTExpression getBitfieldExpression() {
        return this.bitfieldExpression;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptVariable(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.name;
    }
}

