/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class ClassDeclarationPattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[][] qualifications;
    protected ASTClassKind classKind;
    protected ICSearchConstants.SearchFor searchFor;
    protected char[] decodedSimpleName;
    private char[][] decodedContainingTypes;
    protected char decodedType;
    protected boolean isForward;

    public ClassDeclarationPattern(char[] name, char[][] containers, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limit, int mode, boolean caseSensitive, boolean isForward) {
        super(mode, caseSensitive, limit);
        this.isForward = isForward;
        char[] cArray = this.simpleName = caseSensitive ? name : CharOperation.toLowerCase(name);
        if (caseSensitive || containers == null) {
            this.qualifications = containers;
        } else {
            int len = containers.length;
            this.qualifications = new char[len][];
            int i = 0;
            while (i < len) {
                this.qualifications[i] = CharOperation.toLowerCase(containers[i]);
                ++i;
            }
        }
        this.searchFor = searchFor;
        this.classKind = searchFor == ICSearchConstants.CLASS || searchFor == ICSearchConstants.FWD_CLASS ? ASTClassKind.CLASS : (searchFor == ICSearchConstants.STRUCT || searchFor == ICSearchConstants.FWD_STRUCT ? ASTClassKind.STRUCT : (searchFor == ICSearchConstants.ENUM ? ASTClassKind.ENUM : (searchFor == ICSearchConstants.UNION || searchFor == ICSearchConstants.FWD_UNION ? ASTClassKind.UNION : null)));
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        char[][] qualName;
        if (!(node instanceof IASTClassSpecifier || node instanceof IASTElaboratedTypeSpecifier || node instanceof IASTTypedefDeclaration || node instanceof IASTEnumerationSpecifier)) {
            return 0;
        }
        if (this.searchFor != ICSearchConstants.TYPE && this.searchFor == ICSearchConstants.TYPEDEF ^ node instanceof IASTTypedefDeclaration) {
            return 0;
        }
        if (!this.canAccept(limit)) {
            return 0;
        }
        if (node instanceof IASTElaboratedTypeSpecifier && !this.isForward || node instanceof IASTClassSpecifier && this.isForward) {
            return 0;
        }
        char[] nodeName = null;
        if (node instanceof IASTElaboratedTypeSpecifier) {
            nodeName = ((IASTElaboratedTypeSpecifier)node).getNameCharArray();
        } else if (node instanceof IASTOffsetableNamedElement) {
            nodeName = ((IASTOffsetableNamedElement)node).getNameCharArray();
        } else {
            return 0;
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName)) {
            return 0;
        }
        if (node instanceof IASTQualifiedNameElement && !this.matchQualifications(this.qualifications, qualName = ((IASTQualifiedNameElement)node).getFullyQualifiedNameCharArrays(), true)) {
            return 0;
        }
        if (this.classKind != null) {
            if (node instanceof IASTClassSpecifier) {
                IASTClassSpecifier clsSpec = (IASTClassSpecifier)node;
                return this.classKind == clsSpec.getClassKind() ? 2 : 0;
            }
            if (node instanceof IASTEnumerationSpecifier) {
                return this.classKind == ASTClassKind.ENUM ? 2 : 0;
            }
            if (node instanceof IASTElaboratedTypeSpecifier) {
                IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)node;
                return this.classKind == elabTypeSpec.getClassKind() ? 2 : 0;
            }
        }
        return 2;
    }

    public char[] getName() {
        return this.simpleName;
    }

    public char[][] getContainingTypes() {
        return this.qualifications;
    }

    public ASTClassKind getKind() {
        return this.classKind;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, ICSearchScope scope) throws IOException {
        boolean isClass = this.decodedType == 'C';
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                if (isClass) {
                    requestor.acceptClassDeclaration(path, this.decodedSimpleName, this.decodedContainingTypes);
                } else {
                    requestor.acceptClassDeclaration(path, this.decodedSimpleName, this.decodedContainingTypes);
                }
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedType = '\u0000';
        this.decodedSimpleName = null;
        this.decodedContainingTypes = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int firstSlash = CharOperation.indexOf('/', word, 0);
        this.decodedType = word[firstSlash + 1];
        int slash = CharOperation.indexOf('/', word, (firstSlash += 2) + 1);
        this.decodedSimpleName = CharOperation.subarray(word, firstSlash + 1, slash);
        if (slash != -1 && slash + 1 < size) {
            char[][] temp = CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, size));
            this.decodedContainingTypes = new char[temp.length][];
            int i = 0;
            while (i < temp.length) {
                this.decodedContainingTypes[i] = temp[temp.length - i - 1];
                ++i;
            }
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestTypePrefix(this.searchFor, this.getLimitTo(), this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.classKind == null) {
            if (this.searchFor == ICSearchConstants.TYPEDEF && this.decodedType != 'T') {
                return false;
            }
            if (this.decodedType == 'V') {
                return false;
            }
        } else if (this.classKind == ASTClassKind.CLASS ? this.decodedType != 'C' && this.decodedType != 'G' : (this.classKind == ASTClassKind.STRUCT ? this.decodedType != 'S' && this.decodedType != 'H' : (this.classKind == ASTClassKind.UNION ? this.decodedType != 'U' && this.decodedType != 'I' : this.classKind == ASTClassKind.ENUM && this.decodedType != 'E'))) {
            return false;
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedContainingTypes);
    }
}

