/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.wizards;

import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.SWTUtil;
import org.eclipse.cdt.debug.internal.ui.wizards.WizardMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddDirectorySourceLocationBlock {
    private Composite fControl = null;
    private Text fLocationText = null;
    private Text fAssociationText = null;
    private Button fAssocitedCheckButton = null;
    private Button fSearchSubfoldersButton = null;
    private Shell fShell = null;
    private IPath fInitialAssosciationPath = null;

    public AddDirectorySourceLocationBlock(IPath initialAssosciationPath) {
        this.fInitialAssosciationPath = initialAssosciationPath;
    }

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fControl = new Composite(parent, 0);
        this.fControl.setLayout((Layout)new GridLayout());
        this.fControl.setLayoutData((Object)new GridData(768));
        this.fControl.setFont(JFaceResources.getDialogFont());
        this.createLocationControls(this.fControl);
        this.createAssociationControls(this.fControl);
        this.createSearchSubfoldersButton(this.fControl);
        this.setInitialAssociationPath();
    }

    private void setInitialAssociationPath() {
        this.fAssociationText.setEnabled(this.fInitialAssosciationPath != null);
        this.fAssocitedCheckButton.setSelection(this.fInitialAssosciationPath != null);
        if (this.fInitialAssosciationPath != null) {
            this.fAssociationText.setText(this.fInitialAssosciationPath.toOSString());
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void createLocationControls(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Label label = new Label(parent, 0);
        label.setText(WizardMessages.getString("AddDirectorySourceLocationBlock.0"));
        label.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.widthHint = converter.convertWidthInCharsToPixels(70);
        composite.setLayoutData((Object)data);
        this.fLocationText = new Text(composite, 2052);
        this.fLocationText.setLayoutData((Object)new GridData(768));
        Button button = this.createButton(composite, WizardMessages.getString("AddDirectorySourceLocationBlock.1"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddDirectorySourceLocationBlock.this.selectLocation();
            }
        });
    }

    protected void selectLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setMessage(WizardMessages.getString("AddDirectorySourceLocationBlock.2"));
        String result = dialog.open();
        if (result != null) {
            this.fLocationText.setText(result);
        }
    }

    protected void createAssociationControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.fAssocitedCheckButton = new Button(composite, 32);
        this.fAssocitedCheckButton.setText(WizardMessages.getString("AddDirectorySourceLocationBlock.3"));
        this.fAssociationText = new Text(composite, 2052);
        this.fAssociationText.setLayoutData((Object)new GridData(768));
        this.fAssocitedCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddDirectorySourceLocationBlock.this.associationSelectionChanged();
            }
        });
    }

    protected void associationSelectionChanged() {
        boolean checked = this.fAssocitedCheckButton.getSelection();
        this.fAssociationText.setEnabled(checked);
        if (!checked) {
            this.fAssociationText.setText("");
        }
    }

    protected void createSearchSubfoldersButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.fSearchSubfoldersButton = new Button(composite, 32);
        this.fSearchSubfoldersButton.setText(WizardMessages.getString("AddDirectorySourceLocationBlock.4"));
    }

    protected Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(3);
        button.setLayoutData((Object)data);
        SWTUtil.setButtonDimensionHint(button);
        button.setFont(parent.getFont());
        return button;
    }

    public String getLocationPath() {
        return this.fLocationText.getText().trim();
    }

    public String getAssociationPath() {
        if (this.fAssocitedCheckButton.getSelection()) {
            return this.fAssociationText.getText().trim();
        }
        return "";
    }

    public boolean searchSubfolders() {
        return this.fSearchSubfoldersButton != null ? this.fSearchSubfoldersButton.getSelection() : false;
    }

    public IDirectorySourceLocation getSourceLocation() {
        if (this.isLocationPathValid()) {
            Path association = this.isAssociationPathValid() ? new Path(this.getAssociationPath()) : null;
            return SourceLookupFactory.createDirectorySourceLocation((IPath)new Path(this.getLocationPath()), (IPath)association, (boolean)this.searchSubfolders());
        }
        return null;
    }

    public void addDirectoryModifyListener(ModifyListener listener) {
        if (this.fLocationText != null) {
            this.fLocationText.addModifyListener(listener);
        }
    }

    public void addAssociationModifyListener(ModifyListener listener) {
        if (this.fAssociationText != null) {
            this.fAssociationText.addModifyListener(listener);
        }
    }

    public void removeDirectoryModifyListener(ModifyListener listener) {
        if (this.fLocationText != null) {
            this.fLocationText.removeModifyListener(listener);
        }
    }

    public void removeAssociationModifyListener(ModifyListener listener) {
        if (this.fAssociationText != null) {
            this.fAssociationText.removeModifyListener(listener);
        }
    }

    private boolean isLocationPathValid() {
        if (this.fLocationText != null && Path.EMPTY.isValidPath(this.fLocationText.getText().trim())) {
            Path path = new Path(this.fLocationText.getText().trim());
            return path.toFile().exists() && path.toFile().isAbsolute();
        }
        return false;
    }

    public boolean isAssociationPathValid() {
        String pathString = this.getAssociationPath();
        if (pathString.length() > 0) {
            return Path.EMPTY.isValidPath(pathString);
        }
        return true;
    }
}

