/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIInferiorExitEvent
extends MIDestroyedEvent {
    int code = 0;
    MIExecAsyncOutput exec = null;
    MIResultRecord rr = null;

    public MIInferiorExitEvent(int token) {
        super(token);
    }

    public MIInferiorExitEvent(MIExecAsyncOutput async) {
        super(async.getToken());
        this.exec = async;
        this.parse();
    }

    public MIInferiorExitEvent(MIResultRecord record) {
        super(record.getToken());
        this.rr = record;
        this.parse();
    }

    public int getExitCode() {
        return this.code;
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("exit-code")) {
                    try {
                        this.code = Integer.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
    }
}

