/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BinaryRunner {
    ICProject cproject;
    Job runner;

    public BinaryRunner(IProject prj) {
        this.cproject = CModelManager.getDefault().create(prj);
    }

    public void start() {
        String taskName = CCorePlugin.getResourceString("CoreModel.BinaryRunner.Binary_Search_Thread");
        this.runner = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                if (BinaryRunner.this.cproject == null || monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    BinaryContainer vbin = (BinaryContainer)BinaryRunner.this.cproject.getBinaryContainer();
                    ArchiveContainer vlib = (ArchiveContainer)BinaryRunner.this.cproject.getArchiveContainer();
                    vlib.removeChildren();
                    vbin.removeChildren();
                    BinaryRunner.this.cproject.getProject().accept((IResourceVisitor)new Visitor(BinaryRunner.this, monitor));
                    BinaryRunner.this.fireEvents(BinaryRunner.this.cproject, vbin);
                    BinaryRunner.this.fireEvents(BinaryRunner.this.cproject, vlib);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        this.runner.schedule();
    }

    public void waitIfRunning() {
        if (this.runner != null) {
            try {
                this.runner.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.getState() == 4) {
            this.runner.cancel();
        }
    }

    void fireEvents(ICProject cproject, Parent container) {
        try {
            ICElement[] children = container.getChildren();
            if (children.length > 0) {
                CModelManager factory = CModelManager.getDefault();
                CModel root = factory.getCModel();
                CElementDelta cdelta = new CElementDelta(root);
                cdelta.added(cproject);
                cdelta.added(container);
                int i = 0;
                while (i < children.length) {
                    cdelta.added(children[i]);
                    ++i;
                }
                factory.registerCModelDelta(cdelta);
                factory.fire(1);
            }
        }
        catch (CModelException cModelException) {}
    }

    void addChildIfBinary(IFile file) {
        IBinaryParser.IBinaryFile bin;
        CModelManager factory = CModelManager.getDefault();
        if (!CoreModel.isTranslationUnit(file) && (bin = factory.createBinaryFile(file)) != null) {
            factory.create(file, bin, null);
        }
    }

    class Visitor
    implements IResourceVisitor {
        private BinaryRunner vRunner;
        private IProgressMonitor vMonitor;

        public Visitor(BinaryRunner r, IProgressMonitor monitor) {
            this.vRunner = r;
            this.vMonitor = monitor;
        }

        public boolean visit(IResource res) throws CoreException {
            if (this.vMonitor.isCanceled()) {
                return false;
            }
            if (BinaryRunner.this.cproject.isOnOutputEntry(res) && res instanceof IFile) {
                if (this.vRunner != null) {
                    this.vRunner.addChildIfBinary((IFile)res);
                }
                return false;
            }
            return true;
        }
    }
}

