/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtil {
    private static boolean fGotOS = false;
    private static boolean fIsWindows = false;

    public static boolean isWindowsSystem() {
        if (!fGotOS) {
            String os = System.getProperty("os.name");
            if (os != null && os.startsWith("Win")) {
                fIsWindows = true;
            }
            fGotOS = true;
        }
        return fIsWindows;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            return workspace.getRoot();
        }
        return null;
    }

    public static IPath getCanonicalPath(String fullPath) {
        File file = new File(fullPath);
        try {
            String canonPath = file.getCanonicalPath();
            return new Path(canonPath);
        }
        catch (IOException iOException) {
            return new Path(fullPath);
        }
    }

    public static IPath getCanonicalPath(IPath fullPath) {
        return PathUtil.getCanonicalPath(fullPath.toString());
    }

    public static IPath getWorkspaceRelativePath(IPath fullPath) {
        IPath workspaceLocation;
        IWorkspaceRoot workspaceRoot = PathUtil.getWorkspaceRoot();
        if (workspaceRoot != null && (workspaceLocation = workspaceRoot.getLocation()) != null && workspaceLocation.isPrefixOf(fullPath)) {
            int segments = fullPath.matchingFirstSegments(workspaceLocation);
            IPath relPath = fullPath.setDevice(null).removeFirstSegments(segments);
            return new Path("").addTrailingSeparator().append(relPath);
        }
        return fullPath;
    }

    public static IPath getProjectRelativePath(IPath fullPath, IProject project) {
        IPath projectPath = project.getFullPath();
        if (projectPath.isPrefixOf(fullPath)) {
            return fullPath.removeFirstSegments(projectPath.segmentCount());
        }
        projectPath = project.getLocation();
        if (projectPath.isPrefixOf(fullPath)) {
            return fullPath.removeFirstSegments(projectPath.segmentCount());
        }
        return PathUtil.getWorkspaceRelativePath(fullPath);
    }

    public static IPath getWorkspaceRelativePath(String fullPath) {
        return PathUtil.getWorkspaceRelativePath((IPath)new Path(fullPath));
    }

    public static IPath getProjectRelativePath(String fullPath, IProject project) {
        return PathUtil.getProjectRelativePath((IPath)new Path(fullPath), project);
    }

    public static IPath getRawLocation(IPath wsRelativePath) {
        IPath workspaceLocation;
        IWorkspaceRoot workspaceRoot = PathUtil.getWorkspaceRoot();
        if (workspaceRoot != null && wsRelativePath != null && (workspaceLocation = workspaceRoot.getLocation()) != null && !workspaceLocation.isPrefixOf(wsRelativePath)) {
            return workspaceLocation.append(wsRelativePath);
        }
        return wsRelativePath;
    }
}

