/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.cdt.core.internal.filetype.Argument;

public class CFileType
implements ICFileType {
    private ICLanguage fLang;
    private String fId;
    private String fName;
    private int fType;

    public CFileType(String id, ICLanguage language, String name, int type) {
        Argument.check(id);
        Argument.check(language);
        Argument.check(name);
        Argument.check(type, 0, 2);
        this.fId = id;
        this.fLang = language;
        this.fName = name;
        this.fType = type;
    }

    public String getId() {
        return this.fId;
    }

    public ICLanguage getLanguage() {
        return this.fLang;
    }

    public String getName() {
        return this.fName;
    }

    public int getType() {
        return this.fType;
    }

    public boolean isSource() {
        return 1 == this.fType;
    }

    public boolean isHeader() {
        return 2 == this.fType;
    }

    public boolean isTranslationUnit() {
        return this.isSource() || this.isHeader();
    }

    public boolean equals(Object object) {
        boolean eq;
        if (!(object instanceof ICFileType)) {
            return false;
        }
        ICFileType rhs = (ICFileType)object;
        boolean bl = eq = this.fType == rhs.getType();
        if (eq) {
            eq = this.fId.equals(rhs.getId());
        }
        if (eq) {
            eq = this.fLang.equals(rhs.getLanguage());
        }
        if (eq) {
            eq = this.fName.equals(rhs.getName());
        }
        return eq;
    }
}

