/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class CPElementGroup {
    private CPElement parent;
    private final int kind;
    private IResource resource;
    private Map childrenListMap;
    private List childrenList;

    public CPElementGroup(IResource resource) {
        this.kind = -1;
        this.resource = resource;
        this.childrenListMap = new HashMap(2);
    }

    public CPElementGroup(CPElement parent, int kind) {
        this.parent = parent;
        this.kind = kind;
        this.childrenList = new ArrayList();
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getPath() {
        return this.resource != null ? this.resource.getFullPath() : this.parent.getPath();
    }

    public CPElement getParent() {
        return this.parent;
    }

    public int getEntryKind() {
        return this.kind;
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0 instanceof CPElementGroup) {
            CPElementGroup other = (CPElementGroup)arg0;
            return this.kind == other.kind && (this.parent == null && other.parent == null || this.parent.equals(other.parent)) && (this.resource == null && other.resource == null || this.resource.equals((Object)other.resource));
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.parent != null ? this.parent.hashCode() : 0;
        return (hashCode += this.resource != null ? this.resource.hashCode() : 0) + this.kind;
    }

    public int indexof(CPElement element) {
        List children = this.getChildrenList(element.getEntryKind(), false);
        return children != null ? children.indexOf(element) : -1;
    }

    public void addChild(CPElement element, int insertIndex) {
        List children = this.getChildrenList(element.getEntryKind(), true);
        children.add(insertIndex, element);
        element.setParent(this);
    }

    public void addChild(CPElement element) {
        List children = this.getChildrenList(element.getEntryKind(), true);
        int indx = children.indexOf(element);
        if (indx == -1) {
            indx = children.size();
            if (element.getInherited() == null) {
                int i = 0;
                while (i < children.size()) {
                    CPElement next = (CPElement)children.get(i);
                    if (next.getInherited() != null) {
                        indx = i;
                        break;
                    }
                    ++i;
                }
            }
            children.add(indx, element);
            element.setParent(this);
        } else {
            IPath elemPath;
            IPath otherPath;
            CPElement other = (CPElement)children.get(indx);
            if (other.getInherited() != null && element.getInherited() != null && !(otherPath = other.getInherited().getPath()).equals((Object)(elemPath = element.getInherited().getPath())) && otherPath.isPrefixOf(elemPath)) {
                children.remove(indx);
                other.setParent(null);
                children.add(element);
                element.setParent(this);
            }
        }
    }

    public void setChildren(CPElement[] elements) {
        if (elements.length > 0) {
            if (this.childrenListMap != null) {
                this.childrenListMap.put(new Integer(elements[0].getEntryKind()), new ArrayList<CPElement>(Arrays.asList(elements)));
            } else {
                this.childrenList = new ArrayList<CPElement>(Arrays.asList(elements));
            }
        }
    }

    public void addChildren(CPElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.addChild(elements[i]);
            ++i;
        }
    }

    public boolean removeChild(CPElement element) {
        List children = this.getChildrenList(element.getEntryKind(), false);
        if (children == null) {
            return false;
        }
        boolean removed = children.remove(element);
        if (removed) {
            element.setParent(null);
        }
        return removed;
    }

    public CPElement[] getChildren(int kind) {
        List children = this.getChildrenList(kind, true);
        return children.toArray(new CPElement[children.size()]);
    }

    public CPElement[] getChildren() {
        if (this.childrenList != null) {
            return this.childrenList.toArray(new CPElement[this.childrenList.size()]);
        }
        Collection lists = this.childrenListMap.values();
        Iterator iter = lists.iterator();
        ArrayList children = new ArrayList();
        while (iter.hasNext()) {
            children.addAll((List)iter.next());
        }
        return children.toArray(new CPElement[children.size()]);
    }

    public boolean contains(CPElement element) {
        List children = this.getChildrenList(element.getEntryKind(), false);
        if (children == null) {
            return false;
        }
        return children.contains(element);
    }

    public void replaceChild(CPElement element, CPElement replaceWith) {
        List children = this.getChildrenList(element.getEntryKind(), false);
        if (children == null) {
            return;
        }
        int idx = children.indexOf(element);
        if (idx != -1) {
            children.remove(idx);
            children.add(idx, replaceWith);
        }
    }

    private List getChildrenList(int kind, boolean create) {
        List children = null;
        if (this.childrenList != null) {
            children = this.childrenList;
        } else {
            children = (List)this.childrenListMap.get(new Integer(kind));
            if (children == null && create) {
                children = new ArrayList();
                this.childrenListMap.put(new Integer(kind), children);
            }
        }
        return children;
    }
}

