/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Watchpoint
extends Breakpoint
implements ICDIWatchpoint {
    int watchType;
    String what;

    public Watchpoint(Target target, String expression, int type, int wType, ICDICondition cond) {
        super(target, type, null, cond);
        this.watchType = wType;
        this.what = expression;
    }

    public String getWatchExpression() throws CDIException {
        MIBreakpoint[] miPoints;
        if (this.what == null && (miPoints = this.getMIBreakpoints()) != null && miPoints.length > 0) {
            return miPoints[0].getWhat();
        }
        return this.what;
    }

    public boolean isReadType() {
        return (this.watchType & 2) == 2;
    }

    public boolean isWriteType() {
        return (this.watchType & 1) == 1;
    }
}

