/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private IWorkbenchPart fTargetPart;
    private ToggleBreakpointAdapter fBreakpointAdapter;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();

    public ToggleBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo ruler) {
        super(ActionMessages.getString("ToggleBreakpointRulerAction.Toggle_Breakpoint_1"));
        this.fRuler = ruler;
        this.setTargetPart(part);
        this.fBreakpointAdapter = new ToggleBreakpointAdapter();
        WorkbenchHelp.setHelp((IAction)this, (String)ICDebugHelpContextIds.TOGGLE_BREAKPOINT_ACTION);
        this.setId(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
    }

    public void dispose() {
        this.setTargetPart(null);
        this.fRuler = null;
    }

    public void run() {
        try {
            this.fBreakpointAdapter.toggleLineBreakpoints(this.getTargetPart(), this.getTargetSelection());
        }
        catch (CoreException e) {
            DebugUIPlugin.errorDialog((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("ToggleBreakpointRulerAction.Error_1"), (String)ActionMessages.getString("ToggleBreakpointRulerAction.Operation_failed_1"), (IStatus)e.getStatus());
        }
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private void setTargetPart(IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    private ISelection getTargetSelection() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            int line = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                IRegion region = doc.getLineInformation(line);
                return new TextSelection(doc, region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        return EMPTY_SELECTION;
    }

    private IDocument getDocument() {
        DisassemblyView dv;
        DisassemblyDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetPart;
            IDocumentProvider provider2 = textEditor.getDocumentProvider();
            if (provider2 != null) {
                return provider2.getDocument((Object)textEditor.getEditorInput());
            }
        } else if (targetPart instanceof DisassemblyView && (provider = (dv = (DisassemblyView)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument(dv.getInput());
        }
        return null;
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

