/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;

public class CContentOutlinerProvider
extends BaseCElementContentProvider {
    CContentOutlinePage fOutliner;
    ITranslationUnit root;
    private ElementChangedListener fListener;
    private IPropertyChangeListener fPropertyListener;

    public CContentOutlinerProvider(CContentOutlinePage outliner) {
        super(true, true);
        this.fOutliner = outliner;
        this.setIncludesGrouping(PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupincludes"));
    }

    public void dispose() {
        super.dispose();
        if (this.fListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
        if (this.fPropertyListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean isTU = newInput instanceof ITranslationUnit;
        if (isTU && this.fListener == null) {
            this.root = (ITranslationUnit)newInput;
            this.fListener = new ElementChangedListener();
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fListener);
            this.fPropertyListener = new PropertyListener();
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        } else if (!isTU && this.fListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
            this.root = null;
        }
    }

    class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            ICElementDelta delta = this.findElement((ICElement)CContentOutlinerProvider.this.root, e.getDelta());
            if (delta != null && CContentOutlinerProvider.this.fOutliner != null) {
                CContentOutlinerProvider.this.fOutliner.contentUpdated();
                return;
            }
        }

        private boolean isPossibleStructuralChange(ICElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x400001) == 1;
        }

        protected ICElementDelta findElement(ICElement unit, ICElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            ICElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 60) {
                return null;
            }
            ICElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                ICElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    class PropertyListener
    implements IPropertyChangeListener {
        PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object newValue;
            String prop = event.getProperty();
            if (prop.equals("org.eclipse.cdt.ui.outline.groupincludes")) {
                Object newValue2 = event.getNewValue();
                if (newValue2 instanceof Boolean) {
                    boolean value = (Boolean)newValue2;
                    if (CContentOutlinerProvider.this.areIncludesGroup() != value) {
                        CContentOutlinerProvider.this.setIncludesGrouping(value);
                        if (CContentOutlinerProvider.this.fOutliner != null) {
                            CContentOutlinerProvider.this.fOutliner.contentUpdated();
                        }
                    }
                }
            } else if (prop.equals("org.eclipse.cdt.ui.outline.groupnamespaces") && (newValue = event.getNewValue()) instanceof Boolean) {
                boolean value = (Boolean)newValue;
                if (CContentOutlinerProvider.this.areNamespacesGroup() != value) {
                    CContentOutlinerProvider.this.setNamespacesGrouping(value);
                    if (CContentOutlinerProvider.this.fOutliner != null) {
                        CContentOutlinerProvider.this.fOutliner.contentUpdated();
                    }
                }
            }
        }
    }
}

